/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.util.urltemplate.Fragment;
import org.apache.knox.gateway.util.urltemplate.Host;
import org.apache.knox.gateway.util.urltemplate.Password;
import org.apache.knox.gateway.util.urltemplate.Path;
import org.apache.knox.gateway.util.urltemplate.Port;
import org.apache.knox.gateway.util.urltemplate.Query;
import org.apache.knox.gateway.util.urltemplate.Scheme;
import org.apache.knox.gateway.util.urltemplate.Segment;
import org.apache.knox.gateway.util.urltemplate.Username;

public class Template {
    private String original;
    private Scheme scheme;
    private boolean hasScheme;
    private Username username;
    private Password password;
    private Host host;
    private Port port;
    private boolean hasAuthority;
    private boolean isAuthorityOnly;
    private List<Path> path;
    private boolean isAbsolute;
    private boolean isDirectory;
    private Map<String, Query> query;
    private Query extra;
    private boolean hasQuery;
    private Fragment fragment;
    private boolean hasFragment;
    private Integer hash;

    Template(String original, Scheme scheme, boolean hasScheme, Username username, Password password, Host host, Port port, boolean hasAuthority, boolean isAuthorityOnly, List<Path> path, boolean isAbsolute, boolean isDirectory, LinkedHashMap<String, Query> query, Query extra, boolean hasQuery, Fragment fragment, boolean hasFragment) {
        this.original = original;
        this.scheme = scheme;
        this.hasScheme = hasScheme;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.hasAuthority = hasAuthority;
        this.isAuthorityOnly = isAuthorityOnly;
        this.path = Collections.unmodifiableList(path);
        this.isAbsolute = isAbsolute;
        this.isDirectory = isDirectory;
        this.query = Collections.unmodifiableMap(query);
        this.extra = extra;
        this.hasQuery = hasQuery;
        this.fragment = fragment;
        this.hasFragment = hasFragment;
        this.hash = null;
    }

    public String getPattern() {
        return this.original != null ? this.original : this.toString();
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public boolean hasScheme() {
        return this.hasScheme;
    }

    public Username getUsername() {
        return this.username;
    }

    public Password getPassword() {
        return this.password;
    }

    public Host getHost() {
        return this.host;
    }

    public Port getPort() {
        return this.port;
    }

    public boolean hasAuthority() {
        return this.hasAuthority;
    }

    public boolean isAuthorityOnly() {
        return this.isAuthorityOnly;
    }

    public List<Path> getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public Map<String, Query> getQuery() {
        return this.query;
    }

    public Query getExtra() {
        return this.extra;
    }

    public boolean hasQuery() {
        return this.hasQuery;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public boolean hasFragment() {
        return this.hasFragment;
    }

    private void buildScheme(StringBuilder b) {
        if (this.hasScheme) {
            if (this.scheme != null) {
                this.buildSegmentValue(b, this.scheme, this.scheme.getFirstValue());
            }
            b.append(':');
        }
    }

    private void buildAuthority(StringBuilder b) {
        if (this.hasAuthority) {
            if (!this.isAuthorityOnly) {
                b.append("//");
            }
            if (this.username != null || this.password != null) {
                if (this.username != null) {
                    this.buildSegmentValue(b, this.username, this.username.getFirstValue());
                }
                if (this.password != null) {
                    b.append(':');
                    this.buildSegmentValue(b, this.password, this.password.getFirstValue());
                }
                b.append("@");
            }
            if (this.host != null) {
                this.buildSegmentValue(b, this.host, this.host.getFirstValue());
            }
            if (this.port != null) {
                b.append(':');
                this.buildSegmentValue(b, this.port, this.port.getFirstValue());
            }
        }
    }

    private void buildSegmentValue(StringBuilder b, Segment s, Segment.Value v) {
        String paramName = s.getParamName();
        if (paramName != null && paramName.length() > 0) {
            b.append("{");
            b.append(s.getParamName());
            String actualPattern = v.getToken().originalPattern;
            if (actualPattern != null && v.getType() != 4) {
                b.append('=');
                b.append(v.getOriginalPattern());
            }
            b.append('}');
        } else {
            b.append(s.getFirstValue().getOriginalPattern());
        }
    }

    private void buildPath(StringBuilder b) {
        if (this.isAbsolute) {
            b.append('/');
        }
        boolean first = true;
        for (Path segment : this.path) {
            if (first) {
                first = false;
            } else {
                b.append('/');
            }
            String paramName = segment.getParamName();
            Segment.Value firstValue = segment.getFirstValue();
            if (paramName != null && paramName.length() > 0) {
                b.append("{");
                b.append(segment.getParamName());
                String pattern = firstValue.getOriginalPattern();
                if (pattern != null && !pattern.isEmpty()) {
                    b.append('=');
                    b.append(firstValue);
                }
                b.append('}');
                continue;
            }
            b.append(firstValue.getOriginalPattern());
        }
        if (!(!this.isDirectory || this.isAbsolute && this.path.isEmpty())) {
            b.append('/');
        }
    }

    private void buildQuery(StringBuilder b) {
        if (this.hasQuery) {
            int count = 0;
            for (Query segment : this.query.values()) {
                for (Segment.Value value : segment.getValues()) {
                    if (++count == 1) {
                        b.append('?');
                    } else {
                        b.append('&');
                    }
                    this.buildQuerySegment(b, segment, value);
                }
            }
            if (this.extra != null) {
                if (++count == 1) {
                    b.append('?');
                } else {
                    b.append('&');
                }
                this.buildQuerySegment(b, this.extra, this.extra.getFirstValue());
            }
            if (count == 0) {
                b.append('?');
            }
        }
    }

    private void buildQuerySegment(StringBuilder b, Query segment, Segment.Value value) {
        String paramName = segment.getParamName();
        String queryName = segment.getQueryName();
        String valuePattern = value.getOriginalPattern();
        if (paramName != null && paramName.length() > 0) {
            if (!"**".equals(queryName) && !"*".equals(queryName)) {
                b.append(segment.getQueryName());
                b.append("=");
            }
            b.append("{");
            b.append(segment.getParamName());
            if (valuePattern != null) {
                b.append('=');
                b.append(valuePattern);
            }
            b.append('}');
        } else {
            b.append(queryName);
            if (valuePattern != null) {
                b.append("=");
                b.append(valuePattern);
            }
        }
    }

    private void buildFragment(StringBuilder b) {
        if (this.hasFragment) {
            b.append('#');
            if (this.fragment != null) {
                b.append(this.fragment.getFirstValue().getOriginalPattern());
            }
        }
    }

    public String toString() {
        String s = null;
        StringBuilder b = new StringBuilder();
        this.buildScheme(b);
        this.buildAuthority(b);
        this.buildPath(b);
        this.buildQuery(b);
        this.buildFragment(b);
        s = b.toString();
        return s;
    }

    public int hashCode() {
        Integer hc = this.hash;
        if (hc == null) {
            this.hash = hc = Integer.valueOf(this.toString().hashCode());
        }
        return hc;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object != null && object instanceof Template) {
            String thisStr = this.toString();
            String thatStr = object.toString();
            equals = thisStr.equals(thatStr);
        }
        return equals;
    }
}

