/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.GatewayPropertyInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;
import org.apache.knox.gateway.topology.builder.property.interpreter.ServicePropertyInterpreter;

public class TopologyPropertyInterpreter
extends AbstractInterpreter {
    private static final String TOPOLOGY_NAME = "name";
    private static final String AGGREGATOR_GATEWAY = "gateway";
    private static final String AGGREGATOR_SERVICE = "service";
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private Topology topology;

    public TopologyPropertyInterpreter(Topology topology) {
        if (topology == null) {
            throw new IllegalArgumentException(gatewayResources.topologyIsRequiredError());
        }
        this.topology = topology;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void interpret(String token, String value) throws InterpretException {
        if (TOPOLOGY_NAME.equalsIgnoreCase(token)) {
            this.topology.setName(value);
            return;
        } else {
            int firstDotPosition = token.indexOf(".");
            if (firstDotPosition == -1) throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            String aggregator = token.substring(0, firstDotPosition);
            String nextToken = token.substring(firstDotPosition + 1);
            if (AGGREGATOR_GATEWAY.equals(aggregator)) {
                new GatewayPropertyInterpreter(this.topology).interpret(nextToken, value);
                return;
            } else {
                if (!AGGREGATOR_SERVICE.equals(aggregator)) throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
                new ServicePropertyInterpreter(this.topology).interpret(nextToken, value);
            }
        }
    }
}

