/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;

public class DefaultCryptoService
implements CryptoService {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private AliasService as = null;
    private KeystoreService ks = null;
    private HashMap<String, ConfigurableEncryptor> encryptorCache = new HashMap();
    private GatewayConfig config = null;

    public void setKeystoreService(KeystoreService ks) {
        this.ks = ks;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        if (this.as == null) {
            throw new ServiceLifecycleException("Alias service is not set");
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public void createAndStoreEncryptionKeyForCluster(String clusterName, String alias) {
        try {
            this.as.generateAliasForCluster(clusterName, alias);
        }
        catch (AliasServiceException e) {
            e.printStackTrace();
        }
    }

    public EncryptionResult encryptForCluster(String clusterName, String alias, byte[] clear) {
        char[] password = null;
        try {
            password = this.as.getPasswordFromAliasForCluster(clusterName, alias);
        }
        catch (AliasServiceException e2) {
            e2.printStackTrace();
        }
        if (password != null) {
            try {
                return this.getEncryptor(clusterName, password).encrypt(clear);
            }
            catch (NoSuchAlgorithmException e1) {
                LOG.failedToEncryptPasswordForCluster(clusterName, e1);
            }
            catch (InvalidKeyException e) {
                LOG.failedToEncryptPasswordForCluster(clusterName, e);
            }
            catch (Exception e) {
                LOG.failedToEncryptPasswordForCluster(clusterName, e);
            }
        }
        return null;
    }

    public byte[] decryptForCluster(String clusterName, String alias, String cipherText) {
        return this.decryptForCluster(clusterName, alias, cipherText.getBytes(StandardCharsets.UTF_8), null, null);
    }

    public byte[] decryptForCluster(String clusterName, String alias, byte[] cipherText, byte[] iv, byte[] salt) {
        try {
            char[] password = null;
            ConfigurableEncryptor encryptor = null;
            password = this.as.getPasswordFromAliasForCluster(clusterName, alias);
            if (password != null) {
                encryptor = this.getEncryptor(clusterName, password);
                try {
                    return encryptor.decrypt(salt, iv, cipherText);
                }
                catch (Exception e) {
                    LOG.failedToDecryptPasswordForCluster(clusterName, e);
                }
            } else {
                LOG.failedToDecryptCipherForClusterNullPassword(clusterName);
            }
        }
        catch (AliasServiceException e1) {
            LOG.failedToDecryptCipherForClusterNullPassword(clusterName);
        }
        return null;
    }

    public boolean verify(String algorithm, String alias, String signed, byte[] signature) {
        boolean verified = false;
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initVerify(this.ks.getKeystoreForGateway().getCertificate(alias).getPublicKey());
            sig.update(signed.getBytes(StandardCharsets.UTF_8));
            verified = sig.verify(signature);
        }
        catch (SignatureException e) {
            LOG.failedToVerifySignature(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.failedToVerifySignature(e);
        }
        catch (InvalidKeyException e) {
            LOG.failedToVerifySignature(e);
        }
        catch (KeyStoreException e) {
            LOG.failedToVerifySignature(e);
        }
        catch (KeystoreServiceException e) {
            LOG.failedToVerifySignature((Exception)((Object)e));
        }
        LOG.signatureVerified(verified);
        return verified;
    }

    public byte[] sign(String algorithm, String alias, String payloadToSign) {
        try {
            char[] passphrase = null;
            passphrase = this.as.getGatewayIdentityPassphrase();
            PrivateKey privateKey = (PrivateKey)this.ks.getKeyForGateway(alias, passphrase);
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(payloadToSign.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.failedToSignData(e);
        }
        catch (InvalidKeyException e) {
            LOG.failedToSignData(e);
        }
        catch (SignatureException e) {
            LOG.failedToSignData(e);
        }
        catch (KeystoreServiceException e) {
            LOG.failedToSignData((Exception)((Object)e));
        }
        catch (AliasServiceException e) {
            LOG.failedToSignData((Exception)((Object)e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ConfigurableEncryptor getEncryptor(String clusterName, char[] password) {
        HashMap<String, ConfigurableEncryptor> hashMap = this.encryptorCache;
        synchronized (hashMap) {
            ConfigurableEncryptor encryptor = this.encryptorCache.get(clusterName);
            if (encryptor == null) {
                encryptor = new ConfigurableEncryptor(String.valueOf(password));
                encryptor.init(this.config);
                this.encryptorCache.put(clusterName, encryptor);
            }
            return encryptor;
        }
    }
}

