/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.metrics.impl;

import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.metrics.InstrumentationProvider;
import org.apache.knox.gateway.services.metrics.InstrumentationProviderDescriptor;
import org.apache.knox.gateway.services.metrics.MetricsContext;
import org.apache.knox.gateway.services.metrics.MetricsReporter;
import org.apache.knox.gateway.services.metrics.MetricsReporterException;
import org.apache.knox.gateway.services.metrics.MetricsService;
import org.apache.knox.gateway.services.metrics.impl.DefaultMetricsContext;

public class DefaultMetricsService
implements MetricsService {
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final MetricRegistry metrics = new MetricRegistry();
    public static final String METRICS_REGISTRY = "metrics-registry";
    private Map<Class<?>, InstrumentationProvider> instrumentationProviders;
    private ArrayList<MetricsReporter> metricsReporters;
    private MetricsContext context;
    private GatewayConfig config;

    public static MetricRegistry getMetricRegistry() {
        return metrics;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        this.context = new DefaultMetricsContext(this);
        this.context.setProperty(METRICS_REGISTRY, (Object)DefaultMetricsService.getMetricRegistry());
        this.instrumentationProviders = new HashMap();
        this.metricsReporters = new ArrayList();
        if (config.isMetricsEnabled()) {
            this.loadInstrumentationProviders();
            this.loadAndInitReporters(config);
        }
    }

    private void loadInstrumentationProviders() {
        ServiceLoader<InstrumentationProviderDescriptor> descriptors = ServiceLoader.load(InstrumentationProviderDescriptor.class);
        Iterator<InstrumentationProviderDescriptor> descriptorIterator = descriptors.iterator();
        while (descriptorIterator.hasNext()) {
            this.instrumentationProviders.putAll(descriptorIterator.next().providesInstrumentation());
        }
    }

    private void loadAndInitReporters(GatewayConfig config) {
        ServiceLoader<MetricsReporter> reporters = ServiceLoader.load(MetricsReporter.class);
        for (MetricsReporter metricsReporter : reporters) {
            try {
                metricsReporter.init(config);
                this.metricsReporters.add(metricsReporter);
            }
            catch (MetricsReporterException e) {
                LOG.failedToInitializeReporter(metricsReporter.getName(), (Exception)((Object)e));
            }
        }
    }

    public void start() throws ServiceLifecycleException {
        if (this.config.isMetricsEnabled()) {
            for (MetricsReporter reporter : this.metricsReporters) {
                if (!reporter.isEnabled()) continue;
                try {
                    reporter.start(this.context);
                }
                catch (MetricsReporterException e) {
                    LOG.failedToStartReporter(reporter.getName(), (Exception)((Object)e));
                }
            }
        }
    }

    public void stop() throws ServiceLifecycleException {
        if (this.config.isMetricsEnabled()) {
            for (MetricsReporter reporter : this.metricsReporters) {
                if (!reporter.isEnabled()) continue;
                try {
                    reporter.stop();
                }
                catch (MetricsReporterException e) {
                    LOG.failedToStopReporter(reporter.getName(), (Exception)((Object)e));
                }
            }
        }
    }

    public <T> T getInstrumented(T instanceClass) {
        InstrumentationProvider instrumentationProvider = this.instrumentationProviders.get(instanceClass.getClass());
        if (instrumentationProvider == null) {
            return null;
        }
        return (T)instrumentationProvider.getInstrumented(instanceClass, this.context);
    }

    public <T> T getInstrumented(Class<T> clazz) {
        InstrumentationProvider instrumentationProvider = this.instrumentationProviders.get(clazz);
        if (instrumentationProvider == null) {
            return null;
        }
        return (T)instrumentationProvider.getInstrumented(this.context);
    }

    public Map<Class<?>, InstrumentationProvider> getInstrumentationProviders() {
        return this.instrumentationProviders;
    }

    public ArrayList<MetricsReporter> getMetricsReporters() {
        return this.metricsReporters;
    }

    public MetricsContext getContext() {
        return this.context;
    }
}

