/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.logging.AbstractSessionLog;

public abstract class TypeImpl<X>
implements Type<X>,
Serializable {
    private Class<X> javaClass;
    private String javaClassName;

    protected TypeImpl(Class<X> javaClass) {
        this(javaClass, null);
    }

    protected TypeImpl(Class<X> javaClass, String javaClassName) {
        if (javaClass == null && javaClassName == null) {
            AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_typeImpl_javaClass_should_not_be_null", (Object)this, null);
            this.javaClass = MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
        } else {
            this.javaClassName = javaClassName;
            this.javaClass = javaClass;
        }
    }

    public Class<X> getJavaType(ClassLoader classLoader) {
        block6: {
            if (this.javaClass == null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.javaClass = AccessController.doPrivileged(new PrivilegedClassForName(this.javaClassName, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.javaClassName, exception.getException());
                        }
                    }
                    this.javaClass = PrivilegedAccessHelper.getClassForName(this.javaClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.javaClassName, exc);
                }
            }
        }
        return this.javaClass;
    }

    @Override
    public Class<X> getJavaType() {
        if (this.javaClass == null) {
            this.javaClass = ConversionManager.getDefaultManager().convertClassNameToClass(this.javaClassName);
        }
        return this.javaClass;
    }

    public String getJavaTypeName() {
        return this.javaClassName;
    }

    public abstract boolean isEntity();

    protected abstract boolean isIdentifiableType();

    protected abstract boolean isManagedType();

    public abstract boolean isMappedSuperclass();

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(this.getClass().getSimpleName());
        aBuffer.append("@");
        aBuffer.append(this.hashCode());
        if (this.getJavaType() != null) {
            aBuffer.append(":");
            aBuffer.append(this.getJavaType().getSimpleName());
        }
        aBuffer.append(" [ javaType: ");
        aBuffer.append(this.getJavaType());
        this.toStringHelper(aBuffer);
        aBuffer.append("]");
        return aBuffer.toString();
    }

    protected abstract void toStringHelper(StringBuffer var1);
}

