/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.shell.CredentialCollector;

public class Credentials {
    ArrayList<CredentialCollector> collectors = new ArrayList();

    public Credentials add(String collectorType, String prompt, String name) throws CredentialCollectionException {
        CredentialCollector collector = this.loadCredentialCollector(collectorType, prompt, name);
        if (collector == null) {
            throw new CredentialCollectionException("Invalid Collector Requested. Type: " + collectorType + " Name: " + name);
        }
        collector.setPrompt(prompt);
        collector.setName(name);
        this.collectors.add(collector);
        return this;
    }

    public void collect() throws CredentialCollectionException {
        for (CredentialCollector collector : this.collectors) {
            collector.collect();
        }
    }

    public CredentialCollector get(String name) {
        for (CredentialCollector collector : this.collectors) {
            if (!collector.name().equals(name)) continue;
            return collector;
        }
        return null;
    }

    private CredentialCollector loadCredentialCollector(String type, String prompt, String name) {
        ServiceLoader<CredentialCollector> collectorsList = ServiceLoader.load(CredentialCollector.class);
        for (CredentialCollector collector : collectorsList) {
            if (!collector.type().equals(type)) continue;
            return collector;
        }
        return null;
    }
}

