/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer;

import java.util.Collection;
import org.pac4j.core.authorization.authorizer.AbstractRequireAnyAuthorizer;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class RequireAnyAttributeAuthorizer<U extends CommonProfile>
extends AbstractRequireAnyAuthorizer<String, U> {
    private final String valueToMatch;

    public RequireAnyAttributeAuthorizer() {
        this(".+");
    }

    public RequireAnyAttributeAuthorizer(String valueToMatch) {
        this.valueToMatch = valueToMatch;
    }

    @Override
    protected boolean check(WebContext context, U profile, String element) {
        if (!((UserProfile)profile).containsAttribute(element)) {
            return false;
        }
        if (CommonHelper.isBlank(this.valueToMatch)) {
            return true;
        }
        Object attributeValues = ((UserProfile)profile).getAttribute(element);
        if (attributeValues instanceof Collection) {
            return ((Collection)Collection.class.cast(attributeValues)).stream().filter(v -> v.toString().matches(this.valueToMatch)).findAny().isPresent();
        }
        return attributeValues.toString().matches(this.valueToMatch);
    }
}

