/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.filter;

import java.util.Properties;
import org.apache.log4j.extras.DOMConfigurator;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public class AndFilter
extends Filter
implements UnrecognizedElementHandler {
    Filter headFilter = null;
    Filter tailFilter = null;
    boolean acceptOnMatch = true;

    @Override
    public void activateOptions() {
    }

    public void addFilter(Filter filter) {
        if (this.headFilter == null) {
            this.headFilter = filter;
            this.tailFilter = filter;
        } else {
            this.tailFilter.next = filter;
        }
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    @Override
    public int decide(LoggingEvent event) {
        boolean accepted = true;
        Filter f = this.headFilter;
        while (f != null) {
            accepted = accepted && 1 == f.decide(event);
            f = f.next;
        }
        if (accepted) {
            if (this.acceptOnMatch) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        String nodeName = element.getNodeName();
        if ("filter".equals(nodeName)) {
            OptionHandler filter = DOMConfigurator.parseElement(element, props, Filter.class);
            if (filter instanceof Filter) {
                filter.activateOptions();
                this.addFilter((Filter)filter);
            }
            return true;
        }
        return false;
    }
}

