/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringDeploymentListener
implements ArtifactUrlTransformer {
    private static final QName SPRING_DM_ROOT = new QName("http://www.springframework.org/schema/beans", "beans");
    private final Logger logger = LoggerFactory.getLogger(SpringDeploymentListener.class);
    private XMLInputFactory factory;

    public boolean canHandle(File artifact) {
        try {
            StartElement element;
            if (artifact.isFile() && artifact.getName().endsWith(".xml") && (element = this.getRootElement(artifact)) != null && SPRING_DM_ROOT.equals(element.getName())) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to parse deployed file " + artifact.getAbsolutePath(), (Throwable)e);
        }
        return false;
    }

    public URL transform(URL artifact) {
        try {
            return new URL("spring", null, artifact.toString());
        }
        catch (Exception e) {
            this.logger.error("Unable to build spring application bundle", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StartElement getRootElement(File artifact) throws Exception {
        XMLEventReader parser = null;
        FileInputStream in = null;
        try {
            if (this.factory == null) {
                this.factory = XMLInputFactory.newInstance();
            }
            in = new FileInputStream(artifact);
            parser = this.factory.createXMLEventReader(in);
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement startElement = event.asStartElement();
                return startElement;
            }
            StartElement startElement = null;
            return startElement;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }
}

