/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import com.github.weisj.darklaf.ui.toolbar.DarkToolBarUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class DarkToolBarBorder
extends AbstractBorder
implements UIResource,
SwingConstants {
    protected final Icon horizontalGrip = UIManager.getIcon("ToolBar.horizontalGrip.icon");
    protected final Icon verticalGrip = UIManager.getIcon("ToolBar.verticalGrip.icon");
    protected final Color borderColor = UIManager.getColor("ToolBar.borderColor");
    protected final Insets gripInsets = UIManager.getInsets("ToolBar.gripInsets");

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        if (this.isFloatable(c)) {
            Icon icon;
            if (((JToolBar)c).getOrientation() == 0) {
                icon = this.getHorizontalGrip();
                int yIcon = h / 2 - icon.getIconHeight() / 2;
                if (c.getComponentOrientation().isLeftToRight()) {
                    icon.paintIcon(c, g, this.gripInsets.left, yIcon);
                } else {
                    icon.paintIcon(c, g, w - icon.getIconWidth() - this.gripInsets.right, yIcon);
                }
            } else {
                icon = this.getVerticalGrip();
                int xIcon = w / 2 - icon.getIconWidth() / 2;
                icon.paintIcon(c, g, xIcon, this.gripInsets.top);
            }
        }
        if (this.isDocked(c)) {
            String constraints = this.getDockedConstrains(c);
            JToolBar toolBar = (JToolBar)c;
            g.setColor(this.borderColor);
            if (toolBar.getOrientation() == 0) {
                if ("North".equals(constraints) || "First".equals(constraints)) {
                    g.fillRect(0, toolBar.getHeight() - 1, toolBar.getWidth(), 1);
                } else if ("South".equals(constraints) || "Last".equals(constraints)) {
                    g.fillRect(0, 0, toolBar.getWidth(), 1);
                }
            } else if ("West".equals(constraints) || "Before".equals(constraints)) {
                g.fillRect(toolBar.getWidth() - 1, 0, 1, toolBar.getHeight());
            } else if ("East".equals(constraints) || "After".equals(constraints)) {
                g.fillRect(0, 0, 1, toolBar.getHeight());
            }
        }
        g.translate(-x, -y);
    }

    private boolean isDocked(Component c) {
        if (c instanceof JToolBar && ((JToolBar)c).getUI() instanceof DarkToolBarUI) {
            return !((DarkToolBarUI)((JToolBar)c).getUI()).isFloating();
        }
        return false;
    }

    private String getDockedConstrains(Component c) {
        BorderLayout layout;
        Object constraints;
        Container parent;
        if (c instanceof JComponent && (parent = c.getParent()) instanceof JComponent && ((JComponent)parent).getLayout() instanceof BorderLayout && (constraints = (layout = (BorderLayout)((JComponent)parent).getLayout()).getConstraints(c)) != null) {
            return constraints.toString();
        }
        return "";
    }

    private boolean isFloatable(Component c) {
        return c instanceof JToolBar && ((JToolBar)c).isFloatable();
    }

    protected Icon getHorizontalGrip() {
        return this.horizontalGrip;
    }

    protected Icon getVerticalGrip() {
        return this.verticalGrip;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        Insets margin;
        if (this.isFloatable(c)) {
            if (((JToolBar)c).getOrientation() == 0) {
                Icon icon = this.getHorizontalGrip();
                if (c.getComponentOrientation().isLeftToRight()) {
                    newInsets.left = icon.getIconWidth() + this.gripInsets.left + this.gripInsets.right;
                } else {
                    newInsets.right = icon.getIconWidth() + this.gripInsets.left + this.gripInsets.right;
                }
            } else {
                newInsets.top = this.getVerticalGrip().getIconHeight() + this.gripInsets.top + this.gripInsets.bottom;
            }
        }
        if (c instanceof JToolBar && (margin = ((JToolBar)c).getMargin()) != null) {
            newInsets.left += margin.left;
            newInsets.top += margin.top;
            newInsets.right += margin.right;
            newInsets.bottom += margin.bottom;
        }
        if (c instanceof JToolBar && this.isDocked(c)) {
            String constraints = this.getDockedConstrains(c);
            if (((JToolBar)c).getOrientation() == 0) {
                if ("North".equals(constraints)) {
                    ++newInsets.bottom;
                } else if ("South".equals(constraints)) {
                    ++newInsets.top;
                }
            } else if ("West".equals(constraints)) {
                ++newInsets.right;
            } else if ("East".equals(constraints)) {
                ++newInsets.left;
            }
        }
        return newInsets;
    }
}

