/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.AbstractLibrary;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;

public class WindowsLibrary
extends AbstractLibrary {
    private static final String PATH = "/com/github/weisj/darklaf/platform/darklaf-windows/";
    private static final String DLL_NAME = "darklaf-windows.dll";
    private static final String x86_PATH = "windows-x86/";
    private static final String x86_64_PATH = "windows-x86-64/";
    private static final WindowsLibrary library = new WindowsLibrary();

    public static WindowsLibrary get() {
        return library;
    }

    protected WindowsLibrary() {
        super(PATH, DLL_NAME, LogUtil.getLogger(WindowsLibrary.class));
    }

    public String getX86Path() {
        return super.getPath() + x86_PATH;
    }

    public String getX64Path() {
        return super.getPath() + x86_64_PATH;
    }

    protected String getPath() {
        if (SystemInfo.isX86) {
            return this.getX86Path();
        }
        if (SystemInfo.isX64) {
            return this.getX64Path();
        }
        throw new IllegalStateException("Unsupported arch");
    }

    protected boolean canLoad() {
        return !SystemInfo.undefinedArchitecture && SystemInfo.isX86Compatible && SystemInfo.isWindows10;
    }
}

