/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SubtreeDeleteRequestControl
extends Control {
    @NotNull
    public static final String SUBTREE_DELETE_REQUEST_OID = "1.2.840.113556.1.4.805";
    private static final long serialVersionUID = 3748121547717081961L;

    public SubtreeDeleteRequestControl() {
        super(SUBTREE_DELETE_REQUEST_OID, false, null);
    }

    public SubtreeDeleteRequestControl(boolean isCritical) {
        super(SUBTREE_DELETE_REQUEST_OID, isCritical, null);
    }

    public SubtreeDeleteRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUBTREE_DELETE_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SUBTREE_DELETE_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", SUBTREE_DELETE_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SUBTREE_DELETE_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static SubtreeDeleteRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new SubtreeDeleteRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SubtreeDeleteRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

