/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.MacroExpand;
import org.apache.james.jspf.core.MacroExpandEnabled;
import org.apache.james.jspf.core.SPFCheckEnabled;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.ConfigurationEnabled;
import org.apache.james.jspf.terms.Mechanism;

public class IncludeMechanism
implements Mechanism,
ConfigurationEnabled,
SPFCheckEnabled,
MacroExpandEnabled {
    public static final String REGEX = "[iI][nN][cC][lL][uU][dD][eE]\\:((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)))";
    protected String host;
    private SPFChecker spfChecker;
    private MacroExpand macroExpand;

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        spfData.increaseCurrentDepth();
        SPFChecker cleanupAndResultHandler = new CleanupAndResultChecker().init(spfData);
        spfData.pushChecker(cleanupAndResultHandler);
        spfData.pushChecker(new ExpandedChecker());
        return this.macroExpand.checkExpand(this.getHost(), spfData, false);
    }

    @Override
    public synchronized void config(Configuration params) throws PermErrorException {
        if (params.groupCount() == 0) {
            throw new PermErrorException("Include mechanism without an host");
        }
        this.host = params.group(1);
    }

    protected synchronized String getHost() {
        return this.host;
    }

    public String toString() {
        return "include:" + this.getHost();
    }

    @Override
    public void enableSPFChecking(SPFChecker checker) {
        this.spfChecker = checker;
    }

    @Override
    public void enableMacroExpand(MacroExpand macroExpand) {
        this.macroExpand = macroExpand;
    }

    private final class CleanupAndResultChecker
    implements SPFChecker,
    SPFCheckerExceptionCatcher {
        private String previousResult;
        private String previousResultExpanded;
        private String previousDomain;

        private CleanupAndResultChecker() {
        }

        private void restoreSession(SPFSession spfData) {
            spfData.setIgnoreExplanation(false);
            spfData.setCurrentDomain(this.previousDomain);
            spfData.setCurrentResult(this.previousResult);
            spfData.setCurrentResultExpanded(this.previousResultExpanded);
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            String currentResult = spfData.getCurrentResult();
            this.restoreSession(spfData);
            if (currentResult == null) {
                throw new TempErrorException("included checkSPF returned null");
            }
            if (currentResult.equals("+")) {
                spfData.setAttribute("Mechanism.result", Boolean.TRUE);
            } else if (currentResult.equals("-") || currentResult.equals("~") || currentResult.equals("?")) {
                spfData.setAttribute("Mechanism.result", Boolean.FALSE);
            } else {
                throw new TempErrorException("included checkSPF returned an Illegal result");
            }
            return null;
        }

        @Override
        public void onException(Throwable exception, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            this.restoreSession(session);
            if (exception instanceof NeutralException) {
                throw new PermErrorException("included checkSPF returned NeutralException");
            }
            if (exception instanceof NoneException) {
                throw new PermErrorException("included checkSPF returned NoneException");
            }
            if (exception instanceof PermErrorException) {
                throw (PermErrorException)exception;
            }
            if (exception instanceof TempErrorException) {
                throw (TempErrorException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalStateException(exception.getMessage());
        }

        public SPFChecker init(SPFSession spfSession) {
            this.previousResult = spfSession.getCurrentResult();
            this.previousDomain = spfSession.getCurrentDomain();
            this.previousResultExpanded = spfSession.getCurrentResultExpanded();
            return this;
        }
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private ExpandedChecker() {
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException {
            String host = IncludeMechanism.this.macroExpand.expand(IncludeMechanism.this.getHost(), spfData, false);
            spfData.setCurrentDomain(host);
            spfData.setIgnoreExplanation(true);
            spfData.setCurrentResult(null);
            spfData.setCurrentResultExpanded(null);
            spfData.pushChecker(IncludeMechanism.this.spfChecker);
            return null;
        }
    }
}

