/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.memory;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;

public class InMemorySieveQuotaRepository
implements SieveQuotaRepository {
    private Optional<QuotaSizeLimit> globalQuota = Optional.empty();
    private Map<Username, QuotaSizeLimit> userQuota = new ConcurrentHashMap<Username, QuotaSizeLimit>();

    public synchronized boolean hasDefaultQuota() {
        return this.globalQuota.isPresent();
    }

    public synchronized QuotaSizeLimit getDefaultQuota() throws QuotaNotFoundException {
        return this.globalQuota.orElseThrow(QuotaNotFoundException::new);
    }

    public synchronized void setDefaultQuota(QuotaSizeLimit quota) {
        this.globalQuota = Optional.of(quota);
    }

    public synchronized void removeQuota() throws QuotaNotFoundException {
        if (!this.globalQuota.isPresent()) {
            throw new QuotaNotFoundException();
        }
        this.globalQuota = Optional.empty();
    }

    public synchronized boolean hasQuota(Username username) {
        return this.userQuota.containsKey(username);
    }

    public QuotaSizeLimit getQuota(Username username) throws QuotaNotFoundException {
        return Optional.ofNullable(this.userQuota.get(username)).orElseThrow(QuotaNotFoundException::new);
    }

    public synchronized void setQuota(Username username, QuotaSizeLimit quota) {
        this.userQuota.put(username, quota);
    }

    public synchronized void removeQuota(Username username) throws QuotaNotFoundException {
        Optional<QuotaSizeLimit> quotaValue = Optional.ofNullable(this.userQuota.get(username));
        if (!quotaValue.isPresent()) {
            throw new QuotaNotFoundException();
        }
        this.userQuota.remove(username);
    }
}

