/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.mail;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobPartsId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobType;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.server.core.MailHeaders;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class MimeMessageStore {
    public static Factory factory(BlobStore blobStore) {
        return new Factory(blobStore);
    }

    public static class Factory {
        private final BlobStore blobStore;

        @Inject
        public Factory(BlobStore blobStore) {
            this.blobStore = blobStore;
        }

        public Store<MimeMessage, MimeMessagePartsId> mimeMessageStore() {
            return this.mimeMessageStore(this.blobStore.getDefaultBucketName());
        }

        public Store<MimeMessage, MimeMessagePartsId> mimeMessageStore(BucketName bucketName) {
            return new Store.Impl((BlobPartsId.Factory)new MimeMessagePartsId.Factory(), (Store.Impl.Encoder)new MimeMessageEncoder(), (Store.Impl.Decoder)new MimeMessageDecoder(), this.blobStore, bucketName);
        }
    }

    private static class MimeMessageBytesSource
    implements MimeMessageSource,
    Disposable {
        private final Store.CloseableByteSource headers;
        private final Store.CloseableByteSource body;
        private final String sourceId;

        private MimeMessageBytesSource(Store.CloseableByteSource headers, Store.CloseableByteSource body) {
            this.headers = headers;
            this.body = body;
            this.sourceId = UUID.randomUUID().toString();
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public InputStream getInputStream() throws IOException {
            return new SequenceInputStream(this.headers.openStream(), this.body.openStream());
        }

        public long getMessageSize() throws IOException {
            return this.headers.size() + this.body.size();
        }

        public void dispose() {
            try {
                this.headers.close();
                this.body.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class MimeMessageDecoder
    implements Store.Impl.Decoder<MimeMessage> {
        MimeMessageDecoder() {
        }

        public MimeMessage decode(Map<BlobType, Store.CloseableByteSource> pairs) {
            Preconditions.checkNotNull(pairs);
            Preconditions.checkArgument((boolean)pairs.containsKey(MimeMessagePartsId.HEADER_BLOB_TYPE));
            Preconditions.checkArgument((boolean)pairs.containsKey(MimeMessagePartsId.BODY_BLOB_TYPE));
            return this.toMimeMessage(pairs.get(MimeMessagePartsId.HEADER_BLOB_TYPE), pairs.get(MimeMessagePartsId.BODY_BLOB_TYPE));
        }

        private MimeMessage toMimeMessage(Store.CloseableByteSource headers, Store.CloseableByteSource body) {
            return new MimeMessageWrapper((MimeMessageSource)new MimeMessageBytesSource(headers, body));
        }
    }

    static class MimeMessageEncoder
    implements Store.Impl.Encoder<MimeMessage> {
        MimeMessageEncoder() {
        }

        public Stream<Pair<BlobType, Store.Impl.ValueToSave>> encode(final MimeMessage message) {
            Preconditions.checkNotNull((Object)message);
            return Stream.of(Pair.of((Object)MimeMessagePartsId.HEADER_BLOB_TYPE, (bucketName, blobStore) -> {
                try {
                    MimeMessageInputStream stream = new MimeMessageInputStream(message);
                    MailHeaders mailHeaders = new MailHeaders((InputStream)stream);
                    return Mono.from((Publisher)blobStore.save(bucketName, mailHeaders.toByteArray(), BlobStore.StoragePolicy.SIZE_BASED));
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }), Pair.of((Object)MimeMessagePartsId.BODY_BLOB_TYPE, (bucketName, blobStore) -> Mono.from((Publisher)blobStore.save(bucketName, new ByteSource(this){

                public InputStream openStream() throws IOException {
                    try {
                        MimeMessageInputStream stream = new MimeMessageInputStream(message);
                        new MailHeaders((InputStream)stream);
                        return stream;
                    }
                    catch (MessagingException e) {
                        throw new IOException("Failed to generate body stream", e);
                    }
                }

                public long size() throws IOException {
                    try {
                        int size = message.getSize();
                        if (size < 0) {
                            CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
                            this.openStream().transferTo((OutputStream)countingOutputStream);
                            return countingOutputStream.getCount();
                        }
                        return size;
                    }
                    catch (MessagingException e) {
                        throw new IOException("Failed accessing body size", e);
                    }
                }
            }, BlobStore.StoragePolicy.LOW_COST))));
        }
    }
}

