/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.mail.Flags;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.MessageId;

public class UpdatedFlags {
    private final MessageUid uid;
    private final Optional<MessageId> messageId;
    private final Flags oldFlags;
    private final Flags newFlags;
    private final Flags modifiedFlags;
    private final ModSeq modSeq;

    public static Builder builder() {
        return new Builder();
    }

    private static void addModifiedSystemFlags(Flags oldFlags, Flags newFlags, Flags modifiedFlags) {
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.ANSWERED)) {
            modifiedFlags.add(Flags.Flag.ANSWERED);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.DELETED)) {
            modifiedFlags.add(Flags.Flag.DELETED);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.DRAFT)) {
            modifiedFlags.add(Flags.Flag.DRAFT);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.FLAGGED)) {
            modifiedFlags.add(Flags.Flag.FLAGGED);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.RECENT)) {
            modifiedFlags.add(Flags.Flag.RECENT);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.SEEN)) {
            modifiedFlags.add(Flags.Flag.SEEN);
        }
    }

    private static void addModifiedUserFlags(Flags oldFlags, Flags newFlags, Flags modifiedFlags) {
        UpdatedFlags.addModifiedUserFlags(oldFlags, newFlags, oldFlags.getUserFlags(), modifiedFlags);
        UpdatedFlags.addModifiedUserFlags(oldFlags, newFlags, newFlags.getUserFlags(), modifiedFlags);
    }

    private static void addModifiedUserFlags(Flags oldFlags, Flags newFlags, String[] userflags, Flags modifiedFlags) {
        for (String userFlag : userflags) {
            if (!UpdatedFlags.isChanged(oldFlags, newFlags, userFlag)) continue;
            modifiedFlags.add(userFlag);
        }
    }

    private static boolean isChanged(Flags original, Flags updated, Flags.Flag flag) {
        return original != null && updated != null && original.contains(flag) ^ updated.contains(flag);
    }

    private static boolean isChanged(Flags original, Flags updated, String userFlag) {
        return original != null && updated != null && original.contains(userFlag) ^ updated.contains(userFlag);
    }

    private UpdatedFlags(MessageUid uid, Optional<MessageId> messageId, ModSeq modSeq, Flags oldFlags, Flags newFlags) {
        this.uid = uid;
        this.messageId = messageId;
        this.modSeq = modSeq;
        this.oldFlags = oldFlags;
        this.newFlags = newFlags;
        this.modifiedFlags = new Flags();
        UpdatedFlags.addModifiedSystemFlags(oldFlags, newFlags, this.modifiedFlags);
        UpdatedFlags.addModifiedUserFlags(oldFlags, newFlags, this.modifiedFlags);
    }

    public Flags getOldFlags() {
        return this.oldFlags;
    }

    public boolean isModifiedToSet(Flags.Flag flag) {
        return this.newFlags.contains(flag) && !this.oldFlags.contains(flag);
    }

    public boolean isModifiedToUnset(Flags.Flag flag) {
        return !this.newFlags.contains(flag) && this.oldFlags.contains(flag);
    }

    public boolean isUnchanged(Flags.Flag flag) {
        return !this.isChanged(flag);
    }

    public boolean isChanged(Flags.Flag flag) {
        return this.isModifiedToSet(flag) || this.isModifiedToUnset(flag);
    }

    public Flags getNewFlags() {
        return this.newFlags;
    }

    public MessageUid getUid() {
        return this.uid;
    }

    public Optional<MessageId> getMessageId() {
        return this.messageId;
    }

    public List<Flags.Flag> modifiedSystemFlags() {
        return ImmutableList.copyOf(this.modifiedFlags.getSystemFlags());
    }

    public List<String> modifiedUserFlags() {
        return ImmutableList.copyOf(this.modifiedFlags.getUserFlags());
    }

    public Iterator<String> userFlagIterator() {
        return Arrays.asList(this.modifiedFlags.getUserFlags()).iterator();
    }

    public Stream<String> userFlagStream() {
        return Stream.of(this.modifiedFlags.getUserFlags());
    }

    public ModSeq getModSeq() {
        return this.modSeq;
    }

    public static boolean flagsChanged(Flags flagsOld, Flags flagsNew) {
        Flags modifiedFlags = new Flags();
        UpdatedFlags.addModifiedSystemFlags(flagsOld, flagsNew, modifiedFlags);
        UpdatedFlags.addModifiedUserFlags(flagsOld, flagsNew, modifiedFlags);
        return modifiedFlags.getSystemFlags().length > 0 || modifiedFlags.getUserFlags().length > 0;
    }

    public boolean flagsChanged() {
        return this.modifiedFlags.getSystemFlags().length > 0 || this.modifiedFlags.getUserFlags().length > 0;
    }

    public boolean flagsChangedIgnoringRecent() {
        if (this.modifiedFlags.contains(Flags.Flag.RECENT)) {
            return this.modifiedFlags.getSystemFlags().length > 1 || this.modifiedFlags.getUserFlags().length > 0;
        }
        return this.modifiedFlags.getSystemFlags().length > 0 || this.modifiedFlags.getUserFlags().length > 0;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UpdatedFlags)) {
            return false;
        }
        UpdatedFlags that = (UpdatedFlags)other;
        return Objects.equals(this.uid, that.uid) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.oldFlags, that.oldFlags) && Objects.equals(this.newFlags, that.newFlags) && Objects.equals(this.modSeq, that.modSeq);
    }

    public final int hashCode() {
        return Objects.hash(this.uid, this.messageId, this.oldFlags, this.newFlags, this.modSeq);
    }

    public String toString() {
        return MoreObjects.toStringHelper(UpdatedFlags.class).add("uid", this.uid).add("messageId", this.messageId).add("oldFlags", this.oldFlags).add("newFlags", this.newFlags).add("modSeq", this.modSeq).toString();
    }

    public static class Builder {
        private MessageUid uid;
        private Optional<MessageId> messageId = Optional.empty();
        private Flags oldFlags;
        private Flags newFlags;
        private Optional<ModSeq> modSeq = Optional.empty();

        private Builder() {
        }

        public Builder uid(MessageUid uid) {
            this.uid = uid;
            return this;
        }

        public Builder messageId(MessageId messageId) {
            this.messageId = Optional.of(messageId);
            return this;
        }

        public Builder messageId(Optional<MessageId> messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder oldFlags(Flags oldFlags) {
            this.oldFlags = oldFlags;
            return this;
        }

        public Builder newFlags(Flags newFlags) {
            this.newFlags = newFlags;
            return this;
        }

        public Builder modSeq(ModSeq modSeq) {
            this.modSeq = Optional.of(modSeq);
            return this;
        }

        public UpdatedFlags build() {
            Preconditions.checkNotNull(this.uid);
            Preconditions.checkNotNull(this.newFlags);
            Preconditions.checkNotNull(this.oldFlags);
            Preconditions.checkState(this.modSeq.isPresent());
            return new UpdatedFlags(this.uid, this.messageId, this.modSeq.get(), this.oldFlags, this.newFlags);
        }
    }
}

