/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.Executable;
import org.apache.jsieve.ExecutableCommand;
import org.apache.jsieve.ScriptCoordinate;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command
implements Executable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Command.class);
    private String fieldName;
    private Arguments fieldArguments;
    private Block fieldBlock;
    private ScriptCoordinate coordinate;

    private Command() {
    }

    public Command(String name, Arguments arguments, Block block, ScriptCoordinate coordinate) {
        this();
        this.coordinate = coordinate;
        this.setName(name);
        this.setArguments(arguments);
        this.setBlock(block);
    }

    public String getName() {
        return this.fieldName;
    }

    protected void setName(String name) {
        this.fieldName = name;
    }

    public String toString() {
        return "Command name: " + this.getName() + " " + (this.getArguments() == null ? "null" : this.getArguments().toString()) + " Block: " + (this.getBlock() == null ? "null" : this.getBlock().toString());
    }

    public Arguments getArguments() {
        return this.fieldArguments;
    }

    public Block getBlock() {
        return this.fieldBlock;
    }

    protected void setArguments(Arguments arguments) {
        this.fieldArguments = arguments;
    }

    protected void setBlock(Block block) {
        this.fieldBlock = block;
    }

    @Override
    public Object execute(MailAdapter mail, SieveContext context) throws SieveException {
        LOGGER.debug(this.toString());
        this.coordinate.debugDiagnostics();
        context.setCoordinate(this.coordinate);
        ExecutableCommand executable = context.getCommandManager().getCommand(this.getName());
        return executable.execute(mail, this.getArguments(), this.getBlock(), context);
    }
}

