/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ThrowingBiConsumer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.HeadersDto;
import org.apache.james.queue.rabbitmq.MailReference;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;

class MailReferenceDTO {
    private final String enqueueId;
    private final ImmutableList<String> recipients;
    private final String name;
    private final Optional<String> sender;
    private final String state;
    private final String errorMessage;
    private final Optional<Instant> lastUpdated;
    private final ImmutableMap<String, String> attributes;
    private final String remoteAddr;
    private final String remoteHost;
    private final Map<String, HeadersDto> perRecipientHeaders;
    private final String headerBlobId;
    private final String bodyBlobId;

    static MailReferenceDTO fromMailReference(MailReference mailReference) {
        Mail mail = mailReference.getMail();
        MimeMessagePartsId partsId = mailReference.getPartsId();
        return new MailReferenceDTO(mailReference.getEnqueueId().serialize(), (ImmutableList<String>)((ImmutableList)Optional.ofNullable(mail.getRecipients()).map(Collection::stream).orElse(Stream.empty()).map(MailAddress::asString).collect(ImmutableList.toImmutableList())), mail.getName(), mail.getMaybeSender().asOptional().map(MailAddress::asString), mail.getState(), mail.getErrorMessage(), Optional.ofNullable(mail.getLastUpdated()).map(Date::toInstant), MailReferenceDTO.serializedAttributes(mail), mail.getRemoteAddr(), mail.getRemoteHost(), MailReferenceDTO.fromPerRecipientHeaders(mail.getPerRecipientSpecificHeaders()), partsId.getHeaderBlobId().asString(), partsId.getBodyBlobId().asString());
    }

    private static Map<String, HeadersDto> fromPerRecipientHeaders(PerRecipientHeaders perRecipientHeaders) {
        return (Map)perRecipientHeaders.getHeadersByRecipient().asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((MailAddress)entry.getKey()).asString(), entry -> HeadersDto.from((Collection)entry.getValue())));
    }

    private static ImmutableMap<String, String> serializedAttributes(Mail mail) {
        return (ImmutableMap)mail.attributes().flatMap(attribute -> attribute.getValue().toJson().map(JsonNode::toString).map(value -> Pair.of((Object)attribute.getName().asString(), (Object)value)).stream()).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
    }

    @JsonCreator
    private MailReferenceDTO(@JsonProperty(value="enqueueId") String enqueueId, @JsonProperty(value="recipients") ImmutableList<String> recipients, @JsonProperty(value="name") String name, @JsonProperty(value="sender") Optional<String> sender, @JsonProperty(value="state") String state, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="lastUpdated") Optional<Instant> lastUpdated, @JsonProperty(value="attributes") ImmutableMap<String, String> attributes, @JsonProperty(value="remoteAddr") String remoteAddr, @JsonProperty(value="remoteHost") String remoteHost, @JsonProperty(value="perRecipientHeaders") Map<String, HeadersDto> perRecipientHeaders, @JsonProperty(value="headerBlobId") String headerBlobId, @JsonProperty(value="bodyBlobId") String bodyBlobId) {
        this.enqueueId = enqueueId;
        this.recipients = recipients;
        this.name = name;
        this.sender = sender;
        this.state = state;
        this.errorMessage = errorMessage;
        this.lastUpdated = lastUpdated;
        this.attributes = attributes;
        this.remoteAddr = remoteAddr;
        this.remoteHost = remoteHost;
        this.perRecipientHeaders = perRecipientHeaders;
        this.headerBlobId = headerBlobId;
        this.bodyBlobId = bodyBlobId;
    }

    @JsonProperty(value="enqueueId")
    public String getEnqueueId() {
        return this.enqueueId;
    }

    @JsonProperty(value="recipients")
    Collection<String> getRecipients() {
        return this.recipients;
    }

    @JsonProperty(value="name")
    String getName() {
        return this.name;
    }

    @JsonProperty(value="sender")
    Optional<String> getSender() {
        return this.sender;
    }

    @JsonProperty(value="state")
    String getState() {
        return this.state;
    }

    @JsonProperty(value="errorMessage")
    String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="lastUpdated")
    Optional<Instant> getLastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="attributes")
    Map<String, String> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="remoteAddr")
    String getRemoteAddr() {
        return this.remoteAddr;
    }

    @JsonProperty(value="remoteHost")
    String getRemoteHost() {
        return this.remoteHost;
    }

    @JsonProperty(value="perRecipientHeaders")
    Map<String, HeadersDto> getPerRecipientHeaders() {
        return this.perRecipientHeaders;
    }

    @JsonProperty(value="headerBlobId")
    String getHeaderBlobId() {
        return this.headerBlobId;
    }

    @JsonProperty(value="bodyBlobId")
    String getBodyBlobId() {
        return this.bodyBlobId;
    }

    MailReference toMailReference(BlobId.Factory blobIdFactory) {
        MimeMessagePartsId messagePartsId = MimeMessagePartsId.builder().headerBlobId(blobIdFactory.from(this.headerBlobId)).bodyBlobId(blobIdFactory.from(this.bodyBlobId)).build();
        return new MailReference(EnqueueId.ofSerialized(this.enqueueId), (Mail)this.mailMetadata(), messagePartsId);
    }

    private MailImpl mailMetadata() {
        MailImpl.Builder builder = MailImpl.builder().name(this.name).sender(this.sender.map(MaybeSender::getMailSender).orElse(MaybeSender.nullSender())).addRecipients((Collection)this.recipients.stream().map(Throwing.function(MailAddress::new).sneakyThrow()).collect(ImmutableList.toImmutableList())).errorMessage(this.errorMessage).remoteAddr(this.remoteAddr).remoteHost(this.remoteHost).state(this.state);
        this.lastUpdated.map(Instant::toEpochMilli).map(Date::new).ifPresent(arg_0 -> ((MailImpl.Builder)builder).lastUpdated(arg_0));
        ThrowingBiConsumer attributeSetter = (name, value) -> builder.addAttribute(new Attribute(AttributeName.of((String)name), AttributeValue.fromJsonString((String)value)));
        this.attributes.forEach(Throwing.biConsumer((ThrowingBiConsumer)attributeSetter).sneakyThrow());
        builder.addAllHeadersForRecipients(this.retrievePerRecipientHeaders());
        return builder.build();
    }

    private PerRecipientHeaders retrievePerRecipientHeaders() {
        PerRecipientHeaders perRecipientHeaders = new PerRecipientHeaders();
        this.perRecipientHeaders.entrySet().stream().flatMap(entry -> ((HeadersDto)entry.getValue()).toHeaders().stream().map(Throwing.function(header -> Pair.of((Object)new MailAddress((String)entry.getKey()), (Object)header)))).forEach(pair -> perRecipientHeaders.addHeaderForRecipient((PerRecipientHeaders.Header)pair.getValue(), (MailAddress)pair.getKey()));
        return perRecipientHeaders;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailReferenceDTO) {
            MailReferenceDTO mailDTO = (MailReferenceDTO)o;
            return Objects.equals(this.enqueueId, mailDTO.enqueueId) && Objects.equals(this.recipients, mailDTO.recipients) && Objects.equals(this.name, mailDTO.name) && Objects.equals(this.sender, mailDTO.sender) && Objects.equals(this.state, mailDTO.state) && Objects.equals(this.errorMessage, mailDTO.errorMessage) && Objects.equals(this.lastUpdated, mailDTO.lastUpdated) && Objects.equals(this.attributes, mailDTO.attributes) && Objects.equals(this.remoteAddr, mailDTO.remoteAddr) && Objects.equals(this.remoteHost, mailDTO.remoteHost) && Objects.equals(this.perRecipientHeaders, mailDTO.perRecipientHeaders) && Objects.equals(this.headerBlobId, mailDTO.headerBlobId) && Objects.equals(this.bodyBlobId, mailDTO.bodyBlobId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.enqueueId, this.recipients, this.name, this.sender, this.state, this.errorMessage, this.lastUpdated, this.attributes, this.remoteAddr, this.remoteHost, this.perRecipientHeaders, this.headerBlobId, this.bodyBlobId);
    }
}

