/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpPredicate;
import reactor.netty.http.server.HttpRouteHandlerMetadata;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.util.annotation.Nullable;

final class DefaultHttpServerRoutes
implements HttpServerRoutes {
    private final CopyOnWriteArrayList<HttpRouteHandler> handlers = new CopyOnWriteArrayList();
    private final List<HttpRouteHandler> initialOrderHandlers = new ArrayList<HttpRouteHandler>();
    private Comparator<HttpRouteHandlerMetadata> comparator;

    DefaultHttpServerRoutes() {
    }

    @Override
    public HttpServerRoutes directory(String uri, Path directory, @Nullable Function<HttpServerResponse, HttpServerResponse> interceptor) {
        Objects.requireNonNull(directory, "directory");
        return this.route(HttpPredicate.prefix(uri), (req, resp) -> {
            Path p;
            String prefix = URI.create(req.uri()).getPath().replaceFirst(uri, "");
            if (!prefix.isEmpty() && prefix.charAt(0) == '/') {
                prefix = prefix.substring(1);
            }
            if (Files.isReadable(p = directory.resolve(prefix))) {
                if (interceptor != null) {
                    return ((HttpServerResponse)interceptor.apply((HttpServerResponse)resp)).sendFile(p);
                }
                return resp.sendFile(p);
            }
            return resp.sendNotFound();
        });
    }

    @Override
    public HttpServerRoutes removeIf(Predicate<? super HttpRouteHandlerMetadata> condition) {
        Objects.requireNonNull(condition, "condition");
        this.handlers.removeIf(condition);
        return this;
    }

    @Override
    public HttpServerRoutes route(Predicate<? super HttpServerRequest> condition, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(condition, "condition");
        Objects.requireNonNull(handler, "handler");
        if (condition instanceof HttpPredicate) {
            HttpPredicate predicate = (HttpPredicate)condition;
            HttpRouteHandler httpRouteHandler = new HttpRouteHandler(condition, handler, predicate, predicate.uri, predicate.method);
            this.handlers.add(httpRouteHandler);
            this.initialOrderHandlers.add(httpRouteHandler);
        } else {
            HttpRouteHandler httpRouteHandler = new HttpRouteHandler(condition, handler, null, null, null);
            this.handlers.add(httpRouteHandler);
            this.initialOrderHandlers.add(httpRouteHandler);
        }
        if (this.comparator != null) {
            this.handlers.sort(this.comparator);
        }
        return this;
    }

    @Override
    public HttpServerRoutes comparator(Comparator<HttpRouteHandlerMetadata> comparator) {
        Objects.requireNonNull(comparator, "comparator");
        this.comparator = comparator;
        this.handlers.sort(comparator);
        return this;
    }

    @Override
    public HttpServerRoutes noComparator() {
        this.handlers.clear();
        this.handlers.addAll(this.initialOrderHandlers);
        return this;
    }

    @Override
    public Publisher<Void> apply(HttpServerRequest request, HttpServerResponse response) {
        Iterator<HttpRouteHandler> iterator = this.handlers.iterator();
        try {
            while (iterator.hasNext()) {
                HttpRouteHandler cursor = iterator.next();
                if (!cursor.test(request)) continue;
                return cursor.apply(request, response);
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal((Throwable)t);
            return Mono.error((Throwable)t);
        }
        return response.sendNotFound();
    }

    static final class HttpRouteHandler
    implements BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>>,
    Predicate<HttpServerRequest>,
    HttpRouteHandlerMetadata {
        final Predicate<? super HttpServerRequest> condition;
        final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;
        final Function<? super String, Map<String, String>> resolver;
        final String path;
        final HttpMethod method;

        HttpRouteHandler(Predicate<? super HttpServerRequest> condition, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler, @Nullable Function<? super String, Map<String, String>> resolver, @Nullable String path, @Nullable HttpMethod method) {
            this.condition = Objects.requireNonNull(condition, "condition");
            this.handler = Objects.requireNonNull(handler, "handler");
            this.resolver = resolver;
            this.path = path;
            this.method = method;
        }

        @Override
        public Publisher<Void> apply(HttpServerRequest request, HttpServerResponse response) {
            return this.handler.apply(request.paramsResolver(this.resolver), response);
        }

        @Override
        public boolean test(HttpServerRequest o) {
            return this.condition.test(o);
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public HttpMethod getMethod() {
            return this.method;
        }
    }
}

