/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.recovery.RecoveryIndexStatus;
import org.opensearch.client.opensearch.indices.recovery.RecoveryOrigin;
import org.opensearch.client.opensearch.indices.recovery.RecoveryStartStatus;
import org.opensearch.client.opensearch.indices.recovery.TranslogStatus;
import org.opensearch.client.opensearch.indices.recovery.VerifyIndex;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardRecovery
implements JsonpSerializable {
    private final long id;
    private final RecoveryIndexStatus index;
    private final boolean primary;
    private final RecoveryOrigin source;
    private final String stage;
    @Nullable
    private final RecoveryStartStatus start;
    @Nullable
    private final String startTime;
    private final String startTimeInMillis;
    @Nullable
    private final String stopTime;
    private final String stopTimeInMillis;
    private final RecoveryOrigin target;
    @Nullable
    private final String totalTime;
    private final String totalTimeInMillis;
    private final TranslogStatus translog;
    private final String type;
    private final VerifyIndex verifyIndex;
    public static final JsonpDeserializer<ShardRecovery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRecovery::setupShardRecoveryDeserializer);

    private ShardRecovery(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, this, "primary");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.stage = ApiTypeHelper.requireNonNull(builder.stage, this, "stage");
        this.start = builder.start;
        this.startTime = builder.startTime;
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.stopTime = builder.stopTime;
        this.stopTimeInMillis = ApiTypeHelper.requireNonNull(builder.stopTimeInMillis, this, "stopTimeInMillis");
        this.target = ApiTypeHelper.requireNonNull(builder.target, this, "target");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
        this.translog = ApiTypeHelper.requireNonNull(builder.translog, this, "translog");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.verifyIndex = ApiTypeHelper.requireNonNull(builder.verifyIndex, this, "verifyIndex");
    }

    public static ShardRecovery of(Function<Builder, ObjectBuilder<ShardRecovery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long id() {
        return this.id;
    }

    public final RecoveryIndexStatus index() {
        return this.index;
    }

    public final boolean primary() {
        return this.primary;
    }

    public final RecoveryOrigin source() {
        return this.source;
    }

    public final String stage() {
        return this.stage;
    }

    @Nullable
    public final RecoveryStartStatus start() {
        return this.start;
    }

    @Nullable
    public final String startTime() {
        return this.startTime;
    }

    public final String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final String stopTime() {
        return this.stopTime;
    }

    public final String stopTimeInMillis() {
        return this.stopTimeInMillis;
    }

    public final RecoveryOrigin target() {
        return this.target;
    }

    @Nullable
    public final String totalTime() {
        return this.totalTime;
    }

    public final String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public final TranslogStatus translog() {
        return this.translog;
    }

    public final String type() {
        return this.type;
    }

    public final VerifyIndex verifyIndex() {
        return this.verifyIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index");
        this.index.serialize(generator, mapper);
        generator.writeKey("primary");
        generator.write(this.primary);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        generator.writeKey("stage");
        generator.write(this.stage);
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            generator.write(this.startTime);
        }
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.stopTime != null) {
            generator.writeKey("stop_time");
            generator.write(this.stopTime);
        }
        generator.writeKey("stop_time_in_millis");
        generator.write(this.stopTimeInMillis);
        generator.writeKey("target");
        this.target.serialize(generator, mapper);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
        generator.writeKey("translog");
        this.translog.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("verify_index");
        this.verifyIndex.serialize(generator, mapper);
    }

    protected static void setupShardRecoveryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(Builder::index, RecoveryIndexStatus._DESERIALIZER, "index");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::source, RecoveryOrigin._DESERIALIZER, "source");
        op.add(Builder::stage, JsonpDeserializer.stringDeserializer(), "stage");
        op.add(Builder::start, RecoveryStartStatus._DESERIALIZER, "start");
        op.add(Builder::startTime, JsonpDeserializer.stringDeserializer(), "start_time");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis");
        op.add(Builder::stopTime, JsonpDeserializer.stringDeserializer(), "stop_time");
        op.add(Builder::stopTimeInMillis, JsonpDeserializer.stringDeserializer(), "stop_time_in_millis");
        op.add(Builder::target, RecoveryOrigin._DESERIALIZER, "target");
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis");
        op.add(Builder::translog, TranslogStatus._DESERIALIZER, "translog");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::verifyIndex, VerifyIndex._DESERIALIZER, "verify_index");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardRecovery> {
        private Long id;
        private RecoveryIndexStatus index;
        private Boolean primary;
        private RecoveryOrigin source;
        private String stage;
        @Nullable
        private RecoveryStartStatus start;
        @Nullable
        private String startTime;
        private String startTimeInMillis;
        @Nullable
        private String stopTime;
        private String stopTimeInMillis;
        private RecoveryOrigin target;
        @Nullable
        private String totalTime;
        private String totalTimeInMillis;
        private TranslogStatus translog;
        private String type;
        private VerifyIndex verifyIndex;

        public final Builder id(long value) {
            this.id = value;
            return this;
        }

        public final Builder index(RecoveryIndexStatus value) {
            this.index = value;
            return this;
        }

        public final Builder index(Function<RecoveryIndexStatus.Builder, ObjectBuilder<RecoveryIndexStatus>> fn) {
            return this.index(fn.apply(new RecoveryIndexStatus.Builder()).build());
        }

        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder source(RecoveryOrigin value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<RecoveryOrigin.Builder, ObjectBuilder<RecoveryOrigin>> fn) {
            return this.source(fn.apply(new RecoveryOrigin.Builder()).build());
        }

        public final Builder stage(String value) {
            this.stage = value;
            return this;
        }

        public final Builder start(@Nullable RecoveryStartStatus value) {
            this.start = value;
            return this;
        }

        public final Builder start(Function<RecoveryStartStatus.Builder, ObjectBuilder<RecoveryStartStatus>> fn) {
            return this.start(fn.apply(new RecoveryStartStatus.Builder()).build());
        }

        public final Builder startTime(@Nullable String value) {
            this.startTime = value;
            return this;
        }

        public final Builder startTimeInMillis(String value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder stopTime(@Nullable String value) {
            this.stopTime = value;
            return this;
        }

        public final Builder stopTimeInMillis(String value) {
            this.stopTimeInMillis = value;
            return this;
        }

        public final Builder target(RecoveryOrigin value) {
            this.target = value;
            return this;
        }

        public final Builder target(Function<RecoveryOrigin.Builder, ObjectBuilder<RecoveryOrigin>> fn) {
            return this.target(fn.apply(new RecoveryOrigin.Builder()).build());
        }

        public final Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        public final Builder translog(TranslogStatus value) {
            this.translog = value;
            return this;
        }

        public final Builder translog(Function<TranslogStatus.Builder, ObjectBuilder<TranslogStatus>> fn) {
            return this.translog(fn.apply(new TranslogStatus.Builder()).build());
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder verifyIndex(VerifyIndex value) {
            this.verifyIndex = value;
            return this;
        }

        public final Builder verifyIndex(Function<VerifyIndex.Builder, ObjectBuilder<VerifyIndex>> fn) {
            return this.verifyIndex(fn.apply(new VerifyIndex.Builder()).build());
        }

        @Override
        public ShardRecovery build() {
            this._checkSingleUse();
            return new ShardRecovery(this);
        }
    }
}

