/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import java.util.function.Supplier;

public class UidValidity {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final long UPPER_EXCLUSIVE_BOUND = 0x100000000L;
    private final long uidValidity;

    public static UidValidity generate() {
        return UidValidity.fromSupplier(RANDOM::nextLong);
    }

    @VisibleForTesting
    static UidValidity fromSupplier(Supplier<Long> longSupplier) {
        long randomValue = longSupplier.get();
        long sanitizedRandomValue = Math.abs(1L + randomValue % 0xFFFFFFFFL);
        return UidValidity.of(sanitizedRandomValue);
    }

    public static UidValidity of(long uidValidity) {
        Preconditions.checkArgument((boolean)UidValidity.isValid(uidValidity), (String)"uidValidity needs to be a non-zero unsigned 32-bit integer, got %s", (long)uidValidity);
        return new UidValidity(uidValidity);
    }

    public static boolean isValid(long uidValidityAsLong) {
        return uidValidityAsLong > 0L && uidValidityAsLong < 0x100000000L;
    }

    private UidValidity(long uidValidity) {
        this.uidValidity = uidValidity;
    }

    public boolean isValid() {
        return UidValidity.isValid(this.uidValidity);
    }

    public long asLong() {
        return this.uidValidity;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof UidValidity) {
            UidValidity other = (UidValidity)obj;
            return Objects.equal((Object)this.uidValidity, (Object)other.uidValidity);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uidValidity});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uidValidity", this.uidValidity).toString();
    }
}

