/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Domain
implements Serializable {
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf("-_");
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange('0', '9');
    private static final CharMatcher PART_CHAR_MATCHER = new CharMatcher(){

        @Override
        public boolean matches(char c) {
            return Character.isLetterOrDigit(c) || '-' == c || '_' == c || '.' == c;
        }
    };
    public static final Domain LOCALHOST = Domain.of("localhost");
    public static final int MAXIMUM_DOMAIN_LENGTH = 253;
    @Nonnull
    private final String domainName;
    @Nonnull
    private final String normalizedDomainName;

    private static String removeBrackets(String domainName) {
        if (!domainName.startsWith("[") || !domainName.endsWith("]")) {
            return domainName;
        }
        return domainName.substring(1, domainName.length() - 1);
    }

    public static Domain of(String domain) {
        Preconditions.checkNotNull(domain, "Domain can not be null");
        Preconditions.checkArgument(domain.length() <= 253, "Domain name length should not exceed %s characters", 253);
        String domainWithoutBrackets = Domain.removeBrackets(domain);
        Preconditions.checkArgument(PART_CHAR_MATCHER.matchesAllOf(domainWithoutBrackets), "Domain parts ASCII chars must be a-z A-Z 0-9 - or _");
        int pos = 0;
        int nextDot = domainWithoutBrackets.indexOf(46);
        while (nextDot > -1) {
            if (pos + 1 > domainWithoutBrackets.length()) {
                throw new IllegalArgumentException("Last domain part should not be empty");
            }
            Domain.assertValidPart(domainWithoutBrackets, pos, nextDot);
            pos = nextDot + 1;
            nextDot = domainWithoutBrackets.indexOf(46, pos);
        }
        Domain.assertValidPart(domainWithoutBrackets, pos, domainWithoutBrackets.length());
        Domain.assertValidLastPart(domainWithoutBrackets, pos);
        return new Domain(domainWithoutBrackets);
    }

    private static void assertValidPart(String domainPart, int begin, int end) {
        Preconditions.checkArgument(begin != end, "Domain part should not be empty");
        Preconditions.checkArgument(!DASH_MATCHER.matches(domainPart.charAt(begin)), "Domain part should not start with '-' or '_'");
        Preconditions.checkArgument(!DASH_MATCHER.matches(domainPart.charAt(end - 1)), "Domain part should not end with '-' or '_'");
        Preconditions.checkArgument(end - begin <= 63, "Domain part should not not exceed 63 characters");
    }

    private static void assertValidLastPart(String domainPart, int pos) {
        boolean onlyDigits = DIGIT_MATCHER.matches(domainPart.charAt(pos));
        boolean invalid = onlyDigits && !Domain.validIPAddress(domainPart);
        Preconditions.checkArgument(!invalid, "The last domain part must not start with 0-9");
    }

    private static boolean validIPAddress(String value) {
        try {
            InetAddresses.forString(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected Domain(String domainName) {
        this.domainName = domainName;
        this.normalizedDomainName = Domain.removeBrackets(domainName.toLowerCase(Locale.US));
    }

    public String name() {
        return this.domainName;
    }

    public String asString() {
        return this.normalizedDomainName;
    }

    public final boolean equals(Object o) {
        if (o instanceof Domain) {
            Domain domain = (Domain)o;
            return Objects.equals(this.normalizedDomainName, domain.normalizedDomainName);
        }
        return false;
    }

    public final int hashCode() {
        return this.normalizedDomainName.hashCode();
    }

    public String toString() {
        return "Domain : " + this.domainName;
    }
}

