/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.api.DLPRules;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.aggregates.DLPDomainConfiguration;
import org.apache.james.dlp.eventsourcing.commands.ClearCommand;
import org.apache.james.dlp.eventsourcing.commands.ClearCommandHandler;
import org.apache.james.dlp.eventsourcing.commands.StoreCommand;
import org.apache.james.dlp.eventsourcing.commands.StoreCommandHandler;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EventSourcingDLPConfigurationStore
implements DLPConfigurationStore {
    private static final ImmutableSet<Subscriber> NO_SUBSCRIBER = ImmutableSet.of();
    private final EventSourcingSystem eventSourcingSystem;
    private final EventStore eventStore;

    @Inject
    public EventSourcingDLPConfigurationStore(EventStore eventStore) {
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)ImmutableSet.of((Object)new ClearCommandHandler(eventStore), (Object)new StoreCommandHandler(eventStore)), NO_SUBSCRIBER, (EventStore)eventStore);
        this.eventStore = eventStore;
    }

    public Publisher<DLPRules> list(Domain domain) {
        DLPAggregateId aggregateId = new DLPAggregateId(domain);
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).map(history -> DLPDomainConfiguration.load(aggregateId, history).retrieveRules());
    }

    public void store(Domain domain, DLPRules rules) {
        Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new StoreCommand(domain, rules))).block();
    }

    public void clear(Domain domain) {
        Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new ClearCommand(domain))).block();
    }

    public Optional<DLPConfigurationItem> fetch(Domain domain, DLPConfigurationItem.Id ruleId) {
        return Mono.from(this.list(domain)).flatMapIterable(DLPRules::getItems).toStream().filter(item -> item.getId().equals((Object)ruleId)).findFirst();
    }
}

