/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.james.mailbox.model.MessageId;

public class ThreadId {
    private final MessageId baseMessageId;

    public static ThreadId fromBaseMessageId(MessageId baseMessageId) {
        return new ThreadId(baseMessageId);
    }

    public ThreadId(MessageId baseMessageId) {
        this.baseMessageId = baseMessageId;
    }

    public MessageId getBaseMessageId() {
        return this.baseMessageId;
    }

    public String serialize() {
        return this.baseMessageId.serialize();
    }

    public boolean isSerializable() {
        return this.baseMessageId.isSerializable();
    }

    public final boolean equals(Object o) {
        if (o instanceof ThreadId) {
            ThreadId that = (ThreadId)o;
            return Objects.equals(this.baseMessageId, that.baseMessageId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.baseMessageId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseMessageId", (Object)this.baseMessageId).toString();
    }

    public static class Factory {
        private final MessageId.Factory messageIdFactory;

        @Inject
        public Factory(MessageId.Factory messageIdFactory) {
            this.messageIdFactory = messageIdFactory;
        }

        public ThreadId fromString(String serialized) {
            MessageId messageId = this.messageIdFactory.fromString(serialized);
            return ThreadId.fromBaseMessageId(messageId);
        }
    }
}

