/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasMimeType
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasMimeType.class);
    private Set<String> acceptedContentTypes;

    public void init() throws MessagingException {
        this.acceptedContentTypes = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)this.getCondition()));
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return StreamUtils.ofNullable((Object[])mail.getMessage().getHeader("Content-Type")).flatMap(this::getMimeType).filter(this.acceptedContentTypes::contains).findAny().map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }

    private Stream<String> getMimeType(String rawValue) {
        try {
            return Stream.of(((ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Type", rawValue), DecodeMonitor.SILENT)).getMimeType());
        }
        catch (Exception e) {
            LOGGER.warn("Error while parsing message's mimeType {}", (Object)rawValue, (Object)e);
            return Stream.empty();
        }
    }
}

