/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotInfo;

public class CreateSnapshotResponse
extends ActionResponse
implements ToXContentObject {
    private static final ObjectParser<CreateSnapshotResponse, Void> PARSER = new ObjectParser(CreateSnapshotResponse.class.getName(), true, CreateSnapshotResponse::new);
    @Nullable
    private SnapshotInfo snapshotInfo;

    CreateSnapshotResponse() {
    }

    public CreateSnapshotResponse(@Nullable SnapshotInfo snapshotInfo) {
        this.snapshotInfo = snapshotInfo;
    }

    public CreateSnapshotResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshotInfo = in.readOptionalWriteable(SnapshotInfo::new);
    }

    private void setSnapshotInfoFromBuilder(SnapshotInfo.SnapshotInfoBuilder snapshotInfoBuilder) {
        this.snapshotInfo = snapshotInfoBuilder.build();
    }

    public SnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.snapshotInfo);
    }

    public RestStatus status() {
        if (this.snapshotInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.snapshotInfo.status();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.snapshotInfo != null) {
            builder.field("snapshot");
            this.snapshotInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public static CreateSnapshotResponse fromXContent(XContentParser parser) {
        return (CreateSnapshotResponse)PARSER.apply(parser, null);
    }

    public String toString() {
        return "CreateSnapshotResponse{snapshotInfo=" + this.snapshotInfo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotResponse that = (CreateSnapshotResponse)o;
        return Objects.equals(this.snapshotInfo, that.snapshotInfo);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotInfo);
    }

    static {
        PARSER.declareObject(CreateSnapshotResponse::setSnapshotInfoFromBuilder, SnapshotInfo.SNAPSHOT_INFO_PARSER, new ParseField("snapshot", new String[0]));
    }
}

