/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.james.vault.dto.query.CriterionDTO;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;

class QueryElementDeserializer
extends StdDeserializer<QueryElement> {
    protected QueryElementDeserializer() {
        super(QueryElement.class);
    }

    public QueryElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode queryElement = (ObjectNode)mapper.readTree(jsonParser);
        if (this.isComposedElement(queryElement)) {
            return (QueryElement)mapper.treeToValue((TreeNode)queryElement, QueryDTO.class);
        }
        return (QueryElement)mapper.treeToValue((TreeNode)queryElement, CriterionDTO.class);
    }

    private boolean isComposedElement(ObjectNode queryElement) {
        return queryElement.findValue("combinator") != null || queryElement.findValue("criteria") != null;
    }
}

