/*
 * Decompiled with CFR 0.152.
 */
package com.linagora.elasticsearch.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.linagora.elasticsearch.metrics.FailedtoConnectToElasticSearchException;
import com.linagora.elasticsearch.metrics.JsonMetrics;
import com.linagora.elasticsearch.metrics.MetricsElasticsearchModule;
import com.linagora.elasticsearch.metrics.percolation.Notifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchReporter.class);
    private final String[] hosts;
    private final Clock clock;
    private final String prefix;
    private final String index;
    private final int bulkSize;
    private final int timeout;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectWriter writer;
    private MetricFilter percolationFilter;
    private Notifier notifier;
    private String currentIndexName;
    private SimpleDateFormat indexDateFormat = null;
    private boolean checkedForIndexTemplate = false;
    private DefaultHttpRequestFactory httpRequestFactory;
    private CloseableHttpClient httpClient;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public ElasticsearchReporter(MetricRegistry registry, String[] hosts, int timeout, String index, String indexDateFormat, int bulkSize, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, MetricFilter percolationFilter, Notifier percolationNotifier, String timestampFieldname, Map<String, ?> additionalFields) throws MalformedURLException {
        super(registry, "elasticsearch-reporter", filter, rateUnit, durationUnit);
        this.hosts = hosts;
        this.index = index;
        this.bulkSize = bulkSize;
        this.clock = clock;
        this.prefix = prefix;
        this.timeout = timeout;
        if (indexDateFormat != null && indexDateFormat.length() > 0) {
            this.indexDateFormat = new SimpleDateFormat(indexDateFormat);
        }
        if (percolationNotifier != null && percolationFilter != null) {
            this.percolationFilter = percolationFilter;
            this.notifier = percolationNotifier;
        }
        if (timestampFieldname == null || timestampFieldname.trim().length() == 0) {
            LOGGER.error("Timestampfieldname {}\u00a0is not valid, using default @timestamp", (Object)timestampFieldname);
            timestampFieldname = "@timestamp";
        }
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(SerializationFeature.CLOSE_CLOSEABLE, false);
        this.objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        this.objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.objectMapper.registerModule((Module)new AfterburnerModule());
        this.objectMapper.registerModule((Module)new MetricsElasticsearchModule(rateUnit, durationUnit, timestampFieldname, additionalFields));
        this.writer = this.objectMapper.writer();
        this.httpRequestFactory = new DefaultHttpRequestFactory();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setConnectionRequestTimeout(timeout).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(timeout).build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).build();
        this.checkForIndexTemplate();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (gauges.isEmpty() && counters.isEmpty() && histograms.isEmpty() && meters.isEmpty() && timers.isEmpty()) {
            LOGGER.info("All metrics empty, nothing to report");
            return;
        }
        if (!this.checkedForIndexTemplate) {
            this.checkForIndexTemplate();
        }
        long timestamp = this.clock.getTime() / 1000L;
        this.currentIndexName = this.index;
        if (this.indexDateFormat != null) {
            this.currentIndexName = this.currentIndexName + "-" + this.indexDateFormat.format(new Date(timestamp * 1000L));
        }
        try {
            ImmutableList jsonMetrics = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.getJsonMetricsForGauges(gauges, timestamp), this.getJsonMetricsForCounters(counters, timestamp), this.getJsonMetricsForHistograms(histograms, timestamp), this.getJsonMetricsForMeters(meters, timestamp), this.getJsonMetricsForTimers(timers, timestamp)}));
            List percolationMetrics = jsonMetrics.stream().filter(this::matchPercolationMetric).collect(Collectors.toList());
            for (List metrics : Iterables.partition((Iterable)jsonMetrics, (int)this.bulkSize)) {
                this.doReportForBatch(metrics);
            }
            if (percolationMetrics.size() > 0 && this.notifier != null) {
                for (JsonMetrics.JsonMetric jsonMetric : percolationMetrics) {
                    List<String> matches = this.getPercolationMatches(jsonMetric);
                    for (String match : matches) {
                        this.notifier.notify(jsonMetric, match);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldnt report to elasticsearch server", (Throwable)e);
        }
        catch (FailedtoConnectToElasticSearchException e) {
            LOGGER.error("Could not connect to any configured elasticsearch instances: {}", Arrays.asList(this.hosts));
        }
    }

    private List<JsonMetrics.JsonMetric<? extends Metric>> getJsonMetricsForGauges(SortedMap<String, Gauge> gauges, long timestamp) {
        return gauges.entrySet().stream().map(entry -> new JsonMetrics.JsonGauge(MetricRegistry.name((String)this.prefix, (String[])new String[]{(String)entry.getKey()}), timestamp, (Gauge)entry.getValue())).collect(Collectors.toList());
    }

    private List<JsonMetrics.JsonMetric<? extends Metric>> getJsonMetricsForCounters(SortedMap<String, Counter> counters, long timestamp) {
        return counters.entrySet().stream().map(entry -> new JsonMetrics.JsonCounter(MetricRegistry.name((String)this.prefix, (String[])new String[]{(String)entry.getKey()}), timestamp, (Counter)entry.getValue())).collect(Collectors.toList());
    }

    private List<JsonMetrics.JsonMetric<? extends Metric>> getJsonMetricsForHistograms(SortedMap<String, Histogram> histograms, long timestamp) {
        return histograms.entrySet().stream().map(entry -> new JsonMetrics.JsonHistogram(MetricRegistry.name((String)this.prefix, (String[])new String[]{(String)entry.getKey()}), timestamp, (Histogram)entry.getValue())).collect(Collectors.toList());
    }

    private List<JsonMetrics.JsonMetric<? extends Metric>> getJsonMetricsForMeters(SortedMap<String, Meter> meters, long timestamp) {
        return meters.entrySet().stream().map(entry -> new JsonMetrics.JsonMeter(MetricRegistry.name((String)this.prefix, (String[])new String[]{(String)entry.getKey()}), timestamp, (Meter)entry.getValue())).collect(Collectors.toList());
    }

    private List<JsonMetrics.JsonMetric<? extends Metric>> getJsonMetricsForTimers(SortedMap<String, Timer> timers, long timestamp) {
        return timers.entrySet().stream().map(entry -> new JsonMetrics.JsonTimer(MetricRegistry.name((String)this.prefix, (String[])new String[]{(String)entry.getKey()}), timestamp, (Timer)entry.getValue())).collect(Collectors.toList());
    }

    private void doReportForBatch(List<JsonMetrics.JsonMetric<? extends Metric>> jsonMetrics) throws FailedtoConnectToElasticSearchException, IOException {
        HttpPost request = new HttpPost("/_bulk");
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Cache-Control", "no-cache");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (JsonMetrics.JsonMetric<? extends Metric> jsonMetric : jsonMetrics) {
            this.writeJsonMetric(jsonMetric, this.writer, outputStream);
        }
        request.setEntity((HttpEntity)new ByteArrayEntity(outputStream.toByteArray()));
        try (CloseableHttpResponse response = this.executeRequest((HttpRequest)request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.error("Reporting returned code {} : {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            }
        }
    }

    private List<String> getPercolationMatches(JsonMetrics.JsonMetric<? extends Metric> jsonMetric) throws IOException {
        ArrayList<String> arrayList;
        block11: {
            HttpPost request = new HttpPost("/" + this.currentIndexName + "/" + jsonMetric.type() + "/_percolate");
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Cache-Control", "no-cache");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            HashMap<String, JsonMetrics.JsonMetric<? extends Metric>> data = new HashMap<String, JsonMetrics.JsonMetric<? extends Metric>>(1);
            data.put("doc", jsonMetric);
            this.objectMapper.writeValue((OutputStream)outputStream, data);
            request.setEntity((HttpEntity)new ByteArrayEntity(outputStream.toByteArray()));
            CloseableHttpResponse response = this.executeRequest((HttpRequest)request);
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("Error percolating " + jsonMetric);
                }
                Map input = (Map)this.objectMapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                ArrayList<String> matches = new ArrayList<String>();
                if (input.containsKey("matches") && input.get("matches") instanceof List) {
                    List foundMatches = (List)input.get("matches");
                    for (Map entry : foundMatches) {
                        if (!entry.containsKey("_id")) continue;
                        matches.add((String)entry.get("_id"));
                    }
                }
                arrayList = matches;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FailedtoConnectToElasticSearchException e) {
                    LOGGER.error("Could not connect to any configured elasticsearch instances for percolation: {}", Arrays.asList(this.hosts));
                    return Collections.emptyList();
                }
            }
            response.close();
        }
        return arrayList;
    }

    private boolean matchPercolationMetric(JsonMetrics.JsonMetric<? extends Metric> jsonMetric) {
        return this.percolationFilter != null && this.percolationFilter.matches(jsonMetric.name(), jsonMetric.value());
    }

    private void writeJsonMetric(JsonMetrics.JsonMetric<? extends Metric> jsonMetric, ObjectWriter writer, OutputStream out) throws IOException {
        writer.writeValue(out, (Object)new MetricsElasticsearchModule.BulkIndexOperationHeader(this.currentIndexName, jsonMetric.type()));
        out.write("\n".getBytes());
        writer.writeValue(out, jsonMetric);
        out.write("\n".getBytes());
        out.flush();
    }

    private CloseableHttpResponse executeRequest(String method, String uri) throws FailedtoConnectToElasticSearchException {
        for (String host : this.hosts) {
            try {
                HttpHost httpHost = HttpHost.create((String)("http://" + host));
                HttpRequest request = this.httpRequestFactory.newHttpRequest(method, uri);
                request.setHeader("Content-Type", "application/json");
                request.setHeader("Cache-Control", "no-cache");
                return this.httpClient.execute(httpHost, request);
            }
            catch (Exception e) {
                LOGGER.error("Error connecting to {}: {}", (Object)host, (Object)e);
                if (!this.hosts[this.hosts.length - 1].equals(host)) continue;
                LOGGER.error("Could not connect to any configured elasticsearch instances: {} for request {}", Arrays.asList(this.hosts), (Object)uri);
                throw new FailedtoConnectToElasticSearchException();
            }
        }
        throw new FailedtoConnectToElasticSearchException();
    }

    private CloseableHttpResponse executeRequest(HttpRequest request) throws FailedtoConnectToElasticSearchException {
        for (String host : this.hosts) {
            try {
                HttpHost httpHost = HttpHost.create((String)("http://" + host));
                return this.httpClient.execute(httpHost, request);
            }
            catch (Exception e) {
                LOGGER.error("Error connecting to {}: {}", (Object)host, (Object)e);
                if (!this.hosts[this.hosts.length - 1].equals(host)) continue;
                LOGGER.error("Could not connect to any configured elasticsearch instances: {} for request {}", Arrays.asList(this.hosts), (Object)request.getRequestLine().getUri());
                throw new FailedtoConnectToElasticSearchException();
            }
        }
        throw new FailedtoConnectToElasticSearchException();
    }

    private boolean isTemplateMissing() throws FailedtoConnectToElasticSearchException, IOException {
        try (CloseableHttpResponse response = this.executeRequest("HEAD", "/_template/metrics_template");){
            boolean bl = response.getStatusLine().getStatusCode() == 404;
            return bl;
        }
    }

    private void checkForIndexTemplate() {
        block12: {
            try {
                if (this.isTemplateMissing()) {
                    LOGGER.debug("No metrics template found in elasticsearch. Adding...");
                    HttpPut putTemplateRequest = new HttpPut("/_template/metrics_template");
                    putTemplateRequest.setHeader("Content-Type", "application/json");
                    putTemplateRequest.setHeader("Cache-Control", "no-cache");
                    byte[] requestJsonBody = this.writeIndexTemplateJson();
                    putTemplateRequest.setEntity((HttpEntity)new ByteArrayEntity(requestJsonBody));
                    try (CloseableHttpResponse putTemplateResponse = this.executeRequest((HttpRequest)putTemplateRequest);){
                        if (putTemplateResponse.getStatusLine().getStatusCode() != 200) {
                            LOGGER.error("Error adding metrics template to elasticsearch: {}/{}", (Object)putTemplateResponse.getStatusLine().getStatusCode(), (Object)putTemplateResponse.getStatusLine().getReasonPhrase());
                        }
                        this.checkedForIndexTemplate = true;
                        break block12;
                    }
                    catch (FailedtoConnectToElasticSearchException e) {
                        LOGGER.error("Error adding metrics template to elasticsearch", (Throwable)e);
                    }
                    break block12;
                }
                this.checkedForIndexTemplate = true;
            }
            catch (FailedtoConnectToElasticSearchException | IOException e) {
                LOGGER.error("Error when checking/adding metrics template to elasticsearch", (Throwable)e);
            }
        }
    }

    private byte[] writeIndexTemplateJson() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonGenerator json = new JsonFactory().createGenerator((OutputStream)outputStream);
        json.writeStartObject();
        json.writeStringField("template", this.index + "*");
        json.writeObjectFieldStart("mappings");
        json.writeObjectFieldStart("_default_");
        json.writeObjectFieldStart("_all");
        json.writeBooleanField("enabled", false);
        json.writeEndObject();
        json.writeObjectFieldStart("properties");
        json.writeObjectFieldStart("name");
        json.writeObjectField("type", (Object)"string");
        json.writeObjectField("index", (Object)"not_analyzed");
        json.writeEndObject();
        json.writeEndObject();
        json.writeEndObject();
        json.writeEndObject();
        json.writeEndObject();
        json.flush();
        return outputStream.toByteArray();
    }

    public void close() {
        super.close();
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error("Error when closing the http client", (Throwable)e);
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String[] hosts = new String[]{"localhost:9200"};
        private String index = "metrics";
        private String indexDateFormat = "yyyy-MM";
        private int bulkSize = 2500;
        private Notifier percolationNotifier;
        private MetricFilter percolationFilter;
        private int timeout = 5000;
        private String timestampFieldname = "@timestamp";
        private Map<String, ?> additionalFields;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder hosts(String ... hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder indexDateFormat(String indexDateFormat) {
            this.indexDateFormat = indexDateFormat;
            return this;
        }

        public Builder bulkSize(int bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder percolationFilter(MetricFilter percolationFilter) {
            this.percolationFilter = percolationFilter;
            return this;
        }

        public Builder percolationNotifier(Notifier notifier) {
            this.percolationNotifier = notifier;
            return this;
        }

        public Builder timestampFieldname(String fieldName) {
            this.timestampFieldname = fieldName;
            return this;
        }

        public Builder additionalFields(Map<String, ?> additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        public ElasticsearchReporter build() throws IOException {
            return new ElasticsearchReporter(this.registry, this.hosts, this.timeout, this.index, this.indexDateFormat, this.bulkSize, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.percolationFilter, this.percolationNotifier, this.timestampFieldname, this.additionalFields);
        }
    }
}

