/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly.util;

import java.util.ArrayList;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;

public class MissDetector {
    private final LongArrayList time = new LongArrayList();
    private final DoubleArrayList value = new DoubleArrayList();
    private final IntArrayList predictLabel = new IntArrayList();
    private final int len;
    private int minLength;
    private double threshold = 0.9999;
    private double lineBoundary = 0.6;
    private long startTime;
    private int windowCnt = 0;
    private double r2 = 0.0;
    private final ArrayList<MissingSubSeries> anomalyList = new ArrayList();

    public MissDetector(RowIterator iterator, int minLength) throws Exception {
        while (iterator.hasNextRow()) {
            Row row = iterator.next();
            double v = Util.getValueAsDouble(row);
            if (!Double.isFinite(v)) continue;
            this.time.add(row.getTime());
            this.value.add(v);
        }
        this.len = this.time.size();
        this.minLength = minLength;
    }

    public void detect() {
        this.getPredictLabel().addAll(new int[this.getLen()]);
        this.startTime = this.getTime().get(0);
        int i = 0;
        int windowSize = this.minLength / 2;
        double[][] data = new double[windowSize][2];
        SimpleRegression regression = new SimpleRegression();
        while (i + windowSize < this.getLen()) {
            for (int j = 0; j < windowSize; ++j) {
                data[j][0] = (double)this.getTime().get(i + j) - (double)this.startTime;
                data[j][1] = this.getValue().get(i + j);
            }
            regression.addData(data);
            double alpha = regression.getRSquare();
            i = Double.isNaN(alpha) || alpha >= this.threshold ? this.extend(regression, i, i + windowSize) : (i += windowSize);
            regression.clear();
            this.r2 += Double.isNaN(alpha) ? 1.0 : alpha;
            ++this.windowCnt;
        }
        this.label();
    }

    private int extend(SimpleRegression regression, int start, int end) {
        int findex;
        boolean horizon = Double.isNaN(regression.getRSquare());
        double standard = regression.getIntercept();
        int bindex = start;
        while (bindex > 0) {
            regression.addData((double)this.getTime().get(--bindex) - (double)this.startTime, this.getValue().get(bindex));
            double alpha = regression.getRSquare();
            if ((!horizon || this.getValue().get(bindex) == standard) && (horizon || !(alpha < this.threshold))) continue;
            break;
        }
        regression.removeData((double)this.getTime().get(bindex) - (double)this.startTime, this.getValue().get(bindex));
        if (bindex == 0) {
            return end;
        }
        for (findex = end; findex < this.getLen(); ++findex) {
            regression.addData((double)this.getTime().get(findex) - (double)this.startTime, this.getValue().get(findex));
            double alpha = regression.getRSquare();
            if (horizon && this.getValue().get(findex) != standard || !horizon && alpha < this.threshold) break;
        }
        if (findex == this.getLen()) {
            return end;
        }
        MissingSubSeries m4 = new MissingSubSeries(bindex + 1, findex);
        this.anomalyList.add(m4);
        return findex;
    }

    private void label() {
        if (this.r2 / (double)this.windowCnt < this.lineBoundary) {
            for (MissingSubSeries m4 : this.anomalyList) {
                if (m4.getLength() < this.minLength) continue;
                for (int i = m4.getStart(); i < m4.getEnd(); ++i) {
                    this.getPredictLabel().set(i, 1);
                }
            }
        }
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public IntArrayList getPredictLabel() {
        return this.predictLabel;
    }

    public int getLen() {
        return this.len;
    }

    public LongArrayList getTime() {
        return this.time;
    }

    public DoubleArrayList getValue() {
        return this.value;
    }

    private class MissingSubSeries
    implements Comparable<MissingSubSeries> {
        private int start;
        private int end;
        private double slope;

        public MissingSubSeries() {
        }

        public MissingSubSeries(int start, int end) {
            this.start = start;
            this.end = end;
            this.slope = (MissDetector.this.getValue().get(end - 1) - MissDetector.this.getValue().get(start)) / (double)(MissDetector.this.getTime().get(end - 1) - MissDetector.this.getTime().get(start));
        }

        public String toString() {
            return String.format("Start: %d, End: %d, Length: %d, Slope: %.12f", this.start, this.end, this.end - this.start, this.slope);
        }

        public int getLength() {
            return this.end - this.start;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public double getSlope() {
            return this.slope;
        }

        public void setSlope(double slope) {
            this.slope = slope;
        }

        @Override
        public int compareTo(MissingSubSeries o) {
            if (this.getLength() > o.getLength()) {
                return -1;
            }
            if (this.getLength() == o.getLength()) {
                return 0;
            }
            return 1;
        }
    }
}

