/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanNodeDecorrelator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.Util;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.Type;

public class TransformExistsApplyToCorrelatedJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private final PlannerContext plannerContext;

    public TransformExistsApplyToCorrelatedJoin(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        ApplyNode.SetExpression expression = (ApplyNode.SetExpression)Iterables.getOnlyElement(parent.getSubqueryAssignments().values());
        if (!(expression instanceof ApplyNode.Exists)) {
            return Rule.Result.empty();
        }
        if (parent.getCorrelation().isEmpty()) {
            return Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context));
        }
        Optional<PlanNode> nonDefaultAggregation = this.rewriteToNonDefaultAggregation(parent, context);
        return nonDefaultAggregation.map(Rule.Result::ofPlanNode).orElseGet(() -> Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context)));
    }

    private Optional<PlanNode> rewriteToNonDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Preconditions.checkState((boolean)applyNode.getSubquery().getOutputSymbols().isEmpty(), (Object)"Expected subquery output symbols to be pruned");
        Symbol subqueryTrue = context.getSymbolAllocator().newSymbol("subqueryTrue", (Type)BooleanType.BOOLEAN);
        ProjectNode subquery = new ProjectNode(context.getIdAllocator().genPlanNodeId(), new LimitNode(context.getIdAllocator().genPlanNodeId(), applyNode.getSubquery(), 1L, Optional.empty()), Assignments.of(subqueryTrue, BooleanLiteral.TRUE_LITERAL));
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup());
        if (!decorrelator.decorrelateFilters(subquery, applyNode.getCorrelation()).isPresent()) {
            return Optional.empty();
        }
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().keySet());
        Assignments.Builder assignments = Assignments.builder().putIdentities(applyNode.getInput().getOutputSymbols()).put(exists, new CoalesceExpression((List<Expression>)ImmutableList.of((Object)subqueryTrue.toSymbolReference(), (Object)BooleanLiteral.FALSE_LITERAL)));
        return Optional.of(new ProjectNode(context.getIdAllocator().genPlanNodeId(), new CorrelatedJoinNode(applyNode.getPlanNodeId(), applyNode.getInput(), subquery, applyNode.getCorrelation(), JoinNode.JoinType.LEFT, BooleanLiteral.TRUE_LITERAL, applyNode.getOriginSubquery()), assignments.build()));
    }

    private PlanNode rewriteToDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        ResolvedFunction countFunction = Util.getResolvedBuiltInAggregateFunction(this.plannerContext.getMetadata(), "count", (List<Type>)ImmutableList.of());
        Symbol count = context.getSymbolAllocator().newSymbol("count", (Type)LongType.getInstance());
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().keySet());
        return new CorrelatedJoinNode(applyNode.getPlanNodeId(), applyNode.getInput(), new ProjectNode(context.getIdAllocator().genPlanNodeId(), AggregationNode.singleAggregation(context.getIdAllocator().genPlanNodeId(), applyNode.getSubquery(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(countFunction, (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty())), AggregationNode.globalAggregation()), Assignments.of(exists, new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, count.toSymbolReference(), new Cast(new LongLiteral("0"), TypeSignatureTranslator.toSqlType((Type)LongType.getInstance()))))), applyNode.getCorrelation(), JoinNode.JoinType.INNER, BooleanLiteral.TRUE_LITERAL, applyNode.getOriginSubquery());
    }
}

