/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.tv;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.TVListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.util.BinaryUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;

public class ElasticSerializableBinaryTVList
extends ElasticSerializableTVList {
    protected static final int MEMORY_CHECK_THRESHOLD = 1000;
    protected int byteArrayLengthForMemoryControl = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
    protected long totalByteArrayLengthLimit = 0L;
    protected long totalByteArrayLength = 0L;
    protected int lastPointCount;

    public ElasticSerializableBinaryTVList(String queryId, float memoryLimitInMB, int cacheSize) {
        super(TSDataType.TEXT, queryId, memoryLimitInMB, cacheSize);
    }

    @Override
    public void putColumn(Column timeColumn, Column valueColumn) throws IOException {
        super.putColumn(timeColumn, valueColumn);
        long count = timeColumn.getPositionCount();
        this.totalByteArrayLengthLimit += (long)this.byteArrayLengthForMemoryControl * count;
        int i = 0;
        while ((long)i < count) {
            this.totalByteArrayLength = valueColumn.isNull(i) ? (this.totalByteArrayLength += (long)this.byteArrayLengthForMemoryControl) : (this.totalByteArrayLength += (long)valueColumn.getBinary(i).getLength());
            ++i;
        }
        this.checkMemoryUsage();
    }

    private void checkMemoryUsage() throws IOException {
        if (this.pointCount - this.lastPointCount < 1000 || this.totalByteArrayLength <= this.totalByteArrayLengthLimit) {
            return;
        }
        this.lastPointCount = this.pointCount;
        int newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl;
        while ((long)newByteArrayLengthForMemoryControl * (long)this.pointCount < this.totalByteArrayLength) {
            newByteArrayLengthForMemoryControl *= 2;
        }
        int newInternalTVListCapacity = BinaryUtils.calculateCapacity(this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.cacheSize;
        if (newInternalTVListCapacity > 0) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        int delta = (int)((this.totalByteArrayLength - this.totalByteArrayLengthLimit) / (long)this.pointCount / (long)SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
        newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl + 2 * (delta + 1) * SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
        newInternalTVListCapacity = BinaryUtils.calculateCapacity(this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.cacheSize;
        if (newInternalTVListCapacity > 0) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        throw new RuntimeException("Memory is not enough for current query.");
    }

    private void applyNewMemoryControlParameters(int newByteArrayLengthForMemoryControl, int newInternalTVListCapacity) throws IOException {
        ElasticSerializableTVList newESTVList = new ElasticSerializableTVList(TSDataType.TEXT, this.queryId, this.memoryLimitInMB, newInternalTVListCapacity, this.cacheSize);
        newESTVList.evictionUpperBound = this.evictionUpperBound;
        int internalListEvictionUpperBound = this.evictionUpperBound / newInternalTVListCapacity;
        for (int i = 0; i < internalListEvictionUpperBound; ++i) {
            newESTVList.internalTVList.add(null);
            if (i == 0) continue;
            newESTVList.internalColumnCountList.add(0);
        }
        newESTVList.pointCount = internalListEvictionUpperBound * newInternalTVListCapacity;
        int emptyColumnSize = this.evictionUpperBound - newESTVList.pointCount;
        if (emptyColumnSize != 0) {
            Binary empty = BytesUtils.valueOf((String)"");
            TimeColumnBuilder timeColumnBuilder = new TimeColumnBuilder(null, emptyColumnSize);
            BinaryColumnBuilder valueColumnBuilder = new BinaryColumnBuilder(null, emptyColumnSize);
            for (int i = 0; i < emptyColumnSize; ++i) {
                timeColumnBuilder.writeLong((long)i);
                valueColumnBuilder.writeBinary(empty);
            }
            TimeColumn timeColumn = (TimeColumn)timeColumnBuilder.build();
            Column valueColumn = valueColumnBuilder.build();
            newESTVList.putColumn((Column)timeColumn, valueColumn);
        }
        this.copyLatterColumnsAfterEvictionUpperBound(newESTVList);
        this.internalTVListCapacity = newInternalTVListCapacity;
        this.cache = newESTVList.cache;
        this.internalTVList = newESTVList.internalTVList;
        this.internalColumnCountList = newESTVList.internalColumnCountList;
        this.byteArrayLengthForMemoryControl = newByteArrayLengthForMemoryControl;
        this.totalByteArrayLengthLimit = (long)this.pointCount * (long)this.byteArrayLengthForMemoryControl;
        this.notifyAllIterators();
    }

    public void copyLatterColumnsAfterEvictionUpperBound(ElasticSerializableTVList newESTVList) throws IOException {
        int externalColumnIndex = this.evictionUpperBound / this.internalTVListCapacity;
        int internalRowIndex = this.evictionUpperBound % this.internalTVListCapacity;
        int internalColumnIndex = ((SerializableTVList)this.internalTVList.get(externalColumnIndex)).getColumnIndex(internalRowIndex);
        int tvOffsetInColumns = ((SerializableTVList)this.internalTVList.get(externalColumnIndex)).getTVOffsetInColumns(internalRowIndex);
        TVListForwardIterator iterator = new TVListForwardIterator(this, externalColumnIndex, internalColumnIndex);
        Column timeColumn = iterator.currentTimes();
        Column valueColumn = iterator.currentValues();
        if (tvOffsetInColumns != 0) {
            timeColumn = timeColumn.subColumnCopy(tvOffsetInColumns);
            valueColumn = valueColumn.subColumnCopy(tvOffsetInColumns);
        }
        newESTVList.putColumn(timeColumn, valueColumn);
        while (iterator.hasNext()) {
            iterator.next();
            this.copyColumnByIterator(newESTVList, iterator);
        }
    }

    public void notifyAllIterators() throws IOException {
        for (TVListForwardIterator iterator : this.iteratorList) {
            iterator.adjust();
        }
    }

    private void copyColumnByIterator(ElasticSerializableTVList target, TVListForwardIterator source) throws IOException {
        Column timeColumn = source.currentTimes();
        Column valueColumn = source.currentValues();
        target.putColumn(timeColumn, valueColumn);
    }
}

