/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeStatement;

public class DropPipe
extends PipeStatement {
    private final String pipeName;
    private final boolean ifExistsCondition;

    public DropPipe(String pipeName, boolean ifExistsCondition) {
        this.pipeName = Objects.requireNonNull(pipeName, "pipe name can not be null");
        this.ifExistsCondition = ifExistsCondition;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean hasIfExistsCondition() {
        return this.ifExistsCondition;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropPipe(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipeName, this.ifExistsCondition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropPipe that = (DropPipe)obj;
        return Objects.equals(this.pipeName, that.pipeName) && Objects.equals(this.ifExistsCondition, that.ifExistsCondition);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pipeName", (Object)this.pipeName).add("ifExistsCondition", this.ifExistsCondition).toString();
    }
}

