/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class DoubleConstantFill
implements IFill {
    private final double value;
    private final double[] valueArray;

    public DoubleConstantFill(double value) {
        this.value = value;
        this.valueArray = new double[]{value};
    }

    @Override
    public Column fill(Column timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (!valueColumn.mayHaveNull() || size == 0) {
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return new RunLengthEncodedColumn((Column)new DoubleColumn(1, Optional.empty(), this.valueArray), size);
        }
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = valueColumn.isNull(i) ? this.value : valueColumn.getDouble(i);
        }
        return new DoubleColumn(size, Optional.empty(), array);
    }

    @Override
    public void reset() {
    }
}

