# TECATOR dataset
# The purpose of this dataset is to measure the fat content of meat based off its near infrared absorbance spectrum.
# The absorbance spectrum is measured in the wavelength range of 850 nm to 1050 nm.
# The fat content is measured by standard chemical analysis methods.
# The dataset contains 215 samples of meat, each with 100 spectral measurements.
# For more information see: https://www.openml.org/search?type=data&sort=runs&id=505&status=active
# References:
# [1] C.Borggaard and H.H.Thodberg, "Optimal Minimal Neural Interpretation of Spectra", Analytical Chemistry 64 (1992), p 545-551.
# [2] H.H.Thodberg, "Ace of Bayes: Application of Neural Networks with Pruning" Manuscript 1132, Danish Meat Research Institute (1993), available by anonymous ftp in the file: pub/neuroprose/thodberg.ace-of-bayes.ps.Z on the Internet node https://www.openml.org/d/505

@problemName TECATOR
@timeStamps false
@missing false
@univariate true
@equalLength true
@targetLabel true
@data
2.61776,2.61814,2.61859,2.61912,2.61981,2.62071,2.62186,2.62334,2.62511,2.62722,2.62964,2.63245,2.63565,2.63933,2.64353,2.64825,2.6535,2.65937,2.66585,2.67281,2.68008,2.68733,2.69427,2.70073,2.70684,2.71281,2.71914,2.72628,2.73462,2.74416,2.75466,2.76568,2.77679,2.7879,2.79949,2.81225,2.82706,2.84356,2.86106,2.87857,2.89497,2.90924,2.92085,2.93015,2.93846,2.94771,2.96019,2.97831,3.00306,3.03506,3.07428,3.11963,3.16868,3.21771,3.26254,3.29988,3.32847,3.34899,3.36342,3.37379,3.38152,3.38741,3.39164,3.39418,3.3949,3.39366,3.39045,3.38541,3.37869,3.37041,3.36073,3.34979,3.33769,3.32443,3.31013,3.29487,3.27891,3.26232,3.24542,3.22828,3.2108,3.19287,3.17433,3.15503,3.13475,3.11339,3.09116,3.0685,3.04596,3.02393,3.00247,2.98145,2.96072,2.94013,2.91978,2.89966,2.87964,2.8596,2.8394,2.8192:22.5
2.83454,2.83871,2.84283,2.84705,2.85138,2.85587,2.8606,2.86566,2.87093,2.87661,2.88264,2.88898,2.89577,2.90308,2.91097,2.91953,2.92873,2.93863,2.94929,2.96072,2.97272,2.98493,2.9969,3.00833,3.0192,3.0299,3.04101,3.05345,3.06777,3.08416,3.10221,3.12106,3.13983,3.1581,3.17623,3.19519,3.21584,3.23747,3.25889,3.27835,3.29384,3.30362,3.30681,3.30393,3.297,3.28925,3.28409,3.28505,3.29326,3.30923,3.33267,3.36251,3.39661,3.43188,3.46492,3.49295,3.51458,3.53004,3.54067,3.54797,3.55306,3.55675,3.55921,3.56045,3.56034,3.55876,3.55571,3.55132,3.54585,3.5395,3.53235,3.52442,3.51583,3.50668,3.497,3.48683,3.47626,3.46552,3.45501,3.44481,3.43477,3.42465,3.41419,3.40303,3.39082,3.37731,3.36265,3.34745,3.33245,3.31818,3.30473,3.29186,3.27921,3.26655,3.25369,3.24045,3.22659,3.21181,3.196,3.17942:40.1
2.58284,2.58458,2.58629,2.58808,2.58996,2.59192,2.59401,2.59627,2.59873,2.60131,2.60414,2.60714,2.61029,2.61361,2.61714,2.62089,2.62486,2.62909,2.63361,2.63835,2.6433,2.64838,2.65354,2.6587,2.66375,2.6688,2.67383,2.67892,2.68411,2.68937,2.6947,2.70012,2.70563,2.71141,2.71775,2.7249,2.73344,2.74327,2.75433,2.76642,2.77931,2.79272,2.80649,2.82064,2.83541,2.85121,2.86872,2.88905,2.91289,2.94088,2.97325,3.00946,3.0478,3.08554,3.11947,3.14696,3.16677,3.17938,3.18631,3.18924,3.1895,3.18801,3.18498,3.18039,3.17411,3.16611,3.15641,3.14512,3.13241,3.11843,3.10329,3.08714,3.07014,3.05237,3.03393,3.01504,2.99569,2.97612,2.95642,2.9366,2.91667,2.89655,2.87622,2.85563,2.83474,2.81361,2.79235,2.77113,2.75015,2.72956,2.70934,2.68951,2.67009,2.65112,2.63262,2.61461,2.59718,2.58034,2.56404,2.54816:8.4
2.82286,2.8246,2.8263,2.82814,2.83001,2.83192,2.83392,2.83606,2.83842,2.84097,2.84374,2.84664,2.84975,2.85307,2.85661,2.86038,2.86437,2.8686,2.87308,2.87789,2.88301,2.88832,2.89374,2.89917,2.90457,2.90991,2.91521,2.92043,2.92565,2.93082,2.93604,2.94128,2.94658,2.95202,2.95777,2.96419,2.97159,2.98045,2.9909,3.00284,3.01611,3.03048,3.04579,3.06194,3.07889,3.09686,3.11629,3.13775,3.16217,3.19068,3.22376,3.26172,3.30379,3.34793,3.39093,3.4292,3.45998,3.48227,3.49687,3.50558,3.51026,3.51221,3.51215,3.51036,3.50682,3.5014,3.49398,3.48457,3.47333,3.46041,3.44595,3.43005,3.41285,3.3945,3.37511,3.35482,3.33376,3.31204,3.28986,3.2673,3.24442,3.22117,3.19757,3.17357,3.14915,3.12429,3.09908,3.07366,3.04825,3.02308,2.9982,2.97367,2.94951,2.92576,2.90251,2.87988,2.85794,2.83672,2.81617,2.79622:5.9
2.78813,2.78989,2.79167,2.7935,2.79538,2.79746,2.79984,2.80254,2.80553,2.8089,2.81272,2.81704,2.82184,2.8271,2.83294,2.83945,2.84664,2.85458,2.86331,2.8728,2.88291,2.89335,2.90374,2.91371,2.92305,2.93187,2.9406,2.94986,2.96035,2.97241,2.98606,3.00097,3.01652,3.0322,3.04793,3.06413,3.08153,3.10078,3.12185,3.14371,3.1651,3.1847,3.2014,3.21477,3.22544,3.23505,3.24586,3.26027,3.28063,3.30889,3.34543,3.39019,3.44198,3.498,3.55407,3.60534,3.64789,3.68011,3.70272,3.71815,3.72863,3.73574,3.74059,3.74357,3.74453,3.74336,3.73991,3.73418,3.72638,3.71676,3.70553,3.69289,3.679,3.66396,3.64785,3.63085,3.61305,3.59463,3.57582,3.55695,3.53796,3.5188,3.49936,3.47938,3.45869,3.43711,3.41458,3.39129,3.36772,3.3445,3.32201,3.30025,3.27907,3.25831,3.23784,3.21765,3.19766,3.1777,3.1577,3.13753:25.5
3.00993,3.0154,3.02086,3.02634,3.0319,3.03756,3.04341,3.04955,3.05599,3.06274,3.06982,3.07724,3.08511,3.09343,3.10231,3.11185,3.12205,3.13294,3.14457,3.15703,3.17038,3.18429,3.1984,3.21225,3.22552,3.23827,3.25084,3.26393,3.27851,3.29514,3.31401,3.33458,3.35591,3.37709,3.39772,3.41828,3.43974,3.46266,3.48663,3.51002,3.53087,3.54711,3.55699,3.55986,3.55656,3.54937,3.54169,3.53692,3.53823,3.5476,3.56512,3.59043,3.62229,3.6583,3.69515,3.72932,3.75803,3.78003,3.7956,3.80614,3.81313,3.81774,3.82079,3.82258,3.82301,3.82206,3.81959,3.81557,3.81021,3.80375,3.79642,3.78835,3.77958,3.77024,3.7604,3.75005,3.73929,3.72831,3.71738,3.70681,3.69664,3.68659,3.67649,3.66611,3.65503,3.64283,3.62938,3.61483,3.5999,3.58535,3.57163,3.55877,3.54651,3.53442,3.52221,3.50972,3.49682,3.48325,3.4687,3.45307:42.7
2.98893,2.99435,2.9998,3.0054,3.01117,3.01716,3.02347,3.03014,3.03708,3.04445,3.05213,3.06032,3.06905,3.07841,3.08846,3.09918,3.11059,3.12265,3.13566,3.14936,3.16331,3.17695,3.19001,3.20256,3.21496,3.22788,3.24197,3.25812,3.27652,3.29661,3.31746,3.33822,3.35857,3.37882,3.39971,3.42189,3.44511,3.46814,3.48887,3.50519,3.51543,3.51885,3.51619,3.50972,3.50259,3.49802,3.49875,3.50653,3.52275,3.54677,3.57737,3.61244,3.64869,3.68262,3.71139,3.7336,3.74947,3.76022,3.76731,3.77206,3.77511,3.77666,3.77696,3.77594,3.77346,3.76953,3.76426,3.75787,3.75055,3.74243,3.73368,3.72442,3.71475,3.70463,3.69406,3.68318,3.67229,3.66175,3.6516,3.64173,3.63191,3.62177,3.61102,3.59929,3.58642,3.57249,3.55803,3.54375,3.53017,3.51747,3.50544,3.49372,3.48197,3.46996,3.45756,3.44456,3.4307,3.41583,3.40018,3.38415:42.7
2.52582,2.52665,2.52758,2.52844,2.52944,2.53057,2.53187,2.53339,2.53516,2.5371,2.53937,2.54193,2.54471,2.54776,2.55112,2.55479,2.55881,2.56321,2.56808,2.57328,2.57875,2.58436,2.58994,2.59539,2.60069,2.60591,2.61119,2.61666,2.62246,2.62858,2.63502,2.64172,2.64861,2.65579,2.6635,2.67238,2.68288,2.69511,2.709,2.72432,2.74071,2.75776,2.77516,2.79274,2.81083,2.83024,2.85189,2.87681,2.90596,2.94022,2.98013,3.02557,3.07533,3.12683,3.17635,3.21975,3.25322,3.27754,3.29438,3.30581,3.31357,3.31875,3.32198,3.32346,3.32312,3.32085,3.3165,3.3101,3.30175,3.29157,3.27989,3.26688,3.25257,3.23709,3.22056,3.20312,3.18497,3.16623,3.14704,3.12753,3.10768,3.0875,3.06697,3.04598,3.02452,3.00249,2.97994,2.95703,2.93406,2.91133,2.88903,2.8672,2.84572,2.82458,2.80388,2.78372,2.76415,2.74515,2.72671,2.70876:10.6
3.27336,3.27996,3.28646,3.293,3.29956,3.30627,3.3131,3.32006,3.32727,3.33472,3.34243,3.35035,3.35847,3.3669,3.37569,3.38485,3.39442,3.40444,3.41491,3.42586,3.43719,3.44863,3.45991,3.47089,3.48148,3.49178,3.50214,3.51296,3.52454,3.53691,3.54991,3.5633,3.5768,3.59026,3.60391,3.61845,3.63442,3.65194,3.67066,3.68994,3.70901,3.72709,3.74353,3.75823,3.77184,3.78596,3.80248,3.82298,3.8487,3.88066,3.91941,3.96476,4.01541,4.06862,4.12026,4.16604,4.20183,4.22819,4.24688,4.25992,4.26905,4.27545,4.2798,4.28231,4.28294,4.28151,4.27792,4.27216,4.26428,4.25443,4.24303,4.23031,4.21632,4.20117,4.18489,4.16765,4.14958,4.13086,4.11177,4.09248,4.07291,4.05302,4.03267,4.01176,3.99019,3.96779,3.94456,3.92067,3.89656,3.87259,3.84916,3.8262,3.80355,3.78118,3.75899,3.73709,3.71543,3.69395,3.67259,3.65127:19.9
3.39805,3.40539,3.41271,3.42001,3.42735,3.43479,3.44245,3.45035,3.45838,3.46665,3.47511,3.48385,3.49294,3.50235,3.51212,3.5223,3.53289,3.54394,3.55545,3.56757,3.58,3.59235,3.60434,3.61589,3.62715,3.63838,3.64981,3.66176,3.67455,3.68842,3.70286,3.71741,3.73184,3.7464,3.76172,3.77839,3.7967,3.81651,3.83715,3.8577,3.8771,3.89458,3.91029,3.92492,3.94003,3.9574,3.97887,4.00603,4.04003,4.08151,4.1302,4.18452,4.24136,4.29569,4.3424,4.37906,4.40592,4.42495,4.43846,4.44838,4.45557,4.4605,4.46341,4.46421,4.46273,4.45887,4.45276,4.44461,4.43461,4.423,4.40969,4.395,4.37887,4.36182,4.34385,4.32492,4.30535,4.28533,4.2651,4.2446,4.22354,4.20185,4.17942,4.15606,4.13174,4.10661,4.08106,4.05559,4.03052,4.00597,3.98173,3.95779,3.93407,3.91059,3.88728,3.86413,3.84107,3.81811,3.79531,3.77262:19.9
3.00881,3.01401,3.01934,3.02469,3.03022,3.03601,3.04208,3.04849,3.05534,3.0626,3.07018,3.07828,3.08691,3.09627,3.10638,3.11723,3.12885,3.14127,3.15456,3.16894,3.18387,3.19888,3.21336,3.22713,3.24044,3.2539,3.26826,3.28433,3.3027,3.32378,3.34651,3.36966,3.39228,3.41441,3.43678,3.46017,3.48473,3.50961,3.53306,3.55286,3.56614,3.57109,3.56832,3.55997,3.54949,3.54064,3.53661,3.53963,3.55094,3.57077,3.59835,3.63193,3.66867,3.7046,3.73568,3.76005,3.77764,3.78962,3.79751,3.80265,3.80594,3.80782,3.80838,3.80757,3.80529,3.8015,3.79631,3.78995,3.78265,3.77458,3.76591,3.75677,3.7471,3.73704,3.72657,3.71589,3.70526,3.69496,3.6851,3.67558,3.6661,3.65638,3.64604,3.63463,3.62193,3.6081,3.59366,3.57945,3.56603,3.55354,3.54178,3.53029,3.51872,3.50678,3.49431,3.48107,3.46677,3.45126,3.43478,3.41792:46.0
2.15499,2.1545,2.15393,2.15342,2.153,2.15263,2.1523,2.15209,2.15214,2.15232,2.15265,2.15305,2.15356,2.15424,2.15514,2.15623,2.15748,2.1589,2.16058,2.16251,2.16471,2.16703,2.16941,2.17181,2.17418,2.17661,2.179,2.18122,2.18325,2.18511,2.1869,2.18885,2.19117,2.19409,2.19797,2.20315,2.21031,2.2195,2.23088,2.24446,2.26009,2.27765,2.2971,2.31839,2.34155,2.36663,2.39397,2.4245,2.4589,2.49783,2.5416,2.5894,2.63917,2.68768,2.73133,2.76738,2.79485,2.81454,2.82838,2.83813,2.84525,2.85047,2.85403,2.85586,2.85589,2.85389,2.84985,2.84396,2.83637,2.82722,2.81669,2.80476,2.79161,2.77734,2.76216,2.74616,2.72948,2.71228,2.69452,2.67636,2.65782,2.63887,2.61947,2.59956,2.57921,2.55853,2.53763,2.51673,2.49598,2.47541,2.45506,2.43495,2.41518,2.39586,2.37715,2.35907,2.34173,2.32514,2.30934,2.29418:0.9
2.88841,2.89612,2.90365,2.91112,2.91849,2.9258,2.93305,2.94026,2.94758,2.95479,2.96199,2.96915,2.97629,2.98345,2.99066,2.99786,3.00509,3.01239,3.01979,3.02726,3.03478,3.04228,3.04975,3.05717,3.0645,3.07174,3.07889,3.08585,3.09261,3.09925,3.10582,3.1123,3.11879,3.12548,3.13253,3.14018,3.14885,3.15851,3.16929,3.18116,3.19405,3.20791,3.22266,3.23827,3.25478,3.27232,3.29121,3.31209,3.33552,3.36191,3.39153,3.42403,3.45826,3.49226,3.52367,3.55044,3.57162,3.58746,3.59899,3.60745,3.61372,3.61844,3.62181,3.62383,3.62442,3.62355,3.6212,3.6174,3.61231,3.60604,3.59863,3.59021,3.58088,3.57073,3.55985,3.54833,3.53635,3.52394,3.51121,3.49822,3.48495,3.47135,3.45745,3.44325,3.42874,3.41397,3.39902,3.38402,3.36908,3.35426,3.3396,3.3251,3.31075,3.29666,3.28288,3.26947,3.25639,3.24368,3.23138,3.21932:2.9
2.9886,2.99705,3.00537,3.01352,3.02157,3.02955,3.03748,3.04537,3.05328,3.06115,3.06899,3.07685,3.08469,3.09251,3.10034,3.10823,3.11618,3.12415,3.13224,3.14041,3.14863,3.15685,3.16505,3.1732,3.18126,3.18918,3.19704,3.20476,3.21232,3.21976,3.22709,3.23435,3.24164,3.24907,3.25699,3.26552,3.27506,3.28564,3.29734,3.31014,3.324,3.33882,3.35453,3.37108,3.38847,3.40692,3.42678,3.44871,3.47318,3.50074,3.53165,3.56558,3.60135,3.63697,3.67002,3.69845,3.72121,3.73845,3.75124,3.76063,3.76763,3.77297,3.77689,3.77941,3.78035,3.77972,3.77757,3.77394,3.76891,3.76259,3.7551,3.74657,3.73706,3.72672,3.71559,3.70386,3.69156,3.67891,3.66593,3.65263,3.63907,3.62524,3.61109,3.59664,3.5819,3.56688,3.55166,3.53639,3.52124,3.50625,3.4914,3.47672,3.46227,3.44807,3.43416,3.42061,3.40749,3.39474,3.38234,3.37017:3.5
3.13203,3.14117,3.15015,3.15899,3.16774,3.17642,3.18504,3.1936,3.20214,3.21066,3.21913,3.22759,3.23606,3.24454,3.25304,3.26157,3.27014,3.27879,3.2875,3.29634,3.3052,3.31408,3.32297,3.33181,3.34055,3.34926,3.35777,3.36619,3.37447,3.38264,3.39072,3.39872,3.40672,3.41491,3.4235,3.43277,3.44309,3.45456,3.46717,3.48094,3.49584,3.51181,3.52873,3.54649,3.56513,3.58482,3.60596,3.62921,3.65508,3.68411,3.71668,3.75254,3.79061,3.82891,3.86499,3.89659,3.92226,3.94198,3.95668,3.96754,3.97573,3.98199,3.98652,3.98942,3.99071,3.99027,3.98813,3.98433,3.97893,3.97211,3.96402,3.95479,3.9445,3.93332,3.92123,3.90845,3.89505,3.88129,3.86723,3.85287,3.83821,3.82326,3.80804,3.79254,3.77668,3.76055,3.74429,3.72799,3.71176,3.6957,3.67987,3.6643,3.64899,3.63392,3.61912,3.60474,3.59085,3.57745,3.56438,3.55159:4.0
2.50688,2.50783,2.5088,2.50985,2.51101,2.51229,2.51369,2.51523,2.51692,2.51888,2.52103,2.52331,2.52576,2.52841,2.53122,2.53423,2.53752,2.54095,2.54465,2.54859,2.55274,2.55703,2.5614,2.56579,2.57016,2.57449,2.5788,2.5831,2.58734,2.59156,2.59575,2.59996,2.60428,2.60886,2.61396,2.61985,2.62702,2.63551,2.64524,2.65624,2.66831,2.68128,2.69503,2.7095,2.72479,2.74116,2.75911,2.77959,2.80313,2.83051,2.862,2.89712,2.93444,2.97142,3.00482,3.03191,3.05143,3.06386,3.07077,3.07371,3.07402,3.07252,3.06948,3.06492,3.05869,3.05075,3.04106,3.0297,3.01681,3.00253,2.98699,2.9703,2.95266,2.93406,2.91468,2.8946,2.87393,2.85285,2.83147,2.80986,2.78794,2.76571,2.74317,2.72026,2.69701,2.67351,2.64986,2.62621,2.60273,2.57953,2.55669,2.53422,2.51217,2.49056,2.46947,2.44895,2.42914,2.41002,2.39156,2.37374:5.2
2.62979,2.632,2.63413,2.63626,2.63846,2.64072,2.64303,2.64548,2.648,2.65065,2.65346,2.6564,2.65947,2.66264,2.66592,2.6694,2.67302,2.67689,2.68095,2.68514,2.68946,2.69387,2.69828,2.70267,2.70697,2.71114,2.71522,2.71923,2.72323,2.72725,2.73128,2.73533,2.73948,2.74393,2.74898,2.755,2.76246,2.77138,2.78171,2.79331,2.806,2.81959,2.83391,2.84895,2.86486,2.88209,2.90118,2.92336,2.94913,2.97917,3.01363,3.0519,3.09222,3.13179,3.16746,3.19675,3.21871,3.23405,3.24441,3.25133,3.25598,3.25903,3.26062,3.26066,3.25909,3.25586,3.25095,3.24435,3.23616,3.22654,3.2156,3.20347,3.19022,3.17585,3.16056,3.14436,3.12748,3.11004,3.09214,3.07381,3.05504,3.03578,3.01601,2.99572,2.97493,2.95364,2.93202,2.91024,2.8885,2.86696,2.84566,2.82459,2.80375,2.78326,2.7632,2.74361,2.72461,2.70611,2.6881,2.67051:5.6
2.91792,2.91896,2.92004,2.92119,2.92238,2.92373,2.92528,2.92693,2.9288,2.93089,2.93321,2.93566,2.9383,2.94111,2.94409,2.9473,2.95075,2.9544,2.95826,2.96232,2.96659,2.97107,2.97566,2.98024,2.98478,2.98931,2.99389,2.99849,3.00307,3.00766,3.01223,3.01679,3.02143,3.0263,3.0316,3.03762,3.04465,3.05273,3.06198,3.07224,3.0833,3.09495,3.10709,3.11965,3.13274,3.14673,3.16206,3.17967,3.20029,3.22445,3.25241,3.28373,3.3169,3.34946,3.37856,3.40178,3.41794,3.42745,3.4317,3.43221,3.43037,3.42683,3.42186,3.41537,3.40732,3.39762,3.38629,3.37347,3.35928,3.34381,3.32721,3.30963,3.2912,3.27207,3.25225,3.23192,3.21109,3.19003,3.16879,3.14742,3.1259,3.10413,3.08215,3.05997,3.03761,3.01507,2.99247,2.96992,2.9476,2.92566,2.90415,2.88309,2.86247,2.84225,2.82254,2.80343,2.78495,2.76714,2.74992,2.73321:6.3
2.85587,2.85753,2.85919,2.86082,2.86244,2.86411,2.86592,2.86788,2.87002,2.87241,2.87496,2.87767,2.88059,2.88374,2.88713,2.8908,2.89478,2.89911,2.90382,2.90888,2.91422,2.9197,2.92521,2.9307,2.93615,2.94158,2.94703,2.95264,2.95845,2.96444,2.97058,2.97686,2.98338,2.99041,2.99831,3.00762,3.0191,3.03269,3.04836,3.06597,3.08528,3.10601,3.12791,3.15096,3.1754,3.20168,3.23053,3.26338,3.30089,3.34391,3.39289,3.44733,3.50542,3.56397,3.61887,3.66629,3.70409,3.73225,3.75245,3.76667,3.77679,3.78391,3.78854,3.79072,3.79046,3.78762,3.78222,3.7744,3.76431,3.75217,3.7382,3.7225,3.70539,3.68694,3.66737,3.64687,3.62557,3.60372,3.58146,3.55895,3.53612,3.51292,3.48934,3.46531,3.44081,3.41593,3.39083,3.36576,3.34095,3.31661,3.2928,3.26945,3.24661,3.22437,3.20278,3.18198,3.16196,3.1427,3.12415,3.10627:7.2
2.77761,2.77938,2.78124,2.78315,2.78513,2.7872,2.78945,2.79194,2.79459,2.7975,2.80069,2.80412,2.8077,2.81151,2.81557,2.81989,2.82446,2.82933,2.83456,2.84014,2.84596,2.85201,2.85819,2.86441,2.87062,2.87676,2.88298,2.88924,2.89559,2.90204,2.90862,2.91526,2.92193,2.92871,2.93588,2.94379,2.95281,2.96325,2.97503,2.98798,3.00194,3.0166,3.03174,3.0473,3.06344,3.08047,3.09898,3.11968,3.14383,3.17216,3.20524,3.24294,3.28394,3.32563,3.36451,3.39739,3.4224,3.43945,3.44992,3.4556,3.45803,3.4581,3.45644,3.45307,3.4479,3.44086,3.43188,3.42102,3.40846,3.39435,3.37883,3.36205,3.34414,3.32521,3.30534,3.28463,3.2633,3.24146,3.21931,3.19686,3.17414,3.15114,3.1278,3.10409,3.07997,3.05545,3.03061,3.00567,2.9809,2.95646,2.93241,2.90877,2.88551,2.86264,2.84028,2.81853,2.7975,2.77718,2.75747,2.73836:7.8
2.81969,2.82316,2.82656,2.82991,2.83325,2.8366,2.84002,2.8435,2.84706,2.85073,2.85451,2.85835,2.86223,2.86619,2.87029,2.87454,2.87888,2.88331,2.88792,2.89272,2.89762,2.9025,2.90726,2.91189,2.91637,2.92069,2.92487,2.92897,2.93313,2.93739,2.9417,2.94597,2.95022,2.95477,2.96003,2.96644,2.97426,2.98356,2.99437,3.00645,3.01949,3.03315,3.04723,3.06176,3.07708,3.09376,3.11261,3.13456,3.16047,3.19121,3.22725,3.26787,3.31087,3.35256,3.38907,3.41794,3.43881,3.45316,3.46293,3.46971,3.4745,3.47776,3.47964,3.47999,3.47861,3.47544,3.47049,3.46385,3.45566,3.44606,3.43518,3.42308,3.40986,3.3956,3.38041,3.36439,3.34772,3.33058,3.31304,3.29507,3.27668,3.25785,3.23855,3.2187,3.19825,3.17719,3.15576,3.13422,3.11282,3.09165,3.07068,3.04989,3.02929,3.00893,2.98897,2.9695,2.95048,2.93186,2.91354,2.89551:7.9
2.79397,2.79267,2.79146,2.79043,2.78959,2.78891,2.78839,2.78811,2.78817,2.78847,2.78904,2.78986,2.79093,2.7923,2.79396,2.79587,2.79804,2.80053,2.80337,2.80649,2.80989,2.81347,2.81713,2.82079,2.82442,2.82803,2.83167,2.83533,2.83918,2.84319,2.84733,2.85155,2.85583,2.86033,2.86531,2.87119,2.87833,2.8868,2.89644,2.90705,2.91831,2.92989,2.94156,2.95328,2.96527,2.97807,2.9925,3.00985,3.03083,3.05611,3.0859,3.11964,3.15567,3.1912,3.22292,3.24812,3.26558,3.27591,3.28058,3.28135,3.2795,3.2758,3.27057,3.26378,3.25535,3.24522,3.23334,3.21981,3.2048,3.18844,3.17091,3.15238,3.13295,3.11263,3.09154,3.06986,3.04776,3.02535,3.00275,2.98003,2.95713,2.93402,2.91064,2.88702,2.8631,2.83889,2.81448,2.79011,2.76601,2.74234,2.71919,2.69653,2.67432,2.6526,2.63145,2.61092,2.59104,2.57178,2.55302,2.53483:9.2
2.19633,2.19528,2.19424,2.19317,2.19215,2.19127,2.19059,2.19007,2.1898,2.1897,2.18974,2.19008,2.19069,2.19156,2.1927,2.19413,2.1959,2.198,2.20054,2.2034,2.20644,2.20952,2.21258,2.21557,2.21853,2.22156,2.22475,2.22821,2.23201,2.2362,2.24076,2.24564,2.25084,2.25656,2.26316,2.27102,2.28086,2.29255,2.30605,2.32108,2.33726,2.35433,2.37214,2.39071,2.41036,2.43166,2.45535,2.48281,2.5146,2.5515,2.59372,2.64064,2.69032,2.73959,2.78477,2.82275,2.85204,2.87304,2.8875,2.89723,2.90381,2.90813,2.91061,2.91119,2.90981,2.90636,2.90085,2.8934,2.88418,2.8734,2.86128,2.84791,2.83342,2.81794,2.80157,2.78452,2.76687,2.74885,2.73058,2.71211,2.69342,2.67446,2.65516,2.63549,2.61544,2.59505,2.57451,2.55399,2.53367,2.51377,2.49432,2.47531,2.45676,2.43873,2.42121,2.40428,2.38792,2.37223,2.3571,2.34251:9.3
3.32573,3.33389,3.3419,3.34985,3.35772,3.36558,3.37354,3.3816,3.38977,3.39803,3.40629,3.41468,3.42324,3.43193,3.44075,3.44976,3.45896,3.4684,3.47809,3.48809,3.4983,3.50863,3.51892,3.52904,3.53901,3.54892,3.55875,3.56866,3.57865,3.58881,3.59908,3.60939,3.61978,3.63044,3.64175,3.65407,3.66804,3.68364,3.70074,3.71898,3.73796,3.75737,3.77704,3.79696,3.81752,3.83931,3.86328,3.89102,3.92322,3.96061,4.00347,4.05122,4.10187,4.15209,4.19801,4.23641,4.26568,4.28637,4.30043,4.30979,4.3162,4.32042,4.32276,4.32326,4.32191,4.3184,4.31276,4.30518,4.29589,4.28515,4.27302,4.25954,4.24506,4.22968,4.21343,4.19645,4.17876,4.16097,4.14301,4.12489,4.10643,4.08769,4.06863,4.04917,4.02927,4.00894,3.98831,3.9676,3.94711,3.927,3.90727,3.88788,3.86877,3.84997,3.83162,3.81367,3.79624,3.77928,3.7626,3.74616:10.2
2.8406,2.84137,2.84205,2.84273,2.84348,2.84427,2.84515,2.84627,2.84753,2.8491,2.85088,2.85288,2.85512,2.85765,2.86051,2.86374,2.86729,2.87131,2.87579,2.8806,2.88569,2.8909,2.89605,2.90106,2.90594,2.91077,2.91586,2.92137,2.92742,2.93408,2.94127,2.9488,2.95662,2.9649,2.97398,2.98445,2.99694,3.01147,3.02779,3.04555,3.06418,3.08314,3.10216,3.12133,3.14114,3.16245,3.18648,3.21489,3.24854,3.28826,3.33443,3.38652,3.44265,3.4995,3.55289,3.59899,3.63555,3.66255,3.68176,3.6951,3.70443,3.71093,3.7151,3.71699,3.71649,3.71351,3.70803,3.70019,3.69023,3.67835,3.66474,3.6495,3.6329,3.6151,3.59621,3.57638,3.55576,3.53461,3.51313,3.4914,3.46944,3.44714,3.4244,3.40116,3.37743,3.35323,3.32868,3.30408,3.27973,3.25586,3.2326,3.20993,3.1878,3.16618,3.14505,3.12454,3.10466,3.08536,3.06658,3.04829:12.5
2.40439,2.40103,2.3978,2.39473,2.39185,2.38919,2.38685,2.38486,2.38324,2.38199,2.3811,2.3806,2.38055,2.38104,2.3821,2.38371,2.38583,2.38847,2.39175,2.39558,2.39978,2.40402,2.40804,2.41179,2.41534,2.41883,2.42255,2.42687,2.43215,2.43851,2.44567,2.45309,2.46056,2.46837,2.47736,2.48826,2.50143,2.51684,2.53412,2.55253,2.57115,2.58906,2.60587,2.62187,2.63818,2.65641,2.67825,2.70522,2.73843,2.7788,2.8267,2.88101,2.93884,2.99554,3.04616,3.08755,3.11899,3.14215,3.1594,3.17266,3.18321,3.19173,3.19833,3.20289,3.20521,3.20525,3.20298,3.19853,3.19204,3.1837,3.17368,3.16205,3.14897,3.1345,3.11875,3.10189,3.08411,3.06564,3.04666,3.0272,3.00723,2.98673,2.96565,2.94381,2.92099,2.89719,2.87274,2.84812,2.82384,2.80012,2.77692,2.75416,2.73179,2.70992,2.68864,2.66795,2.64772,2.62778,2.60808,2.5888:13.5
2.53798,2.53468,2.53148,2.5284,2.52551,2.52291,2.52062,2.51868,2.5171,2.51592,2.51514,2.51476,2.51484,2.51544,2.51664,2.51844,2.52079,2.52371,2.52726,2.53142,2.53596,2.5405,2.5448,2.54874,2.55246,2.5562,2.56023,2.5649,2.57056,2.57731,2.58492,2.59283,2.60078,2.60906,2.61847,2.62985,2.64359,2.65964,2.67761,2.69671,2.71602,2.7346,2.752,2.76857,2.7855,2.80448,2.8273,2.85555,2.89039,2.93277,2.98309,3.04014,3.10087,3.16033,3.21326,3.25626,3.28872,3.31245,3.33002,3.3435,3.35419,3.36278,3.36941,3.37399,3.37626,3.37611,3.37358,3.36883,3.362,3.35327,3.34279,3.33068,3.31711,3.30212,3.28584,3.26839,3.24999,3.23093,3.21136,3.19136,3.17086,3.14979,3.12808,3.10555,3.08199,3.0574,3.03212,3.00669,2.98154,2.95696,2.93294,2.90936,2.88616,2.86341,2.84126,2.81971,2.79865,2.77788,2.75736,2.73725:13.5
2.23584,2.23529,2.23474,2.23419,2.2337,2.23332,2.2331,2.23305,2.23318,2.23349,2.23402,2.23477,2.23573,2.23699,2.23857,2.24048,2.2427,2.24528,2.24825,2.25162,2.25525,2.25897,2.26257,2.26602,2.26934,2.27269,2.27619,2.2801,2.28461,2.28977,2.29539,2.30116,2.30691,2.31287,2.31961,2.32764,2.33721,2.3483,2.36062,2.37369,2.38698,2.3999,2.41223,2.42419,2.43651,2.45026,2.46651,2.48632,2.51049,2.5398,2.57465,2.61433,2.65686,2.69902,2.73721,2.7689,2.7932,2.81093,2.82371,2.83298,2.83977,2.84469,2.84794,2.84948,2.84918,2.84698,2.84289,2.83704,2.82957,2.82067,2.8105,2.79919,2.78683,2.77355,2.75943,2.74459,2.72923,2.71357,2.69774,2.68174,2.66552,2.64907,2.63232,2.61517,2.59749,2.5793,2.56078,2.54232,2.52419,2.50659,2.48945,2.47271,2.45632,2.44033,2.42478,2.4097,2.39503,2.38063,2.36647,2.35262:14.6
2.23584,2.23529,2.23474,2.23419,2.2337,2.23332,2.2331,2.23305,2.23318,2.23349,2.23402,2.23477,2.23573,2.23699,2.23857,2.24048,2.2427,2.24528,2.24825,2.25162,2.25525,2.25897,2.26257,2.26602,2.26934,2.27269,2.27619,2.2801,2.28461,2.28977,2.29539,2.30116,2.30691,2.31287,2.31961,2.32764,2.33721,2.3483,2.36062,2.37369,2.38698,2.3999,2.41223,2.42419,2.43651,2.45026,2.46651,2.48632,2.51049,2.5398,2.57465,2.61433,2.65686,2.69902,2.73721,2.7689,2.7932,2.81093,2.82371,2.83298,2.83977,2.84469,2.84794,2.84948,2.84918,2.84698,2.84289,2.83704,2.82957,2.82067,2.8105,2.79919,2.78683,2.77355,2.75943,2.74459,2.72923,2.71357,2.69774,2.68174,2.66552,2.64907,2.63232,2.61517,2.59749,2.5793,2.56078,2.54232,2.52419,2.50659,2.48945,2.47271,2.45632,2.44033,2.42478,2.4097,2.39503,2.38063,2.36647,2.35262:14.6
2.78993,2.79053,2.79122,2.79207,2.79308,2.79427,2.79571,2.79745,2.79947,2.80187,2.80462,2.8077,2.81108,2.81481,2.81898,2.82357,2.8286,2.83407,2.84,2.84631,2.85291,2.85961,2.86617,2.8725,2.87857,2.88449,2.8906,2.89713,2.90419,2.91183,2.91997,2.92845,2.93712,2.94603,2.9555,2.96615,2.97864,2.99285,3.00847,3.02501,3.04173,3.05797,3.0734,3.08814,3.10291,3.11883,3.13722,3.16006,3.18831,3.22285,3.26398,3.31102,3.36188,3.41304,3.45995,3.49857,3.52695,3.54556,3.55658,3.56234,3.56468,3.56477,3.56278,3.55884,3.55287,3.54469,3.53421,3.52165,3.50732,3.4914,3.47395,3.45517,3.43527,3.41426,3.39238,3.36978,3.34659,3.32305,3.2993,3.27545,3.25141,3.22711,3.20246,3.17736,3.15174,3.12556,3.099,3.07236,3.04602,3.02022,2.9951,2.97062,2.94668,2.92319,2.90023,2.87783,2.85601,2.83468,2.81378,2.79328:16.3
2.58707,2.58646,2.58589,2.58536,2.58491,2.58465,2.58467,2.58497,2.5856,2.58668,2.58812,2.58993,2.59224,2.5951,2.59852,2.60252,2.60704,2.61221,2.61796,2.62423,2.63075,2.63728,2.64359,2.64956,2.65527,2.66102,2.66733,2.67463,2.68328,2.69332,2.70459,2.71671,2.7294,2.74264,2.75679,2.77258,2.7908,2.81129,2.83343,2.8564,2.87926,2.90117,2.92173,2.94115,2.96043,2.98107,3.005,3.03463,3.07095,3.11493,3.16676,3.22561,3.28909,3.35308,3.41255,3.46303,3.50215,3.53014,3.54926,3.56216,3.57085,3.57669,3.58015,3.58117,3.57969,3.57565,3.56903,3.55993,3.54863,3.53541,3.52047,3.50405,3.48625,3.46726,3.44725,3.42631,3.40461,3.38239,3.35985,3.33712,3.31418,3.29087,3.26722,3.24303,3.21815,3.19266,3.16675,3.14074,3.11508,3.09011,3.06592,3.04249,3.01967,2.99747,2.97577,2.95454,2.93377,2.91341,2.89335,2.87367:18.6
2.63036,2.63168,2.63299,2.63434,2.63579,2.63742,2.63928,2.6414,2.64381,2.64651,2.64949,2.65274,2.65637,2.66044,2.66501,2.67007,2.67562,2.68169,2.6884,2.69563,2.70313,2.71049,2.71741,2.72379,2.72986,2.73589,2.74229,2.74944,2.75774,2.76724,2.77763,2.78821,2.79856,2.80889,2.82,2.83272,2.84748,2.86412,2.88207,2.90034,2.91775,2.93326,2.94643,2.95776,2.96871,2.98128,2.9975,3.0191,3.04723,3.08277,3.12607,3.17597,3.22966,3.28237,3.32901,3.36627,3.39339,3.41215,3.42499,3.43403,3.44056,3.44526,3.44834,3.44963,3.44885,3.44585,3.44077,3.43386,3.42522,3.41508,3.40356,3.39085,3.37706,3.36222,3.34644,3.32982,3.3126,3.29508,3.27741,3.25962,3.24159,3.22324,3.20445,3.18502,3.16459,3.14312,3.12092,3.09855,3.07659,3.05532,3.03469,3.01443,2.9944,2.9746,2.95515,2.93608,2.91725,2.89843,2.87951,2.86072:20.9
3.64692,3.65042,3.6539,3.65758,3.66153,3.66578,3.67033,3.67517,3.68034,3.68619,3.69235,3.69895,3.70601,3.71356,3.72165,3.73032,3.73956,3.74949,3.7601,3.77138,3.78321,3.79533,3.80742,3.81924,3.83075,3.84213,3.85375,3.8661,3.87933,3.89359,3.90865,3.9241,3.93965,3.95525,3.97123,3.98844,4.00762,4.02863,4.05082,4.07309,4.09432,4.11354,4.13023,4.14458,4.15764,4.17137,4.18797,4.21012,4.2391,4.2757,4.32026,4.37196,4.42824,4.48476,4.5364,4.57889,4.61021,4.63085,4.64278,4.64843,4.6503,4.64959,4.64662,4.64112,4.63337,4.62295,4.60994,4.59481,4.57781,4.55904,4.53846,4.51611,4.49293,4.46861,4.44343,4.41718,4.39033,4.36349,4.33659,4.30968,4.28268,4.25545,4.22778,4.19941,4.17028,4.14045,4.11009,4.07956,4.04938,4.01995,3.99136,3.96352,3.93634,3.90966,3.88345,3.85755,3.83201,3.80681,3.78174,3.75681:21.2
2.99401,2.99294,2.99199,2.99126,2.99086,2.99096,2.99165,2.99304,2.99515,2.99805,3.00176,3.00631,3.01193,3.01878,3.027,3.03652,3.04723,3.05915,3.07239,3.08678,3.10167,3.11607,3.12925,3.14111,3.15221,3.16341,3.17577,3.19041,3.20843,3.23004,3.25447,3.28,3.30527,3.33036,3.35669,3.38599,3.41909,3.4555,3.4938,3.53179,3.56687,3.59661,3.62011,3.63848,3.65504,3.67418,3.69996,3.73578,3.78355,3.84462,3.9195,4.00617,4.1002,4.19386,4.27825,4.34717,4.39833,4.43464,4.4605,4.47941,4.49339,4.50402,4.51175,4.51647,4.51758,4.51482,4.50846,4.49895,4.48644,4.47116,4.45336,4.43359,4.41196,4.38861,4.36343,4.3366,4.30863,4.27987,4.25083,4.22158,4.1919,4.1616,4.13054,4.09836,4.06445,4.02869,3.99158,3.95423,3.91767,3.88259,3.84878,3.81592,3.78372,3.75221,3.72135,3.69094,3.66061,3.62989,3.59881,3.5679:25.1
3.42686,3.43133,3.43585,3.44046,3.4453,3.45056,3.45637,3.46281,3.46987,3.47758,3.48604,3.49529,3.5055,3.51687,3.52958,3.54355,3.55867,3.57493,3.59255,3.61142,3.63093,3.65004,3.66789,3.68421,3.69953,3.71469,3.73088,3.74937,3.77138,3.79725,3.82615,3.85596,3.88507,3.91338,3.9426,3.9747,4.01044,4.0492,4.08937,4.1284,4.1633,4.19105,4.21055,4.22307,4.2326,4.24429,4.26313,4.2928,4.33519,4.39144,4.46179,4.54397,4.6334,4.72254,4.80315,4.86928,4.91971,4.95659,4.98427,5.00585,5.02337,5.03841,5.04989,5.0582,5.06311,5.06446,5.06227,5.05754,5.05046,5.04066,5.02798,5.0126,4.99518,4.97637,4.95539,4.93266,4.90842,4.88342,4.85861,4.83316,4.80645,4.77886,4.75032,4.72062,4.68847,4.65396,4.61771,4.58114,4.54499,4.51051,4.47691,4.44411,4.4118,4.37996,4.34862,4.31738,4.28591,4.25358,4.22046,4.18721:26.5
2.67358,2.67434,2.67519,2.6761,2.67712,2.67835,2.67985,2.68166,2.68387,2.68649,2.68953,2.693,2.69698,2.70155,2.70682,2.71286,2.71963,2.72727,2.73573,2.7448,2.75424,2.76361,2.7725,2.78072,2.78843,2.79605,2.80442,2.81417,2.82571,2.83904,2.85383,2.86946,2.88526,2.90096,2.91697,2.93407,2.95314,2.97379,2.99519,3.0161,3.03507,3.05087,3.06296,3.07183,3.07902,3.0869,3.09809,3.11537,3.13987,3.17231,3.21287,3.26075,3.31378,3.36849,3.42059,3.46606,3.50251,3.52969,3.54909,3.56259,3.57202,3.57867,3.58296,3.58507,3.58488,3.58227,3.57725,3.56999,3.56077,3.54985,3.53734,3.52347,3.50834,3.49221,3.47504,3.45706,3.43851,3.41953,3.4005,3.38145,3.36239,3.34316,3.32355,3.30336,3.28234,3.26037,3.23765,3.21466,3.19199,3.17005,3.14903,3.12878,3.10904,3.08964,3.07051,3.0516,3.03275,3.0138,2.99462,2.97534:27.8
2.73924,2.74018,2.74127,2.74251,2.74391,2.74558,2.74762,2.75007,2.75289,2.75622,2.75992,2.76415,2.76893,2.77435,2.78048,2.78727,2.79478,2.80309,2.81221,2.82203,2.83223,2.84241,2.85211,2.86111,2.86953,2.8778,2.88657,2.89653,2.9081,2.92144,2.93623,2.9518,2.96749,2.98305,2.99875,3.01546,3.03391,3.05382,3.07422,3.09379,3.11102,3.12465,3.13416,3.14004,3.14404,3.14857,3.15629,3.17018,3.19139,3.22069,3.25817,3.30284,3.35239,3.40286,3.44957,3.48842,3.51727,3.53676,3.54895,3.55599,3.55967,3.56117,3.56091,3.55872,3.55451,3.54823,3.53989,3.52958,3.51748,3.50394,3.48913,3.47321,3.45626,3.43843,3.41978,3.40044,3.38061,3.36062,3.34063,3.32072,3.30083,3.28066,3.26007,3.23884,3.21683,3.19391,3.17022,3.14621,3.12244,3.09934,3.07716,3.05579,3.03495,3.01437,2.99393,2.97357,2.95318,2.93267,2.91191,2.89096:29.7
3.48451,3.49135,3.49814,3.50489,3.51172,3.51873,3.5259,3.53318,3.54071,3.54849,3.55644,3.56464,3.57317,3.58208,3.59138,3.60112,3.6112,3.62184,3.63309,3.64489,3.65725,3.66984,3.6823,3.69441,3.70617,3.7178,3.72966,3.74219,3.75576,3.77055,3.7863,3.80241,3.81833,3.83392,3.84971,3.86662,3.88536,3.90544,3.92594,3.94548,3.96255,3.97579,3.98447,3.98901,3.99094,3.99268,3.99703,4.00691,4.0233,4.04678,4.07732,4.11388,4.15431,4.19534,4.23334,4.26535,4.28997,4.30757,4.31939,4.32707,4.3322,4.33546,4.33731,4.33745,4.33589,4.3326,4.32758,4.32093,4.31281,4.30343,4.29299,4.28149,4.26907,4.2559,4.24204,4.22749,4.21255,4.19749,4.18245,4.16748,4.15254,4.13745,4.12198,4.10575,4.08849,4.07008,4.05071,4.03094,4.01145,3.99255,3.97422,3.95634,3.93865,3.92098,3.90326,3.88547,3.86741,3.84885,3.82957,3.80973:30.4
3.32289,3.32988,3.33671,3.34351,3.35041,3.35752,3.36478,3.37218,3.37992,3.38802,3.39639,3.405,3.41396,3.42346,3.4336,3.44424,3.4552,3.46674,3.47931,3.49255,3.50631,3.52039,3.53451,3.54839,3.56181,3.57481,3.58768,3.60141,3.61664,3.63352,3.65187,3.67102,3.69025,3.70922,3.72814,3.74779,3.76919,3.79253,3.81681,3.84067,3.86255,3.88085,3.89436,3.90296,3.90789,3.91149,3.91676,3.92679,3.94425,3.96963,4.00317,4.04437,4.09133,4.14051,4.1875,4.22847,4.26129,4.28582,4.30327,4.31539,4.32391,4.33007,4.33461,4.33767,4.33869,4.33761,4.33448,4.32962,4.32324,4.31528,4.30588,4.2954,4.28411,4.27209,4.25902,4.24516,4.23058,4.21576,4.20114,4.18673,4.1721,4.15727,4.14239,4.12713,4.11084,4.09316,4.0742,4.05465,4.03541,4.01694,3.99917,3.98182,3.96473,3.94794,3.93132,3.91463,3.89764,3.88028,3.86239,3.84393:31.5
3.09812,3.10292,3.10775,3.11264,3.11762,3.12276,3.12814,3.13385,3.1399,3.14639,3.1532,3.16037,3.16801,3.17616,3.1849,3.19435,3.20441,3.21504,3.22648,3.23877,3.25191,3.26547,3.27903,3.29222,3.30489,3.31721,3.32954,3.34262,3.35729,3.374,3.39256,3.41218,3.43186,3.45109,3.47012,3.48988,3.51132,3.53474,3.559,3.58251,3.60334,3.61944,3.62929,3.63273,3.6313,3.62793,3.62616,3.62919,3.64,3.65937,3.68749,3.72365,3.76584,3.81063,3.85387,3.89173,3.92184,3.94387,3.95919,3.96957,3.9767,3.98149,3.98459,3.98611,3.98588,3.98373,3.9797,3.97396,3.96665,3.95793,3.94795,3.93688,3.92487,3.912,3.89835,3.88399,3.86889,3.8534,3.83797,3.82281,3.80771,3.79253,3.77706,3.76104,3.74391,3.72527,3.7052,3.68429,3.66345,3.6433,3.62404,3.6055,3.58735,3.56935,3.55131,3.53315,3.51464,3.49539,3.47518,3.45412:35.2
3.49423,3.50312,3.51194,3.52075,3.52962,3.53865,3.54785,3.5572,3.56678,3.57669,3.58676,3.59708,3.60782,3.61903,3.63075,3.643,3.65571,3.669,3.68287,3.69735,3.71238,3.72757,3.74256,3.75714,3.77129,3.78511,3.79918,3.81416,3.83068,3.84889,3.86839,3.8885,3.90855,3.92817,3.94781,3.96839,3.99073,4.01439,4.03817,4.0604,4.07923,4.09297,4.10073,4.10284,4.10113,4.09862,4.0986,4.10444,4.11722,4.13739,4.16458,4.19784,4.2351,4.27335,4.30928,4.34014,4.36454,4.38274,4.39601,4.40592,4.41375,4.42,4.42489,4.42827,4.43025,4.43071,4.42959,4.42706,4.42328,4.4183,4.41224,4.40525,4.39748,4.38897,4.37969,4.36951,4.3592,4.34845,4.33765,4.3267,4.31571,4.30474,4.29333,4.28121,4.26795,4.25336,4.23764,4.22126,4.20497,4.18935,4.17443,4.15995,4.14564,4.1314,4.1171,4.10245,4.08714,4.07115,4.0542,4.03646:35.8
2.92851,2.93017,2.93187,2.9337,2.93578,2.9382,2.941,2.94417,2.94783,2.95204,2.95678,2.96201,2.96788,2.97455,2.98211,2.99057,2.99989,3.01023,3.02158,3.03401,3.0472,3.06066,3.07379,3.0862,3.09795,3.10947,3.12166,3.1356,3.15201,3.1711,3.19236,3.21471,3.23696,3.25848,3.27975,3.30176,3.3255,3.3502,3.37423,3.39535,3.41109,3.41944,3.41959,3.41241,3.40057,3.38797,3.37864,3.37668,3.38345,3.39964,3.425,3.45817,3.49658,3.53652,3.57394,3.60543,3.62923,3.64559,3.65602,3.6623,3.66588,3.66774,3.66813,3.6671,3.66444,3.66012,3.65415,3.64666,3.6379,3.62811,3.61744,3.60606,3.59413,3.58168,3.56862,3.55514,3.54135,3.52768,3.51436,3.50147,3.4889,3.47626,3.46324,3.44945,3.43448,3.41811,3.40045,3.38217,3.36412,3.34692,3.33079,3.31543,3.30039,3.28536,3.27006,3.25427,3.23769,3.21995,3.20092,3.18088:43.8
3.9358,3.94266,3.94968,3.95693,3.96451,3.97251,3.981,3.99008,3.99987,4.01044,4.02156,4.03351,4.04644,4.06052,4.07584,4.09238,4.11019,4.12948,4.15043,4.173,4.19651,4.22021,4.24325,4.26499,4.28549,4.30555,4.32665,4.35083,4.3788,4.41103,4.44659,4.48381,4.52073,4.55599,4.58994,4.62395,4.6598,4.6968,4.732,4.76194,4.7825,4.7909,4.78667,4.77176,4.7503,4.72829,4.71132,4.70505,4.711,4.72992,4.76139,4.80365,4.85314,4.90452,4.95233,4.99246,5.02287,5.04447,5.05891,5.0676,5.07368,5.07694,5.07865,5.07842,5.07662,5.07325,5.06758,5.0596,5.05017,5.04002,5.02925,5.01748,5.00478,4.99153,4.97773,4.96294,4.94791,4.93285,4.91865,4.90519,4.89214,4.87931,4.86574,4.85063,4.8335,4.8144,4.79382,4.77219,4.75046,4.72986,4.71065,4.69237,4.67427,4.65572,4.63634,4.61585,4.59375,4.56988,4.54406,4.51644:48.2
4.23728,4.24721,4.25737,4.26773,4.27847,4.28968,4.30133,4.31331,4.32587,4.33927,4.3533,4.36811,4.38382,4.40059,4.41851,4.43762,4.45793,4.47986,4.50321,4.52804,4.55394,4.58015,4.60577,4.63006,4.65297,4.67547,4.69899,4.72511,4.75483,4.78872,4.82591,4.86466,4.90302,4.93974,4.97546,5.0117,5.04878,5.08553,5.12114,5.15256,5.17583,5.18716,5.18529,5.17251,5.15324,5.13239,5.11692,5.11116,5.11696,5.13511,5.16545,5.20561,5.25166,5.29921,5.34405,5.3824,5.41183,5.43269,5.44697,5.45467,5.45922,5.46171,5.46438,5.46638,5.46712,5.46541,5.46029,5.4526,5.44467,5.43705,5.42766,5.41663,5.40614,5.39565,5.38425,5.36992,5.35611,5.34274,5.3304,5.31825,5.3069,5.29543,5.28391,5.27165,5.25717,5.23997,5.22008,5.19951,5.17987,5.16148,5.14462,5.12819,5.11187,5.09518,5.0776,5.05895,5.03826,5.01571,4.99107,4.96543:48.5
2.84077,2.84138,2.84216,2.84321,2.84468,2.84661,2.84904,2.85212,2.85591,2.86056,2.86588,2.87203,2.87921,2.88763,2.89747,2.90885,2.92167,2.936,2.95182,2.96888,2.98659,3.00404,3.02031,3.03492,3.0481,3.06084,3.07483,3.0916,3.11203,3.13644,3.16418,3.19372,3.22322,3.25153,3.27889,3.30659,3.33604,3.36656,3.39592,3.42106,3.43855,3.4455,3.44067,3.42539,3.40351,3.38041,3.3615,3.35191,3.35309,3.36571,3.3894,3.42274,3.46295,3.506,3.54719,3.58248,3.60955,3.62863,3.64131,3.64952,3.65493,3.65851,3.66065,3.66101,3.65974,3.65677,3.65216,3.64604,3.6387,3.63043,3.62127,3.6113,3.60073,3.58971,3.57831,3.56639,3.55414,3.54192,3.53018,3.51907,3.50848,3.49794,3.48699,3.47509,3.46163,3.44619,3.4289,3.41062,3.39253,3.37554,3.35989,3.34527,3.33101,3.31659,3.30169,3.28603,3.26919,3.25047,3.22976,3.20761:49.1
2.86657,2.87122,2.87584,2.88043,2.88497,2.88953,2.89418,2.89895,2.90382,2.90877,2.9138,2.91894,2.9242,2.92955,2.93504,2.94068,2.94646,2.95238,2.95846,2.96471,2.97112,2.97756,2.98394,2.99019,2.99631,3.00232,3.00829,3.01423,3.02023,3.02633,3.0325,3.03864,3.04474,3.05107,3.05803,3.06597,3.07511,3.08552,3.0972,3.10992,3.1234,3.13736,3.15155,3.16599,3.18099,3.19713,3.21511,3.23578,3.25991,3.28836,3.32167,3.35914,3.39883,3.43732,3.47098,3.49739,3.51608,3.52838,3.53617,3.54102,3.54382,3.5451,3.54507,3.54355,3.54042,3.5356,3.52913,3.52115,3.51172,3.50104,3.48924,3.47644,3.46274,3.44825,3.43303,3.41722,3.40095,3.38435,3.36755,3.35051,3.33325,3.31575,3.298,3.27987,3.26133,3.24241,3.2233,3.20425,3.18543,3.16693,3.14873,3.13084,3.11322,3.09593,3.07906,3.06268,3.04679,3.03128,3.01609,3.0012:8.2
2.99082,2.99619,3.00148,3.00675,3.01198,3.01724,3.02254,3.02793,3.03339,3.03897,3.04465,3.05042,3.05627,3.06224,3.06836,3.07465,3.08106,3.08763,3.0944,3.10141,3.10855,3.1157,3.12275,3.12966,3.13644,3.14309,3.14966,3.15626,3.16304,3.17004,3.17717,3.18424,3.19125,3.19845,3.20625,3.21507,3.22514,3.23653,3.2492,3.26277,3.27688,3.29113,3.3053,3.31946,3.33401,3.34967,3.36733,3.38798,3.41243,3.44152,3.47573,3.51441,3.55552,3.59557,3.63075,3.65851,3.67839,3.6917,3.70039,3.70604,3.70955,3.71159,3.71219,3.71138,3.70887,3.7046,3.69864,3.69109,3.68212,3.67186,3.66046,3.64807,3.63476,3.62052,3.60553,3.58991,3.57383,3.55746,3.54088,3.52407,3.507,3.48968,3.47206,3.45404,3.43551,3.41652,3.39729,3.37803,3.35902,3.34034,3.322,3.30393,3.28607,3.26853,3.25135,3.23463,3.21832,3.20231,3.18656,3.17105:11.0
2.15499,2.1545,2.15393,2.15342,2.153,2.15263,2.1523,2.15209,2.15214,2.15232,2.15265,2.15305,2.15356,2.15424,2.15514,2.15623,2.15748,2.1589,2.16058,2.16251,2.16471,2.16703,2.16941,2.17181,2.17418,2.17661,2.179,2.18122,2.18325,2.18511,2.1869,2.18885,2.19117,2.19409,2.19797,2.20315,2.21031,2.2195,2.23088,2.24446,2.26009,2.27765,2.2971,2.31839,2.34155,2.36663,2.39397,2.4245,2.4589,2.49783,2.5416,2.5894,2.63917,2.68768,2.73133,2.76738,2.79485,2.81454,2.82838,2.83813,2.84525,2.85047,2.85403,2.85586,2.85589,2.85389,2.84985,2.84396,2.83637,2.82722,2.81669,2.80476,2.79161,2.77734,2.76216,2.74616,2.72948,2.71228,2.69452,2.67636,2.65782,2.63887,2.61947,2.59956,2.57921,2.55853,2.53763,2.51673,2.49598,2.47541,2.45506,2.43495,2.41518,2.39586,2.37715,2.35907,2.34173,2.32514,2.30934,2.29418:0.9
2.24852,2.2489,2.24928,2.24972,2.25024,2.25086,2.25166,2.2526,2.25367,2.25498,2.25642,2.2581,2.25995,2.26195,2.26411,2.26644,2.26896,2.2718,2.2749,2.2782,2.2817,2.28531,2.28902,2.29283,2.29663,2.30034,2.30396,2.3075,2.31105,2.31455,2.31802,2.32149,2.32506,2.32896,2.33351,2.33911,2.34617,2.35473,2.36477,2.37632,2.38925,2.4034,2.4186,2.43478,2.45196,2.47044,2.49066,2.51366,2.53999,2.57033,2.60496,2.64345,2.68425,2.72462,2.76124,2.79127,2.81329,2.82783,2.83658,2.84126,2.84333,2.84354,2.84222,2.83926,2.83461,2.8282,2.82,2.81011,2.79866,2.78576,2.7716,2.75631,2.73993,2.7226,2.70446,2.68562,2.66618,2.6463,2.62611,2.60567,2.58494,2.56389,2.54245,2.52062,2.49843,2.47597,2.45331,2.43063,2.40811,2.38586,2.36396,2.34239,2.32121,2.30043,2.28018,2.26058,2.24171,2.22352,2.20602,2.18913:3.6
2.62659,2.62827,2.62998,2.63168,2.63345,2.63534,2.63737,2.63952,2.6418,2.6442,2.64677,2.64948,2.65235,2.65533,2.65844,2.66175,2.66513,2.66875,2.67258,2.67661,2.68079,2.68509,2.68942,2.6937,2.69794,2.70225,2.70643,2.71056,2.7146,2.71856,2.72248,2.72643,2.73048,2.7348,2.73964,2.7453,2.75226,2.76052,2.77011,2.78095,2.79299,2.80607,2.82005,2.83493,2.85085,2.868,2.88677,2.9081,2.93256,2.96084,2.99322,3.02912,3.0669,3.10391,3.13711,3.16402,3.18361,3.19642,3.20406,3.20806,3.20958,3.20941,3.20776,3.20459,3.19985,3.1934,3.18525,3.17549,3.16422,3.15161,3.13781,3.12289,3.10699,3.09014,3.07247,3.05412,3.03518,3.01587,2.99622,2.97632,2.95609,2.93553,2.91464,2.89338,2.87177,2.84986,2.82778,2.80567,2.78371,2.76202,2.74062,2.71949,2.69868,2.67828,2.65834,2.63897,2.62024,2.60216,2.58473,2.5678:3.9
3.13203,3.14117,3.15015,3.15899,3.16774,3.17642,3.18504,3.1936,3.20214,3.21066,3.21913,3.22759,3.23606,3.24454,3.25304,3.26157,3.27014,3.27879,3.2875,3.29634,3.3052,3.31408,3.32297,3.33181,3.34055,3.34926,3.35777,3.36619,3.37447,3.38264,3.39072,3.39872,3.40672,3.41491,3.4235,3.43277,3.44309,3.45456,3.46717,3.48094,3.49584,3.51181,3.52873,3.54649,3.56513,3.58482,3.60596,3.62921,3.65508,3.68411,3.71668,3.75254,3.79061,3.82891,3.86499,3.89659,3.92226,3.94198,3.95668,3.96754,3.97573,3.98199,3.98652,3.98942,3.99071,3.99027,3.98813,3.98433,3.97893,3.97211,3.96402,3.95479,3.9445,3.93332,3.92123,3.90845,3.89505,3.88129,3.86723,3.85287,3.83821,3.82326,3.80804,3.79254,3.77668,3.76055,3.74429,3.72799,3.71176,3.6957,3.67987,3.6643,3.64899,3.63392,3.61912,3.60474,3.59085,3.57745,3.56438,3.55159:4.0
2.48619,2.48602,2.48584,2.48568,2.48555,2.48553,2.48567,2.48595,2.48637,2.48701,2.48783,2.48883,2.49003,2.49141,2.49298,2.49478,2.49677,2.49909,2.50172,2.50455,2.5075,2.51052,2.51358,2.51666,2.5197,2.52273,2.5257,2.52878,2.53191,2.53517,2.53853,2.54198,2.54567,2.54984,2.55479,2.56092,2.56876,2.57837,2.5897,2.60269,2.61715,2.63293,2.64988,2.66795,2.68728,2.70823,2.73137,2.75777,2.78816,2.82323,2.86334,2.90784,2.95482,3.00115,3.04312,3.07769,3.10357,3.12141,3.13311,3.1406,3.14531,3.14814,3.14938,3.14893,3.14661,3.14239,3.13625,3.12827,3.11864,3.10753,3.09506,3.08136,3.06649,3.05058,3.0338,3.01626,2.99805,2.97942,2.96042,2.94111,2.92144,2.90141,2.88104,2.86026,2.83906,2.81753,2.79576,2.77396,2.75234,2.73102,2.71006,2.68948,2.66923,2.6494,2.63013,2.61151,2.5936,2.57636,2.55977,2.54383:5.1
2.34779,2.34836,2.34898,2.34967,2.35039,2.3512,2.3522,2.35343,2.35483,2.3564,2.35815,2.36006,2.36218,2.36449,2.36698,2.36967,2.37253,2.37571,2.37922,2.38295,2.38687,2.39093,2.39508,2.39926,2.40342,2.40756,2.41165,2.41562,2.41957,2.42356,2.42755,2.43156,2.43569,2.44015,2.44529,2.4515,2.45923,2.46859,2.47949,2.49187,2.50554,2.5203,2.53599,2.55256,2.57008,2.58889,2.60954,2.63312,2.66031,2.69178,2.72786,2.76801,2.81055,2.85264,2.89079,2.92198,2.94487,2.95995,2.96894,2.97371,2.97564,2.97567,2.97406,2.97078,2.96572,2.9588,2.94999,2.93943,2.92727,2.91365,2.89872,2.88256,2.86529,2.84711,2.8281,2.80837,2.7881,2.76742,2.74645,2.72521,2.70369,2.68186,2.6597,2.63717,2.61423,2.59096,2.56751,2.54407,2.52083,2.49791,2.47535,2.45316,2.43134,2.40996,2.38914,2.369,2.34959,2.3309,2.3128,2.29529:5.2
2.50688,2.50783,2.5088,2.50985,2.51101,2.51229,2.51369,2.51523,2.51692,2.51888,2.52103,2.52331,2.52576,2.52841,2.53122,2.53423,2.53752,2.54095,2.54465,2.54859,2.55274,2.55703,2.5614,2.56579,2.57016,2.57449,2.5788,2.5831,2.58734,2.59156,2.59575,2.59996,2.60428,2.60886,2.61396,2.61985,2.62702,2.63551,2.64524,2.65624,2.66831,2.68128,2.69503,2.7095,2.72479,2.74116,2.75911,2.77959,2.80313,2.83051,2.862,2.89712,2.93444,2.97142,3.00482,3.03191,3.05143,3.06386,3.07077,3.07371,3.07402,3.07252,3.06948,3.06492,3.05869,3.05075,3.04106,3.0297,3.01681,3.00253,2.98699,2.9703,2.95266,2.93406,2.91468,2.8946,2.87393,2.85285,2.83147,2.80986,2.78794,2.76571,2.74317,2.72026,2.69701,2.67351,2.64986,2.62621,2.60273,2.57953,2.55669,2.53422,2.51217,2.49056,2.46947,2.44895,2.42914,2.41002,2.39156,2.37374:5.2
2.57329,2.57469,2.57607,2.57752,2.57901,2.58059,2.58229,2.5841,2.58607,2.58821,2.59052,2.59298,2.59557,2.59828,2.60114,2.60422,2.60749,2.61106,2.61476,2.61866,2.62275,2.62698,2.63126,2.63551,2.63966,2.64366,2.64768,2.65166,2.65566,2.65962,2.66358,2.66758,2.67172,2.67622,2.68139,2.68757,2.6952,2.70434,2.71501,2.72708,2.74039,2.75468,2.76977,2.78568,2.80254,2.82079,2.84095,2.86413,2.89093,2.92208,2.9578,2.99751,3.03945,3.08073,3.11805,3.14868,3.17141,3.1869,3.19679,3.20273,3.20604,3.20751,3.20742,3.20577,3.20237,3.19716,3.19011,3.18134,3.17102,3.15925,3.14616,3.13187,3.11645,3.10009,3.08288,3.06495,3.04641,3.02738,3.00803,2.98837,2.96835,2.94801,2.92733,2.90623,2.88468,2.86277,2.84068,2.81855,2.79656,2.77481,2.75338,2.73226,2.71149,2.69111,2.67121,2.65191,2.63319,2.6151,2.59755,2.58054:5.6
2.50356,2.50343,2.50334,2.50327,2.50322,2.50325,2.50341,2.50374,2.50422,2.50488,2.50575,2.50681,2.50805,2.50947,2.51107,2.51286,2.51488,2.51722,2.51984,2.52265,2.52562,2.52869,2.53177,2.53479,2.53778,2.54079,2.54376,2.54676,2.54987,2.5531,2.55643,2.55988,2.56357,2.56768,2.57259,2.57873,2.58666,2.59634,2.60777,2.62087,2.63548,2.65139,2.66845,2.68663,2.70608,2.72716,2.7505,2.77724,2.80812,2.84385,2.88471,2.93003,2.97789,3.02505,3.06775,3.10292,3.1292,3.14741,3.15937,3.16707,3.17214,3.17525,3.17667,3.17639,3.17424,3.17018,3.16418,3.15635,3.14684,3.13577,3.1233,3.10955,3.09468,3.07881,3.06201,3.04442,3.0261,3.00731,2.98818,2.96872,2.94896,2.92879,2.90823,2.8872,2.86575,2.84396,2.82195,2.79991,2.77801,2.75636,2.73508,2.71416,2.69365,2.67354,2.65394,2.63497,2.61672,2.59916,2.58225,2.56593:5.6
2.59001,2.59226,2.59453,2.59682,2.59909,2.60136,2.60372,2.60621,2.60887,2.61164,2.61449,2.61741,2.62049,2.62371,2.62704,2.63052,2.63417,2.63796,2.64196,2.64617,2.65055,2.65501,2.65944,2.66382,2.66814,2.6724,2.67662,2.68074,2.68488,2.689,2.69313,2.6973,2.70157,2.70611,2.71125,2.71734,2.72482,2.73369,2.74398,2.75556,2.76827,2.7819,2.79631,2.8115,2.82761,2.84504,2.86435,2.88661,2.91241,2.94233,2.97661,3.01462,3.05466,3.09398,3.1295,3.15881,3.18095,3.19649,3.20714,3.21441,3.21946,3.22293,3.22495,3.2255,3.22442,3.22165,3.2172,3.21116,3.20361,3.19462,3.18431,3.17277,3.16014,3.14648,3.13186,3.11641,3.10024,3.08354,3.06635,3.04877,3.03075,3.0123,2.99335,2.97389,2.95393,2.93351,2.9128,2.89193,2.87111,2.85046,2.83004,2.80988,2.78995,2.77031,2.75108,2.73234,2.71415,2.69652,2.67942,2.66274:6.0
2.24077,2.24064,2.24046,2.24035,2.24029,2.24031,2.24045,2.24075,2.2412,2.24187,2.24274,2.24381,2.24508,2.24656,2.24824,2.25014,2.2523,2.25474,2.25752,2.26059,2.2639,2.26741,2.27096,2.2745,2.27804,2.28149,2.28501,2.28848,2.29211,2.29587,2.29977,2.3038,2.30799,2.31249,2.31766,2.32392,2.33163,2.34133,2.35283,2.36604,2.38071,2.3966,2.41346,2.43119,2.44994,2.47011,2.49224,2.51708,2.54601,2.57958,2.61839,2.66216,2.70935,2.75705,2.80156,2.83955,2.86915,2.8905,2.90518,2.91508,2.92187,2.92634,2.92908,2.93014,2.92938,2.92673,2.92215,2.9157,2.90755,2.89783,2.88671,2.87434,2.86082,2.84623,2.83066,2.81431,2.79729,2.77977,2.76189,2.74368,2.72513,2.70628,2.68706,2.66739,2.6473,2.62676,2.60581,2.58472,2.56375,2.54305,2.52269,2.50266,2.48295,2.46358,2.44466,2.42634,2.40867,2.39164,2.3752,2.3593:6.4
2.2863,2.28689,2.28745,2.288,2.28864,2.2894,2.29022,2.29114,2.29227,2.29358,2.29504,2.29669,2.29849,2.30044,2.30259,2.30498,2.30761,2.31047,2.31365,2.31709,2.3207,2.32442,2.32817,2.33185,2.33547,2.33904,2.34265,2.3463,2.35009,2.35395,2.35791,2.36202,2.36636,2.37116,2.37677,2.38359,2.39209,2.40235,2.4143,2.42779,2.4426,2.45849,2.47529,2.49301,2.51186,2.53232,2.55503,2.58117,2.61134,2.64615,2.6858,2.72962,2.77564,2.82077,2.86151,2.89507,2.92038,2.93819,2.95021,2.95837,2.96387,2.96754,2.96964,2.97012,2.96892,2.9659,2.961,2.95439,2.94621,2.93656,2.92568,2.91365,2.90054,2.88649,2.87157,2.85599,2.8398,2.82325,2.80637,2.78922,2.77176,2.75396,2.73582,2.7173,2.69838,2.67907,2.65953,2.63997,2.62056,2.60142,2.58261,2.56414,2.54602,2.52828,2.511,2.49429,2.47822,2.46271,2.44769,2.4332:6.4
2.90099,2.90568,2.91025,2.91483,2.91948,2.92425,2.92911,2.93398,2.93887,2.94408,2.94946,2.95501,2.96066,2.96637,2.97216,2.97821,2.98455,2.9911,2.99784,3.00477,3.01185,3.01908,3.02643,3.03376,3.04095,3.048,3.05491,3.06183,3.06883,3.07591,3.083,3.09007,3.09716,3.10458,3.11277,3.12213,3.13318,3.14592,3.1603,3.17624,3.19353,3.21197,3.23133,3.25149,3.27262,3.29505,3.31962,3.34764,3.37974,3.41677,3.45909,3.50629,3.55657,3.60674,3.65283,3.69138,3.72082,3.74124,3.7546,3.76314,3.76864,3.77193,3.77317,3.77267,3.7701,3.76541,3.75861,3.74982,3.73923,3.72698,3.7132,3.69809,3.68165,3.66417,3.64579,3.62656,3.60657,3.58613,3.56538,3.54425,3.52266,3.50072,3.47851,3.45586,3.43271,3.40911,3.38516,3.36108,3.33719,3.31369,3.2906,3.26783,3.24537,3.22328,3.20173,3.18083,3.16057,3.14097,3.12195,3.10338:6.4
2.67705,2.67872,2.68046,2.68219,2.68399,2.68588,2.68785,2.68994,2.69218,2.69465,2.6973,2.70006,2.70294,2.70598,2.7092,2.71262,2.71621,2.72009,2.72416,2.7285,2.73298,2.73755,2.74215,2.74673,2.75122,2.75567,2.76001,2.76439,2.76876,2.77316,2.77765,2.7822,2.78685,2.7918,2.79735,2.80389,2.81183,2.82127,2.83206,2.84415,2.8573,2.87135,2.88613,2.90159,2.91796,2.93562,2.95516,2.97778,3.00408,3.03476,3.06999,3.10921,3.15071,3.19165,3.22868,3.25905,3.28149,3.29654,3.3059,3.31124,3.31396,3.31483,3.31412,3.31178,3.30769,3.30176,3.29399,3.28448,3.27337,3.26085,3.247,3.23191,3.21572,3.19859,3.18059,3.16183,3.14249,3.12266,3.10252,3.08205,3.06127,3.04016,3.01867,2.99676,2.9744,2.95166,2.9287,2.9057,2.88284,2.86024,2.83797,2.81603,2.79442,2.7732,2.75249,2.7323,2.71273,2.69378,2.67536,2.65743:6.6
2.67705,2.67872,2.68046,2.68219,2.68399,2.68588,2.68785,2.68994,2.69218,2.69465,2.6973,2.70006,2.70294,2.70598,2.7092,2.71262,2.71621,2.72009,2.72416,2.7285,2.73298,2.73755,2.74215,2.74673,2.75122,2.75567,2.76001,2.76439,2.76876,2.77316,2.77765,2.7822,2.78685,2.7918,2.79735,2.80389,2.81183,2.82127,2.83206,2.84415,2.8573,2.87135,2.88613,2.90159,2.91796,2.93562,2.95516,2.97778,3.00408,3.03476,3.06999,3.10921,3.15071,3.19165,3.22868,3.25905,3.28149,3.29654,3.3059,3.31124,3.31396,3.31483,3.31412,3.31178,3.30769,3.30176,3.29399,3.28448,3.27337,3.26085,3.247,3.23191,3.21572,3.19859,3.18059,3.16183,3.14249,3.12266,3.10252,3.08205,3.06127,3.04016,3.01867,2.99676,2.9744,2.95166,2.9287,2.9057,2.88284,2.86024,2.83797,2.81603,2.79442,2.7732,2.75249,2.7323,2.71273,2.69378,2.67536,2.65743:6.6
2.82935,2.8312,2.83314,2.83512,2.83725,2.83954,2.84201,2.8447,2.84764,2.8508,2.85422,2.85787,2.86177,2.86588,2.87023,2.87484,2.87973,2.88498,2.89057,2.89642,2.90255,2.90883,2.91519,2.92158,2.92787,2.93408,2.94028,2.94643,2.95266,2.95893,2.96522,2.97156,2.978,2.98473,2.99207,3.00043,3.01036,3.02183,3.03487,3.04925,3.06472,3.08098,3.09779,3.11514,3.13323,3.15251,3.17367,3.19808,3.22645,3.25956,3.29776,3.34062,3.38633,3.43175,3.47301,3.50668,3.53109,3.54665,3.55548,3.55953,3.56041,3.55903,3.55581,3.5507,3.54353,3.53432,3.52311,3.50995,3.49495,3.47818,3.45995,3.44036,3.41953,3.39771,3.3749,3.35127,3.32692,3.30211,3.27706,3.25167,3.22599,3.19993,3.17346,3.14654,3.11913,3.09127,3.06317,3.03508,3.00721,2.9797,2.95259,2.92593,2.89975,2.87404,2.84898,2.82462,2.80101,2.77813,2.75595,2.73434:6.7
2.60265,2.60327,2.6039,2.60448,2.60511,2.60584,2.60667,2.60758,2.6087,2.61,2.61148,2.61312,2.61489,2.61681,2.61892,2.62123,2.62382,2.62673,2.62989,2.63329,2.63687,2.64051,2.64416,2.64775,2.65122,2.65471,2.65816,2.66169,2.66534,2.66914,2.67309,2.67716,2.68144,2.68615,2.69162,2.69826,2.7066,2.71673,2.72862,2.74206,2.75686,2.7728,2.78973,2.80764,2.82678,2.84752,2.87058,2.8972,2.92798,2.96365,3.00451,3.04996,3.0981,3.1458,3.18933,3.22559,3.25316,3.27262,3.2858,3.29461,3.30052,3.30456,3.30686,3.30745,3.30617,3.30291,3.29771,3.29065,3.28187,3.27156,3.25983,3.24676,3.2325,3.21729,3.20115,3.18416,3.16655,3.14842,3.1299,3.11107,3.09191,3.07238,3.05243,3.03203,3.0112,2.98998,2.96847,2.94688,2.92545,2.9043,2.88349,2.86303,2.84294,2.82324,2.804,2.78534,2.76731,2.74997,2.73318,2.71695:6.8
2.36149,2.36159,2.36169,2.36177,2.3619,2.36211,2.36246,2.36304,2.36375,2.36465,2.3657,2.36702,2.36854,2.37023,2.37213,2.37429,2.37676,2.37957,2.38267,2.38606,2.38962,2.39324,2.39688,2.40046,2.40394,2.40732,2.41068,2.41416,2.41777,2.42156,2.42548,2.42955,2.43387,2.43871,2.44446,2.45155,2.46063,2.47158,2.48439,2.4989,2.51479,2.53184,2.54991,2.56898,2.58932,2.61147,2.63614,2.66471,2.69781,2.73605,2.77974,2.82797,2.87856,2.92809,2.97272,3.0095,3.03731,3.05693,3.07051,3.08003,3.08675,3.09153,3.09459,3.09594,3.0954,3.09281,3.08826,3.08183,3.07358,3.06373,3.05243,3.03982,3.02594,3.01092,2.99493,2.97806,2.96033,2.9421,2.92347,2.90447,2.88501,2.86504,2.8446,2.82363,2.80213,2.78015,2.75787,2.73547,2.71318,2.69119,2.66951,2.64817,2.62717,2.60655,2.58647,2.56703,2.54823,2.53009,2.51256,2.49558:6.9
2.81636,2.81816,2.81987,2.82157,2.82326,2.82501,2.82689,2.82895,2.83111,2.83354,2.8361,2.83882,2.84176,2.84491,2.84829,2.85194,2.85588,2.86018,2.86481,2.86976,2.87497,2.88035,2.88576,2.89111,2.89637,2.90161,2.90696,2.91231,2.91784,2.92353,2.92937,2.93537,2.94162,2.94831,2.95591,2.96496,2.97605,2.98926,3.00455,3.02177,3.04066,3.06097,3.08243,3.10501,3.12895,3.15468,3.183,3.21524,3.25222,3.29466,3.34302,3.39676,3.45397,3.51134,3.56472,3.61033,3.64611,3.67225,3.69072,3.70347,3.71228,3.71855,3.72247,3.72413,3.72343,3.72029,3.71472,3.70679,3.69663,3.68448,3.67066,3.65524,3.63834,3.62011,3.60075,3.58044,3.55936,3.53771,3.51562,3.49319,3.47039,3.44717,3.42351,3.39935,3.3747,3.34957,3.32412,3.29865,3.27339,3.24853,3.22411,3.2001,3.17653,3.15346,3.13101,3.10932,3.0884,3.06822,3.04869,3.02979:7.0
2.24678,2.24636,2.2459,2.24548,2.24514,2.24491,2.2448,2.24477,2.24493,2.24532,2.24592,2.24663,2.2475,2.24858,2.24989,2.25141,2.25322,2.25528,2.25764,2.26025,2.26303,2.26587,2.26867,2.27139,2.27401,2.27655,2.27916,2.28194,2.28489,2.28798,2.29121,2.29458,2.29815,2.30216,2.30688,2.31272,2.32013,2.32909,2.33956,2.35135,2.3642,2.37789,2.39227,2.40738,2.42346,2.44108,2.46089,2.48409,2.51123,2.54286,2.57911,2.61929,2.66147,2.7027,2.73972,2.76999,2.79258,2.80829,2.81888,2.82594,2.83057,2.83359,2.83517,2.83525,2.83373,2.83046,2.82546,2.81885,2.8108,2.80142,2.79078,2.77902,2.76618,2.75239,2.73778,2.7225,2.70655,2.69011,2.67333,2.65627,2.63891,2.62117,2.603,2.58438,2.56531,2.54584,2.5261,2.50629,2.4866,2.46716,2.448,2.42916,2.41067,2.39252,2.37482,2.3576,2.34095,2.32485,2.30926,2.29413:7.2
2.57988,2.58238,2.58484,2.58738,2.59,2.59273,2.59557,2.59852,2.60164,2.60496,2.60855,2.61232,2.61626,2.62036,2.62464,2.62917,2.63396,2.63898,2.64426,2.64982,2.65563,2.66161,2.66764,2.67359,2.67942,2.68515,2.69092,2.69676,2.70274,2.70882,2.71499,2.7212,2.72755,2.73421,2.74142,2.74962,2.75928,2.77042,2.78299,2.79681,2.81161,2.82701,2.84279,2.85894,2.8757,2.8936,2.91341,2.9363,2.96298,2.9942,3.03031,3.0709,3.1143,3.15759,3.19718,3.22988,3.2542,3.27057,3.2807,3.2865,3.28937,3.29029,3.28951,3.28712,3.28302,3.27698,3.26899,3.25919,3.24776,3.23483,3.22059,3.20518,3.18864,3.17104,3.15255,3.13341,3.11365,3.0935,3.07304,3.05228,3.03119,3.00985,2.98815,2.96607,2.94357,2.92065,2.8974,2.87407,2.85095,2.82821,2.80591,2.78398,2.76237,2.74118,2.72048,2.7004,2.68096,2.66208,2.64372,2.62581:7.2
2.67183,2.67372,2.67555,2.67739,2.67933,2.68139,2.68358,2.68583,2.68822,2.69083,2.69359,2.69654,2.69963,2.70288,2.70628,2.70989,2.71375,2.71788,2.7222,2.72674,2.73149,2.73635,2.74124,2.74607,2.75082,2.75546,2.75999,2.76459,2.76917,2.77382,2.77853,2.78326,2.78811,2.79327,2.79905,2.80584,2.81403,2.82373,2.83487,2.84727,2.86069,2.87495,2.88985,2.90535,2.9217,2.93935,2.95891,2.98153,3.00793,3.03876,3.07426,3.11385,3.15577,3.19715,3.23462,3.26537,3.28811,3.30344,3.313,3.31853,3.32146,3.32252,3.32194,3.31978,3.31592,3.31021,3.30266,3.29334,3.28239,3.26998,3.25625,3.24134,3.22533,3.20827,3.19036,3.17171,3.15243,3.13268,3.11256,3.09216,3.07146,3.05041,3.02894,3.00707,2.98476,2.96204,2.93905,2.916,2.89312,2.87052,2.84824,2.8263,2.80471,2.7835,2.76278,2.74265,2.72309,2.70419,2.6858,2.66788:7.2
2.25985,2.26009,2.26042,2.26068,2.26102,2.26148,2.26205,2.26277,2.2637,2.26481,2.26614,2.26771,2.26945,2.27135,2.27349,2.2759,2.27854,2.2815,2.28484,2.28844,2.2923,2.29628,2.30028,2.30424,2.30814,2.312,2.31584,2.31975,2.32386,2.32816,2.33266,2.33727,2.34204,2.34716,2.35284,2.35955,2.36762,2.37755,2.3891,2.40217,2.41653,2.4319,2.44808,2.46501,2.48285,2.502,2.5231,2.54689,2.57457,2.60688,2.64432,2.68661,2.73221,2.77824,2.82108,2.85753,2.88583,2.90616,2.91994,2.92916,2.93529,2.93916,2.94138,2.94196,2.94078,2.93773,2.93282,2.92612,2.91774,2.90785,2.89661,2.88419,2.87065,2.85612,2.84069,2.8244,2.8075,2.79021,2.77252,2.75458,2.7363,2.71771,2.69879,2.67949,2.65973,2.63952,2.619,2.59833,2.57781,2.55758,2.53766,2.51807,2.49881,2.4799,2.46146,2.44357,2.4263,2.40964,2.39354,2.3779:7.7
2.26737,2.26801,2.26855,2.26914,2.2698,2.27054,2.27141,2.27241,2.27358,2.27494,2.27648,2.27824,2.28016,2.28225,2.28453,2.28708,2.28989,2.293,2.2964,2.30007,2.30388,2.30775,2.3116,2.3154,2.31914,2.32281,2.32649,2.33029,2.33427,2.33844,2.34274,2.34719,2.35188,2.357,2.36291,2.36996,2.37872,2.38914,2.40115,2.41456,2.42916,2.44469,2.461,2.47814,2.49637,2.5162,2.53832,2.56392,2.59354,2.62785,2.66699,2.71024,2.75558,2.79995,2.8399,2.87272,2.89737,2.91457,2.92617,2.93389,2.93896,2.94226,2.94401,2.94414,2.94257,2.9392,2.93403,2.92715,2.9187,2.90887,2.89776,2.88552,2.87227,2.85809,2.84305,2.82735,2.81108,2.79443,2.77744,2.76022,2.7427,2.72486,2.70663,2.68799,2.66896,2.64956,2.62993,2.61027,2.59078,2.57159,2.5527,2.53414,2.51593,2.49812,2.48075,2.46394,2.44775,2.43212,2.41694,2.40224:7.7
2.91627,2.92053,2.92478,2.92903,2.93332,2.93767,2.94212,2.94667,2.95135,2.95622,2.96122,2.96637,2.97163,2.977,2.98252,2.98819,2.99414,3.00033,3.00677,3.01333,3.02007,3.02698,3.03397,3.0409,3.04772,3.05439,3.06104,3.06767,3.07435,3.08108,3.08782,3.09458,3.1014,3.10842,3.1159,3.12415,3.13382,3.14476,3.15702,3.17035,3.18452,3.19926,3.21433,3.22972,3.24563,3.26251,3.28111,3.30259,3.32764,3.35692,3.39062,3.42833,3.4686,3.50871,3.54535,3.57567,3.59813,3.61318,3.62249,3.62753,3.62986,3.63014,3.62888,3.6261,3.62162,3.61531,3.60718,3.59733,3.58586,3.57301,3.55897,3.54373,3.5275,3.51038,3.49243,3.47358,3.45415,3.43443,3.4146,3.39446,3.37401,3.35328,3.33222,3.31076,3.28888,3.26662,3.24415,3.22164,3.19926,3.1772,3.15548,3.13412,3.1131,3.09243,3.07224,3.05255,3.03338,3.01478,2.99666,2.97895:7.7
2.31514,2.31512,2.31509,2.3151,2.31517,2.31538,2.31581,2.31649,2.31734,2.31842,2.31972,2.32124,2.32308,2.32519,2.32754,2.33018,2.33307,2.33637,2.34005,2.34404,2.34826,2.35253,2.35674,2.36087,2.36493,2.36894,2.37296,2.37714,2.38155,2.3862,2.39111,2.39623,2.40157,2.40727,2.41376,2.42145,2.43104,2.44242,2.45556,2.47019,2.48607,2.50291,2.52053,2.53889,2.55822,2.57908,2.6022,2.629,2.66018,2.69655,2.73846,2.78535,2.83535,2.88517,2.93071,2.96841,2.99657,3.01571,3.02792,3.03533,3.03968,3.04188,3.0423,3.04091,3.03763,3.03229,3.02489,3.01554,3.0044,2.99164,2.97743,2.96194,2.94532,2.92764,2.90903,2.8896,2.86954,2.84907,2.82824,2.80712,2.78573,2.76399,2.74188,2.71932,2.69629,2.67286,2.64916,2.62542,2.60187,2.57867,2.55589,2.53354,2.51162,2.49019,2.46934,2.44912,2.42961,2.41078,2.39256,2.37491:8.1
2.37006,2.37051,2.37103,2.37163,2.37234,2.37315,2.37409,2.37524,2.37657,2.37818,2.37998,2.38196,2.38413,2.38646,2.38901,2.39187,2.39497,2.39836,2.40195,2.40585,2.40998,2.41427,2.41865,2.42304,2.42729,2.43153,2.43582,2.44013,2.44457,2.44914,2.4538,2.45849,2.46327,2.4683,2.47386,2.48033,2.48811,2.49717,2.50746,2.51888,2.53115,2.544,2.55721,2.57076,2.58489,2.59999,2.61683,2.63654,2.65969,2.68698,2.71866,2.75431,2.79234,2.83008,2.86433,2.89229,2.91258,2.92568,2.93324,2.9369,2.93798,2.93728,2.93502,2.9312,2.92575,2.91857,2.90967,2.89912,2.88706,2.87363,2.85894,2.84311,2.82628,2.80857,2.79007,2.7709,2.75108,2.73083,2.71032,2.68962,2.66869,2.64747,2.62585,2.60379,2.58138,2.55859,2.53556,2.51251,2.48964,2.46708,2.44486,2.42302,2.40158,2.38056,2.36006,2.34009,2.32073,2.30193,2.28374,2.26604:8.4
2.90188,2.90403,2.90624,2.90848,2.91075,2.91307,2.91548,2.91807,2.92082,2.92381,2.92696,2.93029,2.93382,2.93757,2.94155,2.9458,2.95033,2.9552,2.96037,2.96577,2.9714,2.97715,2.98282,2.9883,2.99358,2.99863,3.00361,3.00856,3.01365,3.01893,3.02439,3.02994,3.0356,3.0416,3.04827,3.05612,3.0658,3.07719,3.09017,3.10446,3.11975,3.13574,3.1522,3.16912,3.18689,3.20619,3.22797,3.25371,3.28409,3.31992,3.36141,3.40785,3.45722,3.50614,3.55068,3.5876,3.61553,3.63533,3.64887,3.65817,3.66469,3.66928,3.67207,3.67307,3.67216,3.66922,3.6642,3.65718,3.64833,3.63775,3.6256,3.61199,3.59693,3.58064,3.56322,3.5448,3.52544,3.50543,3.48487,3.46386,3.44234,3.42027,3.39759,3.37425,3.35019,3.32553,3.30042,3.27509,3.24981,3.22475,3.19998,3.17552,3.15139,3.12767,3.10446,3.08183,3.05976,3.03824,3.01719,2.99663:8.5
2.76128,2.76333,2.76547,2.76762,2.76983,2.77215,2.77464,2.77733,2.78019,2.78318,2.78645,2.78986,2.79345,2.79724,2.80126,2.80553,2.81005,2.81485,2.81995,2.82534,2.83098,2.83673,2.84247,2.84812,2.85367,2.85918,2.8647,2.87031,2.87606,2.88199,2.8881,2.8943,2.90055,2.90701,2.914,2.92198,2.93138,2.94221,2.95428,2.96731,2.98097,2.99489,3.00885,3.0229,3.03735,3.05293,3.0705,3.09144,3.11641,3.14617,3.18083,3.2198,3.26122,3.30217,3.33929,3.36978,3.39235,3.40754,3.41705,3.42258,3.42544,3.42646,3.42589,3.42367,3.41969,3.41391,3.40627,3.39687,3.38587,3.37345,3.35972,3.3448,3.32881,3.31181,3.29399,3.2754,3.25622,3.2366,3.21674,3.1966,3.17619,3.15543,3.13426,3.11263,3.09055,3.06801,3.04511,3.0221,2.99923,2.97671,2.9546,2.93286,2.91148,2.89044,2.8698,2.84967,2.83006,2.81094,2.79227,2.77402:9.6
3.27259,3.28032,3.28783,3.29528,3.30272,3.3102,3.31766,3.32504,3.33256,3.34015,3.3478,3.35558,3.36342,3.37125,3.37914,3.38724,3.39547,3.40391,3.41249,3.42129,3.43023,3.43929,3.44833,3.45725,3.46604,3.4746,3.48305,3.49161,3.50022,3.50892,3.51769,3.52644,3.53518,3.54415,3.55358,3.56398,3.57564,3.58864,3.60286,3.61808,3.63399,3.65032,3.66685,3.68359,3.70083,3.7191,3.73923,3.76247,3.78931,3.82045,3.85626,3.89631,3.93884,3.98101,4.01956,4.05179,4.07636,4.09355,4.10504,4.11258,4.11755,4.12052,4.1219,4.12167,4.11976,4.11611,4.11068,4.10355,4.09488,4.08484,4.07364,4.06133,4.04813,4.03409,4.01937,4.004,3.98821,3.97213,3.95588,3.93947,3.92291,3.90611,3.88904,3.87163,3.85382,3.83568,3.81729,3.79883,3.78055,3.76258,3.74492,3.72757,3.7105,3.6937,3.67716,3.66098,3.64524,3.62991,3.61487,3.60001:9.7
2.60481,2.6064,2.60805,2.60977,2.61163,2.61364,2.61581,2.61818,2.6208,2.62374,2.62694,2.63033,2.63396,2.63789,2.64212,2.64668,2.6515,2.6567,2.66226,2.66818,2.67437,2.68073,2.68714,2.69346,2.69967,2.70587,2.71203,2.71829,2.72477,2.73153,2.73855,2.74575,2.75309,2.76075,2.7691,2.77863,2.78993,2.803,2.81763,2.83348,2.85017,2.8673,2.88463,2.90215,2.92015,2.93936,2.96081,2.98605,3.01594,3.05126,3.09228,3.1384,3.1877,3.2368,3.28163,3.31865,3.34602,3.36429,3.37554,3.38189,3.38515,3.38621,3.38525,3.38242,3.3775,3.37046,3.36136,3.35026,3.33728,3.3226,3.30641,3.28882,3.27006,3.25022,3.2294,3.2077,3.18523,3.16237,3.13918,3.11576,3.09202,3.06789,3.04325,3.01808,2.99244,2.96634,2.93991,2.91338,2.88698,2.86098,2.8355,2.81053,2.78599,2.76191,2.73834,2.7154,2.69317,2.67161,2.65057,2.63004:9.7
3.44952,3.45759,3.46563,3.4736,3.48156,3.48952,3.49751,3.50559,3.5137,3.5219,3.53029,3.53872,3.54727,3.55595,3.56475,3.57375,3.58299,3.59248,3.60227,3.6123,3.62253,3.63285,3.64315,3.65335,3.6634,3.67333,3.68328,3.69319,3.70324,3.71338,3.7236,3.73389,3.74426,3.75485,3.76603,3.77816,3.79175,3.80691,3.8234,3.84111,3.8596,3.87849,3.89755,3.91677,3.9366,3.95768,3.98077,4.00731,4.03796,4.07362,4.11449,4.16011,4.20869,4.25727,4.30238,4.34098,4.37144,4.39405,4.41035,4.42215,4.43069,4.4369,4.44103,4.44345,4.444,4.44245,4.43872,4.43287,4.42521,4.41594,4.40507,4.39299,4.37956,4.36492,4.34932,4.33279,4.31561,4.29785,4.27985,4.26159,4.24301,4.22396,4.2045,4.18452,4.16397,4.14296,4.12168,4.10025,4.07891,4.0579,4.03726,4.01699,3.99705,3.97741,3.95819,3.93945,3.92121,3.90339,3.88594,3.86888:10.1
3.16095,3.16676,3.1725,3.17813,3.18381,3.18961,3.19554,3.2016,3.2077,3.21402,3.22049,3.22711,3.23392,3.24089,3.248,3.25529,3.26284,3.27069,3.27891,3.2874,3.29606,3.3048,3.31355,3.32223,3.33081,3.33927,3.3476,3.35604,3.36463,3.3734,3.38226,3.39116,3.40014,3.40933,3.41907,3.42975,3.44193,3.45555,3.4705,3.48656,3.50337,3.52058,3.53797,3.55557,3.57371,3.59298,3.61431,3.63895,3.66769,3.70124,3.7399,3.78311,3.82909,3.87483,3.91674,3.95171,3.97812,3.99648,4.00855,4.01617,4.02081,4.0234,4.0243,4.02349,4.02079,4.01613,4.00949,4.001,3.99081,3.97903,3.9659,3.95159,3.93623,3.91978,3.90244,3.8844,3.8658,3.8468,3.82749,3.80794,3.78818,3.76809,3.74764,3.72677,3.70548,3.68383,3.66186,3.6398,3.61791,3.5964,3.57535,3.55465,3.53433,3.51442,3.49493,3.47594,3.45752,3.43963,3.42218,3.40509:10.1
3.20781,3.21294,3.2181,3.22318,3.22838,3.23368,3.23907,3.24463,3.25038,3.25634,3.26259,3.269,3.27568,3.28255,3.2896,3.29693,3.3046,3.3125,3.32077,3.32939,3.33835,3.34752,3.35677,3.36601,3.37513,3.38412,3.39302,3.40194,3.411,3.4203,3.42977,3.43928,3.44882,3.4585,3.46858,3.47953,3.49176,3.50575,3.52126,3.53807,3.55583,3.57413,3.59263,3.61127,3.63027,3.65016,3.67178,3.69607,3.7246,3.75817,3.79742,3.84225,3.89112,3.941,3.98791,4.02819,4.05966,4.08209,4.09703,4.10652,4.11237,4.11552,4.11665,4.11594,4.11328,4.10846,4.1014,4.09224,4.08121,4.06844,4.05407,4.03827,4.02116,4.00291,3.98358,3.96336,3.9425,3.92105,3.89919,3.87704,3.85464,3.83195,3.80885,3.78536,3.7613,3.73669,3.71166,3.68648,3.66144,3.63672,3.61248,3.58871,3.5653,3.54227,3.51973,3.49781,3.47657,3.45589,3.43573,3.41604:10.1
2.7875,2.78852,2.78955,2.79057,2.79163,2.79278,2.79408,2.7956,2.79736,2.79933,2.80154,2.80393,2.80657,2.80953,2.81281,2.8164,2.8203,2.8246,2.82931,2.83436,2.83964,2.84496,2.85016,2.85518,2.86003,2.86484,2.86976,2.87494,2.8805,2.88652,2.89288,2.89952,2.90641,2.91368,2.92179,2.93133,2.94296,2.95657,2.97207,2.98908,3.00712,3.02579,3.0449,3.0645,3.08499,3.10725,3.13236,3.16194,3.19693,3.23813,3.28576,3.33913,3.39599,3.45246,3.50401,3.54689,3.57934,3.60221,3.61774,3.62815,3.63532,3.64023,3.64321,3.64417,3.64301,3.63956,3.6338,3.62587,3.61597,3.60433,3.59113,3.57648,3.5605,3.54333,3.52508,3.50593,3.4861,3.46575,3.44502,3.42397,3.40253,3.38068,3.35838,3.33556,3.31213,3.28812,3.26368,3.23911,3.21473,3.19076,3.16728,3.14422,3.12155,3.0993,3.07755,3.05638,3.0359,3.01602,2.99669,2.97785:10.9
2.8439,2.84588,2.8478,2.84981,2.85197,2.85428,2.85674,2.85931,2.86212,2.86513,2.86844,2.87201,2.87578,2.87978,2.88406,2.88863,2.89357,2.8988,2.90437,2.91025,2.91643,2.92275,2.92907,2.93531,2.9414,2.94736,2.95338,2.95957,2.96598,2.97269,2.97965,2.98678,2.99406,3.00168,3.00999,3.01943,3.03064,3.04351,3.05786,3.07342,3.08971,3.10633,3.12303,3.13983,3.15713,3.17575,3.19661,3.22139,3.25082,3.28568,3.32628,3.37195,3.42065,3.46891,3.51267,3.54853,3.57497,3.59275,3.60383,3.61033,3.61368,3.61488,3.61421,3.61169,3.60717,3.60058,3.59188,3.58115,3.56858,3.55433,3.53858,3.52154,3.50327,3.48386,3.46344,3.44217,3.42023,3.39783,3.37512,3.35209,3.32872,3.30493,3.28072,3.25606,3.23086,3.20514,3.17904,3.1528,3.12677,3.10115,3.076,3.05132,3.027,3.00307,2.97966,2.95692,2.93482,2.91325,2.89212,2.87146:10.9
3.19967,3.20278,3.206,3.2093,3.21274,3.21636,3.22018,3.22416,3.22841,3.23295,3.23771,3.24274,3.24799,3.25349,3.25927,3.26539,3.27184,3.27865,3.28588,3.29343,3.30131,3.30939,3.31751,3.32551,3.3334,3.34129,3.34918,3.35722,3.36545,3.37391,3.38255,3.39125,3.39998,3.4089,3.41829,3.42862,3.44044,3.45379,3.46846,3.48411,3.50034,3.51678,3.53319,3.54959,3.56639,3.58432,3.60432,3.62799,3.65603,3.68931,3.72812,3.77184,3.8185,3.86476,3.90672,3.94109,3.96632,3.9829,3.99259,3.9975,3.99922,3.99876,3.99639,3.99216,3.98594,3.97761,3.96717,3.95469,3.94039,3.92453,3.90719,3.88846,3.86852,3.8475,3.82562,3.80297,3.77962,3.75583,3.73175,3.7075,3.68302,3.65822,3.63299,3.60725,3.58092,3.55412,3.527,3.49983,3.47286,3.44625,3.42011,3.3944,3.36914,3.34433,3.32,3.29626,3.27314,3.25068,3.22876,3.20729:11.0
2.50771,2.50836,2.50896,2.50962,2.51038,2.51128,2.51235,2.51365,2.51523,2.51706,2.51911,2.52147,2.52412,2.52705,2.5303,2.53392,2.53787,2.54234,2.54727,2.55253,2.55802,2.56361,2.56913,2.57449,2.57966,2.58477,2.59,2.59548,2.60142,2.60782,2.6146,2.62169,2.629,2.63665,2.64515,2.65504,2.66701,2.68095,2.69665,2.71371,2.73162,2.74992,2.76837,2.787,2.80632,2.82727,2.85097,2.87926,2.91284,2.95257,2.99859,3.05009,3.10479,3.15904,3.20855,3.24973,3.28103,3.30315,3.31828,3.32861,3.33581,3.3409,3.34411,3.34542,3.34467,3.34172,3.33658,3.32937,3.32033,3.30965,3.29735,3.28359,3.26845,3.25217,3.23489,3.21664,3.19758,3.17796,3.15795,3.13756,3.11683,3.09571,3.07404,3.05173,3.02873,3.00511,2.98106,2.95683,2.93275,2.90904,2.88576,2.86291,2.84043,2.8184,2.79685,2.77581,2.75538,2.73553,2.71615,2.69724:11.2
2.48686,2.4818,2.47689,2.47213,2.46752,2.46308,2.4589,2.45508,2.45155,2.44836,2.44548,2.44293,2.44076,2.43899,2.43762,2.43655,2.43582,2.43553,2.43571,2.43627,2.43717,2.43831,2.43959,2.44096,2.44245,2.44407,2.4459,2.44811,2.45097,2.45449,2.45865,2.46335,2.46851,2.47431,2.48121,2.48979,2.50071,2.51378,2.52872,2.5451,2.56244,2.58025,2.59813,2.61604,2.63445,2.65429,2.67678,2.70365,2.73566,2.77351,2.81731,2.8662,2.91796,2.96917,3.01591,3.05497,3.08492,3.10651,3.12157,3.13206,3.13961,3.14501,3.14855,3.15014,3.14973,3.14727,3.14271,3.13612,3.12767,3.11755,3.10597,3.09305,3.07886,3.06355,3.04721,3.03,3.01201,2.99357,2.97474,2.95553,2.93594,2.91591,2.89548,2.87461,2.85321,2.83133,2.80914,2.78691,2.76492,2.74336,2.72234,2.70186,2.68188,2.66234,2.64331,2.62492,2.60712,2.58987,2.57305,2.55666:11.2
3.35001,3.3581,3.36609,3.37403,3.38189,3.38971,3.39757,3.40553,3.41355,3.42171,3.42991,3.43814,3.44651,3.45503,3.46369,3.47254,3.48152,3.49071,3.50021,3.50994,3.51984,3.52977,3.53963,3.54939,3.55906,3.56859,3.57798,3.58742,3.59705,3.60689,3.61688,3.62691,3.63698,3.6472,3.65785,3.66944,3.68247,3.69682,3.71233,3.72874,3.74572,3.76291,3.78007,3.79722,3.81467,3.83316,3.85356,3.87735,3.90518,3.93767,3.97511,4.017,4.06156,4.10595,4.14698,4.18192,4.20933,4.22927,4.2434,4.25325,4.26031,4.26559,4.26897,4.27051,4.27019,4.26813,4.26423,4.25845,4.25095,4.24187,4.23134,4.21962,4.20686,4.19314,4.17848,4.16297,4.14674,4.13009,4.11314,4.09595,4.0785,4.06062,4.04227,4.02346,4.00416,3.98443,3.96436,3.94408,3.92387,3.90399,3.88447,3.86527,3.84638,3.82782,3.80954,3.7916,3.77413,3.75704,3.74028,3.72367:11.7
2.30175,2.30322,2.30467,2.30611,2.30758,2.30913,2.31074,2.31247,2.31435,2.31639,2.31856,2.32089,2.32339,2.3261,2.32903,2.33221,2.3356,2.33931,2.34334,2.34755,2.3519,2.35627,2.36052,2.3646,2.36857,2.37245,2.37648,2.38075,2.38537,2.39042,2.3958,2.4014,2.40715,2.41315,2.41972,2.42723,2.43616,2.44644,2.45788,2.47021,2.48304,2.49604,2.50904,2.5221,2.53561,2.55023,2.56687,2.58685,2.61073,2.63908,2.6721,2.70924,2.74884,2.78831,2.82451,2.85478,2.87789,2.89424,2.90537,2.91289,2.91801,2.92153,2.9236,2.92421,2.92328,2.92075,2.91665,2.91101,2.90395,2.8956,2.8861,2.87562,2.86427,2.85213,2.83924,2.82569,2.81167,2.79729,2.78263,2.76781,2.75279,2.73749,2.72184,2.70584,2.68943,2.67263,2.65554,2.63835,2.62126,2.6045,2.58811,2.57205,2.55629,2.54081,2.52567,2.51089,2.4965,2.48249,2.46875,2.45533:12.7
2.418,2.41326,2.40866,2.40415,2.39977,2.3956,2.39173,2.38817,2.38485,2.38189,2.37929,2.37703,2.37512,2.37357,2.3724,2.37161,2.37123,2.37129,2.3718,2.37265,2.37383,2.37527,2.37687,2.37856,2.38034,2.38217,2.38433,2.38701,2.39044,2.39472,2.39974,2.4053,2.41134,2.41802,2.42572,2.43506,2.44666,2.46033,2.47571,2.49226,2.50931,2.52622,2.54257,2.55841,2.5744,2.59162,2.61153,2.63592,2.66565,2.70138,2.74318,2.79008,2.83987,2.88918,2.93417,2.97177,3.00072,3.02165,3.03633,3.04658,3.05397,3.05934,3.06288,3.06464,3.06441,3.0621,3.05772,3.05148,3.04349,3.03385,3.02278,3.0104,2.99686,2.98221,2.96656,2.95007,2.93287,2.91522,2.8971,2.87873,2.85994,2.8408,2.82128,2.80131,2.78077,2.75969,2.73821,2.71668,2.69547,2.67474,2.65457,2.63493,2.61572,2.59702,2.57887,2.56125,2.54406,2.52722,2.51069,2.4946:13.8
2.58587,2.58671,2.5876,2.58849,2.58942,2.59051,2.59184,2.59343,2.59526,2.59735,2.59974,2.60238,2.60536,2.60866,2.61231,2.61634,2.62078,2.62567,2.63107,2.63683,2.64287,2.64893,2.65484,2.66052,2.66597,2.67139,2.67698,2.68295,2.68946,2.6966,2.70421,2.71215,2.72032,2.72878,2.73796,2.74841,2.76095,2.77543,2.79153,2.80872,2.8264,2.84403,2.86127,2.87825,2.89563,2.9145,2.93625,2.96264,2.99466,3.03301,3.07787,3.12839,3.18229,3.23588,3.28484,3.32558,3.35648,3.37824,3.39318,3.40336,3.41043,3.41545,3.41857,3.41979,3.41901,3.41608,3.41099,3.40385,3.39484,3.38413,3.37188,3.35825,3.34329,3.32722,3.31004,3.29194,3.27303,3.25357,3.23376,3.21363,3.19312,3.17216,3.1507,3.12861,3.10581,3.0823,3.05828,3.03405,3.00995,2.98625,2.96303,2.94027,2.91793,2.89593,2.87436,2.85323,2.83267,2.81262,2.79292,2.77366:14.0
2.69766,2.69948,2.70131,2.70313,2.70502,2.70703,2.70922,2.71167,2.71436,2.71732,2.72054,2.72399,2.72773,2.73185,2.73635,2.7412,2.74643,2.7521,2.75824,2.76484,2.77172,2.77861,2.78531,2.79175,2.79797,2.80408,2.8104,2.81713,2.82453,2.83269,2.84144,2.85054,2.85985,2.86946,2.87977,2.89132,2.90496,2.92053,2.93765,2.95571,2.97403,2.99195,3.00912,3.02567,3.04234,3.06034,3.08129,3.10713,3.13878,3.17702,3.22204,3.27301,3.32761,3.38211,3.43207,3.47379,3.50564,3.52833,3.54393,3.55475,3.56243,3.56793,3.57162,3.57341,3.57308,3.57059,3.56596,3.55929,3.55072,3.5404,3.52854,3.51521,3.50057,3.48478,3.46793,3.45016,3.43159,3.41243,3.39286,3.37297,3.35276,3.33211,3.31089,3.28902,3.2664,3.24301,3.21905,3.19489,3.17083,3.14718,3.12408,3.10142,3.0791,3.05713,3.03554,3.01444,2.99378,2.97347,2.9535,2.93385:15.4
3.07259,3.07707,3.08152,3.08597,3.0905,3.09514,3.09988,3.10476,3.10978,3.11506,3.12055,3.12628,3.13225,3.13845,3.1449,3.15167,3.15875,3.16623,3.17404,3.18222,3.19073,3.1994,3.20801,3.2164,3.22456,3.23256,3.24054,3.24868,3.25724,3.26633,3.27589,3.28569,3.29551,3.30536,3.31569,3.32721,3.34055,3.35566,3.37218,3.38955,3.407,3.42379,3.43942,3.45392,3.46803,3.48289,3.50014,3.5217,3.54856,3.58157,3.62085,3.6658,3.71446,3.76356,3.80911,3.84756,3.87708,3.89791,3.91179,3.92133,3.92812,3.93276,3.93549,3.93642,3.93551,3.93267,3.92771,3.9207,3.91183,3.90113,3.88882,3.87534,3.86049,3.84454,3.82725,3.80908,3.79004,3.77038,3.75041,3.73002,3.70931,3.68798,3.66599,3.6433,3.61973,3.59535,3.57032,3.54496,3.51966,3.49467,3.47022,3.44614,3.42233,3.39884,3.37572,3.35297,3.33047,3.3083,3.28639,3.26463:15.5
2.70562,2.70762,2.70961,2.71157,2.71359,2.71571,2.71793,2.72037,2.72311,2.72613,2.72934,2.73279,2.73651,2.74058,2.74502,2.74982,2.75503,2.76061,2.76671,2.77324,2.78003,2.78685,2.7935,2.79989,2.80609,2.81225,2.81858,2.8254,2.83284,2.84094,2.84963,2.85872,2.86799,2.87757,2.88786,2.89953,2.91325,2.92898,2.94632,2.96468,2.98339,3.00173,3.01932,3.03631,3.05348,3.07201,3.09338,3.11961,3.15151,3.18988,3.23501,3.28613,3.34097,3.39576,3.44605,3.48812,3.52027,3.5432,3.55901,3.5699,3.57757,3.58307,3.58668,3.58834,3.58792,3.58538,3.58066,3.57385,3.56517,3.55478,3.54287,3.52959,3.51512,3.49953,3.48293,3.4655,3.44733,3.42872,3.40978,3.39065,3.37125,3.35145,3.33118,3.31034,3.28887,3.26667,3.24394,3.22103,3.1983,3.17603,3.15429,3.13301,3.11214,3.09161,3.07149,3.05181,3.03259,3.01373,2.99516,2.9769:15.7
2.39787,2.39827,2.39871,2.39925,2.3999,2.40071,2.40172,2.40302,2.40459,2.40649,2.40871,2.41121,2.41399,2.41713,2.42071,2.42473,2.42914,2.43398,2.43931,2.44509,2.45116,2.45731,2.46333,2.46909,2.47461,2.48014,2.48589,2.49211,2.499,2.50658,2.5147,2.52319,2.53192,2.54097,2.55064,2.56153,2.57424,2.58874,2.6047,2.62159,2.63878,2.65568,2.672,2.6879,2.704,2.72135,2.74127,2.76566,2.7953,2.83102,2.87309,2.92085,2.97229,3.02386,3.0712,3.11058,3.14007,3.16022,3.17307,3.18092,3.18552,3.18791,3.18835,3.18698,3.18363,3.17816,3.1706,3.16106,3.14973,3.13679,3.12243,3.10685,3.09019,3.07249,3.05387,3.0345,3.01456,2.99423,2.97367,2.9529,2.93196,2.91073,2.88911,2.86701,2.84436,2.82115,2.79751,2.7738,2.75034,2.72735,2.70492,2.683,2.66153,2.64047,2.61986,2.59977,2.58023,2.56117,2.54243,2.52407:16.4
2.7536,2.75518,2.75668,2.75824,2.75986,2.76161,2.76355,2.76568,2.76804,2.77072,2.77364,2.77682,2.78029,2.7841,2.78828,2.79288,2.79785,2.80335,2.80928,2.8156,2.82216,2.82872,2.83509,2.84116,2.84699,2.85279,2.85876,2.86523,2.87241,2.88034,2.88888,2.89778,2.90683,2.91613,2.92614,2.93742,2.95064,2.96568,2.98215,2.99942,3.01679,3.03363,3.0496,3.06488,3.08025,3.097,3.11658,3.1411,3.17136,3.20808,3.25142,3.30045,3.35292,3.40516,3.45295,3.49279,3.52312,3.54456,3.55932,3.56938,3.5764,3.58133,3.58449,3.58574,3.585,3.58215,3.57719,3.57022,3.56145,3.55106,3.53916,3.52591,3.51143,3.49579,3.47912,3.46157,3.44333,3.42459,3.40551,3.3861,3.36637,3.34623,3.32558,3.30434,3.28237,3.25968,3.23641,3.21293,3.18962,3.16672,3.14432,3.12238,3.10084,3.07961,3.05877,3.03835,3.01833,2.9987,2.97934,2.9602:16.4
2.7832,2.78493,2.78661,2.78827,2.79001,2.79191,2.79401,2.79633,2.79889,2.80179,2.80493,2.80834,2.81204,2.81612,2.8206,2.82546,2.83077,2.83661,2.84296,2.84976,2.85683,2.86392,2.87081,2.87741,2.88377,2.8901,2.89658,2.90361,2.91139,2.92,2.92926,2.93891,2.94875,2.95882,2.96961,2.98173,2.9959,3.01198,3.02952,3.04786,3.0662,3.08383,3.10037,3.11601,3.13157,3.14844,3.16823,3.19313,3.22404,3.26172,3.30626,3.35684,3.41116,3.46548,3.51545,3.55737,3.58953,3.61259,3.62862,3.63983,3.6479,3.65381,3.65784,3.65995,3.65995,3.65781,3.65347,3.64703,3.63872,3.6287,3.6171,3.60409,3.58984,3.5744,3.55796,3.54053,3.52236,3.50373,3.48469,3.46537,3.44572,3.42568,3.4051,3.38386,3.36189,3.33912,3.31571,3.29206,3.26859,3.2456,3.22316,3.20119,3.17963,3.15837,3.13748,3.11698,3.09686,3.0771,3.05761,3.03836:16.4
2.66921,2.67101,2.6728,2.6746,2.67649,2.6785,2.6807,2.68311,2.68573,2.68855,2.69159,2.69479,2.69825,2.70201,2.706,2.71023,2.7148,2.71972,2.72501,2.7307,2.73669,2.74282,2.74892,2.75492,2.76082,2.76667,2.77257,2.77876,2.78537,2.79247,2.79991,2.80753,2.81521,2.82302,2.83128,2.84043,2.85113,2.86316,2.8762,2.88966,2.90299,2.9157,2.92748,2.93841,2.94908,2.9604,2.97364,2.99041,3.01159,3.03777,3.06913,3.10496,3.14335,3.18138,3.2157,3.24359,3.26381,3.27678,3.28412,3.28756,3.28842,3.28755,3.28511,3.28116,3.27553,3.26816,3.25905,3.24831,3.23617,3.22275,3.20819,3.19261,3.17613,3.15886,3.14093,3.12249,3.10358,3.08437,3.06505,3.04566,3.02616,3.00651,2.98659,2.96624,2.94537,2.92399,2.90228,2.88053,2.85903,2.83793,2.81729,2.79708,2.77723,2.75775,2.73865,2.71995,2.70153,2.68337,2.66548,2.64785:17.2
2.67577,2.6781,2.68057,2.68308,2.68571,2.68853,2.69157,2.69489,2.69854,2.70251,2.70676,2.7113,2.71615,2.72137,2.72701,2.73307,2.73955,2.74652,2.754,2.76197,2.77035,2.77892,2.78748,2.79586,2.80403,2.81209,2.82032,2.82889,2.83809,2.84789,2.85821,2.86882,2.8795,2.89031,2.90161,2.91401,2.92812,2.94384,2.96075,2.97829,2.99575,3.01248,3.02806,3.04267,3.05704,3.07238,3.09013,3.11232,3.13979,3.17344,3.21352,3.25929,3.30875,3.35841,3.40402,3.44181,3.4699,3.48879,3.50047,3.50707,3.51038,3.51142,3.51051,3.50774,3.50292,3.496,3.48695,3.47585,3.46298,3.44857,3.43265,3.41545,3.39706,3.37756,3.35728,3.33633,3.31474,3.29277,3.27057,3.24835,3.22594,3.20318,3.18005,3.15643,3.13218,3.10726,3.08186,3.05635,3.03107,3.00627,2.98206,2.95833,2.93503,2.91218,2.88979,2.86786,2.84635,2.8252,2.80435,2.78379:17.4
4.08011,4.08917,4.09812,4.10717,4.11636,4.12572,4.13525,4.14491,4.15468,4.16492,4.17554,4.18645,4.19747,4.20886,4.22073,4.23294,4.2455,4.25861,4.27223,4.28657,4.30121,4.3161,4.33101,4.34588,4.3608,4.37556,4.39022,4.40491,4.42026,4.4365,4.45333,4.47067,4.48824,4.50578,4.52351,4.54213,4.56224,4.58461,4.6081,4.63278,4.65754,4.68129,4.70336,4.72369,4.74296,4.76233,4.78281,4.8067,4.83717,4.87521,4.92083,4.97348,5.03142,5.09114,5.14815,5.1977,5.23638,5.26409,5.28335,5.29501,5.30188,5.30611,5.30785,5.30751,5.30478,5.29954,5.29237,5.28192,5.26895,5.2545,5.23829,5.22042,5.20074,5.17928,5.15806,5.13563,5.11103,5.08558,5.06087,5.03552,5.01022,4.98451,4.95862,4.93205,4.90456,4.87669,4.84758,4.81772,4.78824,4.75949,4.73128,4.70338,4.67597,4.64937,4.62348,4.59796,4.57249,4.54711,4.52221,4.49772:17.6
2.69029,2.69155,2.69276,2.69401,2.69537,2.6969,2.6986,2.70053,2.70275,2.70526,2.70805,2.71117,2.7146,2.71841,2.72263,2.72727,2.73244,2.73811,2.74434,2.751,2.75796,2.76499,2.77182,2.77832,2.78454,2.79058,2.79694,2.80387,2.81172,2.82049,2.82999,2.83991,2.84997,2.86024,2.87113,2.88325,2.89732,2.91313,2.93024,2.94801,2.96556,2.98217,2.99748,3.01169,3.02566,3.04081,3.05887,3.08206,3.11116,3.14693,3.1896,3.23838,3.29101,3.34378,3.39235,3.43296,3.46384,3.48563,3.50041,3.51027,3.51704,3.52177,3.52465,3.52563,3.52458,3.52144,3.51616,3.50887,3.49979,3.48911,3.47693,3.46346,3.44884,3.4332,3.41664,3.39924,3.3811,3.3626,3.34385,3.3249,3.30577,3.28632,3.26639,3.24585,3.22459,3.20263,3.18013,3.15743,3.13493,3.11287,3.09137,3.07036,3.04977,3.02952,3.00962,2.99011,2.97094,2.95202,2.9333,2.91486:18.2
2.92248,2.92659,2.93066,2.93476,2.9389,2.94308,2.94739,2.95193,2.95676,2.96173,2.96689,2.97227,2.97786,2.98379,2.99011,2.9968,3.00377,3.0111,3.01896,3.02727,3.03586,3.04451,3.05301,3.06118,3.06903,3.0768,3.08475,3.09322,3.10233,3.11213,3.1225,3.13318,3.14395,3.15491,3.16634,3.17886,3.19301,3.20873,3.22561,3.24301,3.26018,3.2765,3.29172,3.30608,3.32035,3.33582,3.35393,3.37659,3.40472,3.43908,3.47988,3.52634,3.57629,3.62625,3.67206,3.71023,3.73918,3.75953,3.77312,3.78205,3.78784,3.79147,3.79327,3.79326,3.79136,3.78742,3.78144,3.77352,3.76378,3.75249,3.7399,3.72614,3.71132,3.6955,3.67875,3.66128,3.64318,3.62484,3.60627,3.58762,3.56874,3.54952,3.52987,3.50973,3.48896,3.46756,3.44566,3.42355,3.40161,3.38009,3.35907,3.33851,3.31828,3.2983,3.2786,3.25925,3.24021,3.2214,3.20277,3.1843:18.3
3.07417,3.07832,3.08256,3.08688,3.09123,3.09573,3.10044,3.10533,3.11044,3.1159,3.12162,3.12756,3.13378,3.14033,3.14725,3.15455,3.16225,3.1703,3.17894,3.18809,3.19769,3.20758,3.21752,3.22731,3.23689,3.24624,3.25556,3.26508,3.27514,3.28594,3.29737,3.30911,3.32084,3.33249,3.34436,3.35702,3.37108,3.3869,3.40401,3.42185,3.43951,3.45611,3.47104,3.48416,3.49604,3.5079,3.52138,3.53821,3.56034,3.58853,3.62328,3.66426,3.70985,3.75699,3.80171,3.8403,3.87054,3.89217,3.90665,3.91598,3.92194,3.92538,3.92686,3.92665,3.92453,3.92037,3.91412,3.90588,3.89585,3.8842,3.87107,3.85659,3.8409,3.82405,3.80613,3.78732,3.76779,3.74775,3.72738,3.70683,3.68611,3.66511,3.6437,3.62174,3.59898,3.57531,3.55086,3.52601,3.50123,3.47687,3.45302,3.42964,3.40662,3.38389,3.36145,3.3394,3.31769,3.29618,3.27475,3.25335:18.8
2.38078,2.38131,2.38193,2.38262,2.38344,2.38444,2.38567,2.38712,2.38881,2.39093,2.39336,2.39607,2.39913,2.40258,2.40648,2.41084,2.41573,2.42118,2.42714,2.43349,2.44015,2.44684,2.45331,2.45944,2.46526,2.47099,2.47707,2.48374,2.49133,2.49984,2.50913,2.51884,2.52869,2.5387,2.54918,2.56081,2.57425,2.58935,2.60564,2.62234,2.63857,2.65354,2.66685,2.67873,2.69011,2.70243,2.71745,2.73727,2.76279,2.79473,2.83319,2.87739,2.92526,2.97336,3.01761,3.05455,3.08254,3.102,3.1149,3.12322,3.12856,3.13191,3.13356,3.13355,3.13171,3.12793,3.12214,3.11448,3.10521,3.09451,3.08255,3.0694,3.05518,3.03994,3.0239,3.00716,2.98977,2.97209,2.95419,2.93616,2.91792,2.89938,2.88046,2.86104,2.8409,2.81999,2.7985,2.77678,2.75526,2.73427,2.71386,2.69391,2.67432,2.65502,2.63606,2.6175,2.59918,2.58105,2.56303,2.5451:20.6
2.63825,2.63919,2.64014,2.64123,2.64246,2.64389,2.64558,2.64761,2.64998,2.65278,2.65598,2.65958,2.66361,2.66813,2.67324,2.67897,2.68525,2.69222,2.70001,2.70847,2.71745,2.7266,2.73557,2.74411,2.75221,2.76007,2.768,2.7766,2.78636,2.79748,2.80979,2.82279,2.83596,2.84913,2.86261,2.87708,2.89327,2.91169,2.93162,2.95221,2.97227,2.9907,3.00674,3.02035,3.03249,3.04496,3.05986,3.0792,3.10543,3.13931,3.18133,3.23093,3.28613,3.34326,3.39753,3.44451,3.48155,3.50849,3.52714,3.53984,3.54853,3.55441,3.5583,3.56023,3.55998,3.5574,3.55253,3.5455,3.53648,3.52565,3.51321,3.49934,3.48427,3.46805,3.45075,3.43245,3.41334,3.3937,3.37388,3.35394,3.33372,3.31327,3.29239,3.27094,3.24863,3.22526,3.20096,3.17615,3.15144,3.12726,3.10379,3.0809,3.05842,3.03629,3.01448,2.99302,2.97185,2.95081,2.92979,2.90876:21.5
2.87837,2.88271,2.88708,2.89146,2.89592,2.90046,2.90509,2.90997,2.91502,2.92024,2.92567,2.93129,2.93715,2.94329,2.94974,2.95651,2.96366,2.97114,2.97908,2.98747,2.99621,3.00505,3.01382,3.02242,3.0308,3.03906,3.04747,3.05634,3.0659,3.07621,3.08711,3.09828,3.10944,3.12059,3.13215,3.14464,3.15853,3.1737,3.18951,3.20521,3.21989,3.23277,3.24348,3.25224,3.25995,3.26813,3.27841,3.29284,3.31223,3.33716,3.36772,3.40306,3.44131,3.47964,3.5148,3.54412,3.56629,3.58167,3.59171,3.59801,3.60182,3.60394,3.60454,3.60367,3.60122,3.59715,3.59143,3.58416,3.5755,3.56566,3.55478,3.54297,3.53027,3.51677,3.5027,3.48804,3.47291,3.4576,3.44223,3.42687,3.41144,3.3958,3.37986,3.36343,3.34636,3.32867,3.31044,3.29199,3.27373,3.25592,3.23864,3.22181,3.20524,3.18885,3.17261,3.15657,3.14061,3.12457,3.10847,3.09232:23.0
2.47135,2.47174,2.47226,2.47287,2.47361,2.47453,2.47567,2.47711,2.47892,2.48107,2.48352,2.48635,2.48958,2.49326,2.49747,2.50224,2.50755,2.5135,2.52001,2.52708,2.5345,2.54193,2.54905,2.55576,2.56211,2.56838,2.57508,2.5827,2.59144,2.60145,2.61249,2.62407,2.63575,2.64744,2.65949,2.67255,2.6874,2.70375,2.72096,2.73804,2.75394,2.76769,2.77884,2.78774,2.79558,2.80417,2.81551,2.83199,2.85453,2.8839,2.92019,2.96246,3.00854,3.05499,3.0977,3.13321,3.15993,3.17837,3.19028,3.19772,3.2023,3.20494,3.20596,3.20532,3.20292,3.19859,3.19233,3.1843,3.17471,3.16379,3.1517,3.13856,3.1244,3.10943,3.09371,3.07732,3.06038,3.04319,3.02595,3.00868,2.99136,2.97384,2.95599,2.9376,2.91847,2.89855,2.87797,2.85714,2.83653,2.81648,2.7971,2.77831,2.75989,2.74172,2.72378,2.70611,2.68857,2.67098,2.6533,2.63569:24.9
3.13359,3.14021,3.14671,3.15323,3.15981,3.16644,3.17315,3.18009,3.1872,3.19458,3.20217,3.2099,3.21785,3.22611,3.23471,3.24369,3.2531,3.26288,3.2732,3.28394,3.29503,3.30621,3.3172,3.32782,3.33804,3.34806,3.35835,3.36935,3.38124,3.39417,3.40786,3.42189,3.4359,3.44978,3.46387,3.47879,3.49511,3.51269,3.5308,3.54847,3.56471,3.57862,3.58982,3.59871,3.60641,3.61462,3.62533,3.64088,3.66217,3.68981,3.72383,3.76341,3.80641,3.84966,3.8896,3.92328,3.9493,3.96804,3.98114,3.9904,3.99704,4.00178,4.00485,4.00646,4.00641,4.00452,4.00082,3.99543,3.9885,3.98028,3.97088,3.96041,3.94888,3.93642,3.92322,3.90931,3.89486,3.88006,3.86511,3.85008,3.83486,3.81935,3.80341,3.7868,3.76934,3.75101,3.73197,3.71258,3.69334,3.67453,3.65619,3.63822,3.62045,3.60274,3.58512,3.56752,3.54991,3.53214,3.51407,3.49581:26.0
2.70879,2.70999,2.71117,2.7124,2.71383,2.71551,2.71747,2.71983,2.72259,2.7258,2.72949,2.73365,2.73837,2.74371,2.74971,2.75644,2.76391,2.77223,2.7814,2.79136,2.8018,2.81228,2.82239,2.83189,2.84091,2.84982,2.85929,2.86997,2.88238,2.8966,2.91225,2.92872,2.94543,2.9622,2.97954,2.99832,3.01946,3.04257,3.06671,3.09045,3.11224,3.1308,3.14556,3.15705,3.16697,3.17792,3.19264,3.21433,3.24412,3.28282,3.3305,3.38599,3.44641,3.50723,3.56318,3.60983,3.64509,3.6696,3.68587,3.69653,3.70351,3.70804,3.71047,3.71079,3.70884,3.70447,3.69772,3.68879,3.67788,3.66524,3.65107,3.63561,3.61905,3.60142,3.58283,3.56343,3.54348,3.52322,3.50289,3.48255,3.46215,3.44145,3.42034,3.39855,3.37579,3.35201,3.32742,3.30253,3.27797,3.25417,3.23124,3.20898,3.18723,3.16582,3.14464,3.12365,3.10273,3.08167,3.06041,3.03908:26.1
2.44037,2.44137,2.44241,2.44349,2.44469,2.44612,2.44783,2.44975,2.45196,2.4546,2.45753,2.46082,2.46452,2.46869,2.47339,2.47864,2.4844,2.49087,2.49791,2.50552,2.51343,2.52131,2.52889,2.53603,2.54281,2.54951,2.55665,2.56477,2.57415,2.58488,2.59665,2.60896,2.62139,2.63388,2.64674,2.66062,2.6761,2.6929,2.71029,2.72724,2.74266,2.75564,2.76579,2.77356,2.78021,2.78758,2.79774,2.81314,2.83459,2.86272,2.89753,2.93806,2.98213,3.0264,3.06701,3.10077,3.12619,3.14375,3.15525,3.16253,3.1671,3.16978,3.17085,3.17034,3.16813,3.16412,3.15832,3.15088,3.14198,3.1318,3.12057,3.10838,3.09533,3.08149,3.06701,3.05197,3.03653,3.02088,3.0052,2.98956,2.97388,2.95803,2.9419,2.92526,2.90794,2.88989,2.87126,2.85241,2.8338,2.81578,2.79845,2.78167,2.76524,2.74903,2.73301,2.71715,2.70132,2.68542,2.66937,2.65327:27.3
2.67358,2.67434,2.67519,2.6761,2.67712,2.67835,2.67985,2.68166,2.68387,2.68649,2.68953,2.693,2.69698,2.70155,2.70682,2.71286,2.71963,2.72727,2.73573,2.7448,2.75424,2.76361,2.7725,2.78072,2.78843,2.79605,2.80442,2.81417,2.82571,2.83904,2.85383,2.86946,2.88526,2.90096,2.91697,2.93407,2.95314,2.97379,2.99519,3.0161,3.03507,3.05087,3.06296,3.07183,3.07902,3.0869,3.09809,3.11537,3.13987,3.17231,3.21287,3.26075,3.31378,3.36849,3.42059,3.46606,3.50251,3.52969,3.54909,3.56259,3.57202,3.57867,3.58296,3.58507,3.58488,3.58227,3.57725,3.56999,3.56077,3.54985,3.53734,3.52347,3.50834,3.49221,3.47504,3.45706,3.43851,3.41953,3.4005,3.38145,3.36239,3.34316,3.32355,3.30336,3.28234,3.26037,3.23765,3.21466,3.19199,3.17005,3.14903,3.12878,3.10904,3.08964,3.07051,3.0516,3.03275,3.0138,2.99462,2.97534:27.8
2.46575,2.46646,2.46735,2.46835,2.46952,2.47089,2.4725,2.47447,2.47683,2.47971,2.48294,2.48654,2.49059,2.49518,2.50042,2.50634,2.51289,2.52017,2.5281,2.5367,2.5457,2.55468,2.5633,2.57137,2.57901,2.58654,2.5946,2.60376,2.61431,2.62637,2.6397,2.65378,2.66804,2.68224,2.69667,2.71213,2.72941,2.74823,2.76778,2.78689,2.80425,2.81868,2.82966,2.83761,2.84394,2.85083,2.86076,2.87633,2.89868,2.92849,2.96593,3.01009,3.05871,3.10815,3.15398,3.19232,3.22121,3.24108,3.25385,3.26168,3.26632,3.26883,3.26957,3.26858,3.26569,3.26074,3.25379,3.24499,3.23453,3.22262,3.20954,3.19539,3.1803,3.16429,3.14751,3.13004,3.11212,3.094,3.07586,3.05775,3.03959,3.02127,3.00259,2.98335,2.9633,2.94233,2.92065,2.89868,2.87699,2.85596,2.83571,2.81611,2.7969,2.77795,2.75922,2.74063,2.72212,2.70349,2.68459,2.66562:28.1
2.59886,2.59913,2.59953,2.60005,2.60077,2.60173,2.60298,2.60457,2.60665,2.60915,2.6121,2.61558,2.61962,2.6243,2.62973,2.63598,2.64299,2.65096,2.65968,2.6691,2.67886,2.68844,2.69745,2.70572,2.7134,2.72097,2.72931,2.73911,2.75077,2.76434,2.77945,2.7954,2.81151,2.8275,2.84379,2.86117,2.8805,2.90141,2.92292,2.94362,2.96196,2.97664,2.98709,2.99392,2.99886,3.00453,3.01375,3.0295,3.05295,3.08476,3.12492,3.17233,3.22448,3.27746,3.32673,3.36845,3.40069,3.42388,3.43988,3.45085,3.45845,3.46381,3.46725,3.46884,3.46838,3.46572,3.46093,3.45417,3.44563,3.43555,3.42414,3.41153,3.39782,3.38313,3.36752,3.35112,3.33407,3.31673,3.29928,3.28177,3.26425,3.24649,3.22827,3.20933,3.18945,3.16846,3.14656,3.12429,3.10226,3.08091,3.06039,3.04056,3.02117,3.00201,2.98298,2.96401,2.94502,2.92575,2.9061,2.88626:28.7
2.73763,2.74109,2.74458,2.74814,2.75179,2.7556,2.75967,2.76403,2.76866,2.77362,2.77892,2.78456,2.79053,2.79693,2.80383,2.81124,2.8192,2.82779,2.83706,2.84702,2.85753,2.86829,2.87894,2.88925,2.89928,2.90919,2.91948,2.93061,2.94301,2.95671,2.97145,2.98671,3.00196,3.01703,3.03246,3.04905,3.06758,3.0876,3.10824,3.12825,3.14622,3.16095,3.17191,3.17956,3.18538,3.19169,3.20096,3.21612,3.23816,3.26783,3.30505,3.34881,3.39668,3.44502,3.48968,3.52719,3.55589,3.5762,3.58995,3.59914,3.60532,3.60955,3.61203,3.61279,3.61166,3.60858,3.6036,3.59683,3.58846,3.5787,3.56774,3.55568,3.54271,3.52888,3.51429,3.49905,3.48335,3.46745,3.4516,3.43584,3.42006,3.40408,3.38768,3.37066,3.35272,3.33379,3.31407,3.29404,3.27428,3.25513,3.23664,3.21866,3.20099,3.18344,3.16598,3.1486,3.13113,3.11335,3.09517,3.07675:28.8
2.44332,2.44409,2.44489,2.44579,2.44678,2.44796,2.44944,2.45123,2.45334,2.45577,2.45866,2.46193,2.46565,2.46989,2.47471,2.48019,2.48634,2.49312,2.50068,2.50897,2.51772,2.52654,2.53506,2.54299,2.55035,2.5574,2.56466,2.57288,2.58249,2.59381,2.60666,2.6204,2.63432,2.64809,2.66188,2.67633,2.69209,2.70954,2.72782,2.74589,2.76247,2.77623,2.78635,2.79291,2.79713,2.80096,2.8068,2.81678,2.83326,2.85689,2.88798,2.92597,2.96901,3.01392,3.05676,3.09392,3.12327,3.14464,3.15931,3.16916,3.17584,3.1803,3.18313,3.18439,3.1839,3.1816,3.17744,3.17149,3.16399,3.15517,3.14515,3.13407,3.12207,3.10925,3.09567,3.08134,3.06643,3.05117,3.03584,3.02054,3.00525,2.9898,2.97409,2.95789,2.94097,2.92304,2.90418,2.88477,2.86541,2.84659,2.82852,2.81109,2.79403,2.77717,2.7605,2.74395,2.72737,2.71054,2.6934,2.67601:28.9
2.44699,2.44795,2.449,2.45011,2.45135,2.45283,2.45462,2.45665,2.45904,2.46175,2.46485,2.46835,2.47233,2.47681,2.48182,2.48743,2.49369,2.50062,2.50824,2.51635,2.52477,2.53314,2.54115,2.54863,2.55566,2.56259,2.57004,2.57856,2.58852,2.59995,2.61255,2.62576,2.63906,2.65229,2.6658,2.68021,2.69625,2.71349,2.73118,2.74815,2.76316,2.77518,2.7838,2.78956,2.79386,2.79872,2.80644,2.81959,2.83907,2.86546,2.89872,2.93784,2.98065,3.02376,3.06338,3.09637,3.12122,3.13839,3.14961,3.15668,3.16109,3.16369,3.16472,3.16421,3.16207,3.15813,3.15243,3.14512,3.13639,3.12644,3.11544,3.10351,3.09074,3.07724,3.06312,3.0484,3.03325,3.0179,3.00258,2.98736,2.97214,2.95673,2.94099,2.92469,2.90767,2.88986,2.87136,2.85261,2.8341,2.81616,2.79891,2.78225,2.766,2.74996,2.73402,2.71818,2.7023,2.68622,2.66984,2.65336:29.2
2.73924,2.74018,2.74127,2.74251,2.74391,2.74558,2.74762,2.75007,2.75289,2.75622,2.75992,2.76415,2.76893,2.77435,2.78048,2.78727,2.79478,2.80309,2.81221,2.82203,2.83223,2.84241,2.85211,2.86111,2.86953,2.8778,2.88657,2.89653,2.9081,2.92144,2.93623,2.9518,2.96749,2.98305,2.99875,3.01546,3.03391,3.05382,3.07422,3.09379,3.11102,3.12465,3.13416,3.14004,3.14404,3.14857,3.15629,3.17018,3.19139,3.22069,3.25817,3.30284,3.35239,3.40286,3.44957,3.48842,3.51727,3.53676,3.54895,3.55599,3.55967,3.56117,3.56091,3.55872,3.55451,3.54823,3.53989,3.52958,3.51748,3.50394,3.48913,3.47321,3.45626,3.43843,3.41978,3.40044,3.38061,3.36062,3.34063,3.32072,3.30083,3.28066,3.26007,3.23884,3.21683,3.19391,3.17022,3.14621,3.12244,3.09934,3.07716,3.05579,3.03495,3.01437,2.99393,2.97357,2.95318,2.93267,2.91191,2.89096:29.7
3.48451,3.49135,3.49814,3.50489,3.51172,3.51873,3.5259,3.53318,3.54071,3.54849,3.55644,3.56464,3.57317,3.58208,3.59138,3.60112,3.6112,3.62184,3.63309,3.64489,3.65725,3.66984,3.6823,3.69441,3.70617,3.7178,3.72966,3.74219,3.75576,3.77055,3.7863,3.80241,3.81833,3.83392,3.84971,3.86662,3.88536,3.90544,3.92594,3.94548,3.96255,3.97579,3.98447,3.98901,3.99094,3.99268,3.99703,4.00691,4.0233,4.04678,4.07732,4.11388,4.15431,4.19534,4.23334,4.26535,4.28997,4.30757,4.31939,4.32707,4.3322,4.33546,4.33731,4.33745,4.33589,4.3326,4.32758,4.32093,4.31281,4.30343,4.29299,4.28149,4.26907,4.2559,4.24204,4.22749,4.21255,4.19749,4.18245,4.16748,4.15254,4.13745,4.12198,4.10575,4.08849,4.07008,4.05071,4.03094,4.01145,3.99255,3.97422,3.95634,3.93865,3.92098,3.90326,3.88547,3.86741,3.84885,3.82957,3.80973:30.4
3.38648,3.39204,3.39767,3.40334,3.40911,3.41516,3.4216,3.42841,3.43562,3.44328,3.45134,3.45989,3.469,3.47874,3.48917,3.50034,3.51227,3.52516,3.539,3.55378,3.56928,3.58508,3.60068,3.61571,3.63015,3.64426,3.65871,3.67431,3.69172,3.71117,3.73231,3.75425,3.77609,3.79742,3.81876,3.84119,3.86596,3.89244,3.91938,3.94496,3.96711,3.98394,3.9945,3.99937,4.00062,4.00158,4.00599,4.01785,4.0387,4.06915,4.10915,4.15748,4.21139,4.26675,4.31857,4.36255,4.39676,4.42139,4.43873,4.45111,4.46021,4.46702,4.47187,4.47474,4.47562,4.47427,4.47061,4.4648,4.45713,4.44795,4.43744,4.42541,4.41209,4.39771,4.38216,4.36577,4.34875,4.33146,4.31393,4.29623,4.27848,4.2604,4.24177,4.22214,4.20113,4.17867,4.15492,4.13051,4.10624,4.08267,4.05998,4.03794,4.01625,3.99466,3.97296,3.95117,3.9291,3.90649,3.88301,3.85878:31.5
3.5593,3.56522,3.57129,3.57747,3.58383,3.59043,3.59735,3.60471,3.61261,3.62094,3.62971,3.63896,3.6487,3.65904,3.6701,3.68198,3.69452,3.70801,3.72235,3.73766,3.75366,3.76994,3.78602,3.8016,3.81667,3.83159,3.84706,3.86378,3.88241,3.90302,3.92523,3.94825,3.97119,3.99367,4.01627,4.03991,4.06586,4.09347,4.12136,4.14779,4.17059,4.18808,4.19942,4.20513,4.20742,4.20952,4.21507,4.2281,4.24984,4.28129,4.32244,4.37198,4.42694,4.48289,4.53478,4.57832,4.61133,4.63427,4.64928,4.65865,4.66423,4.66762,4.6691,4.66838,4.66538,4.65997,4.65237,4.64278,4.63121,4.61788,4.60316,4.58706,4.56996,4.55183,4.53264,4.51277,4.49243,4.47191,4.45134,4.43079,4.41046,4.39004,4.36905,4.34696,4.32358,4.29898,4.27327,4.24689,4.22071,4.19547,4.17131,4.14782,4.12463,4.10158,4.07851,4.05522,4.0317,4.00756,3.98268,3.95716:32.0
2.89826,2.90112,2.90404,2.90705,2.91017,2.91349,2.91708,2.92096,2.92521,2.92993,2.93498,2.94053,2.94659,2.95323,2.96057,2.96867,2.97755,2.98729,2.99783,3.00894,3.02037,3.03161,3.04224,3.05212,3.06134,3.07048,3.08028,3.0915,3.1046,3.11967,3.13637,3.1539,3.17146,3.18881,3.20623,3.22467,3.24492,3.26659,3.28855,3.30932,3.32728,3.34105,3.35,3.35471,3.35701,3.35964,3.36553,3.3779,3.39783,3.42603,3.46235,3.50571,3.55365,3.60248,3.64789,3.68626,3.71587,3.73708,3.75169,3.76171,3.76878,3.77386,3.77732,3.77902,3.77882,3.77662,3.77247,3.76656,3.75908,3.75017,3.7401,3.72893,3.71678,3.70378,3.6901,3.67568,3.6607,3.64543,3.63014,3.61495,3.59972,3.58433,3.5685,3.55195,3.53444,3.5158,3.49617,3.47611,3.45628,3.43714,3.41881,3.40113,3.38382,3.36664,3.34945,3.3322,3.31475,3.29688,3.27847,3.25968:32.2
2.9307,2.93266,2.93466,2.93686,2.93931,2.94209,2.94526,2.94887,2.95297,2.95763,2.9629,2.96883,2.97539,2.98275,2.99109,3.00038,3.01071,3.0221,3.03455,3.04792,3.06177,3.07552,3.08858,3.10061,3.11181,3.12277,3.1343,3.14763,3.16323,3.18142,3.20172,3.22316,3.24471,3.26587,3.28691,3.30899,3.33311,3.35903,3.38544,3.41044,3.43188,3.44782,3.45721,3.46064,3.46044,3.46012,3.46341,3.47436,3.49427,3.52408,3.56377,3.61228,3.66696,3.72351,3.77676,3.82203,3.85668,3.88092,3.89701,3.90785,3.91482,3.91937,3.92196,3.92283,3.9219,3.91855,3.91288,3.90506,3.89536,3.88434,3.87198,3.85811,3.8431,3.82717,3.81061,3.79337,3.77528,3.75695,3.73874,3.72067,3.70259,3.68432,3.66565,3.64619,3.62546,3.6033,3.57985,3.55569,3.53177,3.50874,3.48671,3.46548,3.44468,3.42403,3.40336,3.38262,3.36162,3.33994,3.31745,3.29426:34.2
3.46981,3.47372,3.47772,3.48186,3.48627,3.49097,3.49603,3.50161,3.50774,3.51438,3.52163,3.52949,3.53814,3.54769,3.55822,3.5698,3.58239,3.59615,3.61096,3.62665,3.64266,3.65829,3.67303,3.68662,3.69926,3.71175,3.7251,3.74049,3.75855,3.77937,3.80233,3.82634,3.85036,3.87397,3.89769,3.92265,3.94995,3.97894,4.00814,4.03525,4.058,4.07446,4.08384,4.08707,4.08692,4.08732,4.09234,4.10604,4.12985,4.16456,4.20998,4.2647,4.32547,4.38728,4.44435,4.49178,4.52734,4.55199,4.56806,4.57824,4.58459,4.58805,4.58977,4.58906,4.58585,4.58015,4.57198,4.56149,4.54907,4.5351,4.51971,4.50302,4.48515,4.46641,4.44682,4.42616,4.40495,4.38368,4.36264,4.34186,4.32104,4.29986,4.27814,4.25569,4.23196,4.20665,4.18009,4.15307,4.1264,4.10069,4.07612,4.05251,4.02937,4.0063,3.98315,3.95982,3.93608,3.91162,3.88632,3.86038:35.1
3.09812,3.10292,3.10775,3.11264,3.11762,3.12276,3.12814,3.13385,3.1399,3.14639,3.1532,3.16037,3.16801,3.17616,3.1849,3.19435,3.20441,3.21504,3.22648,3.23877,3.25191,3.26547,3.27903,3.29222,3.30489,3.31721,3.32954,3.34262,3.35729,3.374,3.39256,3.41218,3.43186,3.45109,3.47012,3.48988,3.51132,3.53474,3.559,3.58251,3.60334,3.61944,3.62929,3.63273,3.6313,3.62793,3.62616,3.62919,3.64,3.65937,3.68749,3.72365,3.76584,3.81063,3.85387,3.89173,3.92184,3.94387,3.95919,3.96957,3.9767,3.98149,3.98459,3.98611,3.98588,3.98373,3.9797,3.97396,3.96665,3.95793,3.94795,3.93688,3.92487,3.912,3.89835,3.88399,3.86889,3.8534,3.83797,3.82281,3.80771,3.79253,3.77706,3.76104,3.74391,3.72527,3.7052,3.68429,3.66345,3.6433,3.62404,3.6055,3.58735,3.56935,3.55131,3.53315,3.51464,3.49539,3.47518,3.45412:35.2
2.6674,2.66808,2.66885,2.66966,2.67064,2.67194,2.67363,2.67569,2.67822,2.68112,2.6845,2.68841,2.69295,2.69823,2.70429,2.71119,2.71885,2.72744,2.73692,2.74717,2.75777,2.76819,2.778,2.78701,2.79538,2.80367,2.81273,2.82341,2.83624,2.85132,2.86821,2.88602,2.90385,2.92137,2.93904,2.95778,2.97841,3.00045,3.0226,3.04314,3.06015,3.07201,3.07804,3.07892,3.07682,3.07489,3.07638,3.08478,3.10115,3.12618,3.15972,3.2005,3.24597,3.29227,3.33501,3.3706,3.3974,3.41592,3.42797,3.43556,3.44033,3.44322,3.44447,3.44403,3.44177,3.4376,3.43156,3.42387,3.41475,3.40432,3.39276,3.38032,3.36709,3.35312,3.33845,3.32325,3.30759,3.29182,3.27618,3.26073,3.24543,3.22999,3.21421,3.19775,3.18028,3.16159,3.14192,3.12184,3.10205,3.08308,3.06507,3.04783,3.03101,3.01437,2.99772,2.98092,2.96374,2.94596,2.92745,2.90838:36.2
3.62312,3.63101,3.63885,3.64674,3.6548,3.66311,3.67172,3.68061,3.6899,3.69954,3.70961,3.72016,3.73129,3.743,3.75536,3.76844,3.78237,3.79717,3.81289,3.82948,3.8468,3.8644,3.88175,3.89847,3.9145,3.93021,3.94646,3.96434,3.98447,4.00698,4.03141,4.05674,4.08194,4.10664,4.13132,4.15717,4.18514,4.21473,4.24431,4.27201,4.29546,4.31271,4.32307,4.32739,4.32803,4.32864,4.33294,4.3451,4.36674,4.39858,4.44057,4.49128,4.54781,4.6057,4.65961,4.70502,4.73971,4.7641,4.78052,4.79134,4.79875,4.80411,4.80704,4.8076,4.806,4.80227,4.79644,4.78849,4.77858,4.76699,4.7539,4.73989,4.72508,4.70914,4.69195,4.67406,4.65608,4.63775,4.61943,4.60144,4.58349,4.56541,4.54666,4.52697,4.50602,4.48377,4.46047,4.43653,4.41259,4.38942,4.36744,4.34641,4.32573,4.30489,4.28372,4.26231,4.24044,4.2178,4.19408,4.16972:36.5
2.6676,2.66901,2.6705,2.67217,2.67412,2.67643,2.67917,2.68237,2.68613,2.6904,2.6953,2.70084,2.70706,2.71408,2.72199,2.73087,2.74075,2.75172,2.76377,2.77672,2.79024,2.8038,2.8168,2.82894,2.84032,2.85154,2.86355,2.87736,2.89368,2.9126,2.93364,2.95582,2.97806,2.99984,3.02162,3.04442,3.06929,3.09561,3.12191,3.14615,3.16599,3.17944,3.18571,3.18567,3.1819,3.17814,3.17819,3.18615,3.20323,3.23019,3.26681,3.31185,3.36258,3.41478,3.46352,3.50453,3.53558,3.55691,3.57064,3.57912,3.58431,3.58753,3.58875,3.58797,3.58513,3.58019,3.57322,3.56437,3.55384,3.54189,3.52875,3.51465,3.49974,3.48407,3.46762,3.4505,3.43307,3.41552,3.39823,3.38122,3.36441,3.34748,3.33014,3.31199,3.29266,3.27199,3.25018,3.22789,3.20592,3.18492,3.16503,3.14597,3.12734,3.10886,3.09031,3.07147,3.05208,3.03188,3.01087,2.98917:37.8
2.88374,2.88575,2.8879,2.89029,2.89302,2.89618,2.89988,2.90418,2.90917,2.91488,2.92123,2.92841,2.93654,2.94579,2.95629,2.96811,2.98124,2.99585,3.01186,3.02906,3.04686,3.06443,3.08098,3.09612,3.11006,3.12365,3.13841,3.15574,3.17653,3.2011,3.22879,3.25815,3.28753,3.31593,3.3437,3.37208,3.40244,3.43411,3.46519,3.49277,3.51356,3.52486,3.52558,3.51704,3.50292,3.48822,3.4778,3.47675,3.48651,3.50785,3.54045,3.58299,3.63252,3.68449,3.7336,3.77525,3.80709,3.82943,3.84396,3.85345,3.85966,3.86387,3.86606,3.86661,3.86521,3.86167,3.85604,3.84859,3.83973,3.82967,3.81837,3.8061,3.79314,3.7796,3.76539,3.75047,3.73514,3.71991,3.70487,3.69032,3.67615,3.66199,3.64734,3.6318,3.61468,3.59562,3.57499,3.55363,3.53258,3.51258,3.49386,3.47617,3.45888,3.4416,3.42387,3.40547,3.38601,3.36518,3.34297,3.31949:44.7
2.79263,2.79402,2.79551,2.79717,2.79909,2.80135,2.80405,2.8072,2.81082,2.81511,2.8199,2.82535,2.83158,2.83871,2.84687,2.8561,2.86639,2.87791,2.89055,2.90419,2.91842,2.9325,2.94577,2.95789,2.96902,2.97996,2.99198,3.00626,3.02362,3.0442,3.06736,3.09185,3.1163,3.13996,3.16318,3.18711,3.21269,3.23932,3.26511,3.2876,3.30401,3.31203,3.31074,3.30125,3.28668,3.2715,3.26008,3.25687,3.26306,3.27924,3.30516,3.33934,3.37909,3.42059,3.45959,3.4926,3.51778,3.53536,3.54693,3.5543,3.55911,3.5622,3.56379,3.56394,3.56246,3.55929,3.55447,3.54817,3.54068,3.53216,3.52281,3.51287,3.50233,3.49129,3.47973,3.46771,3.45537,3.44308,3.43121,3.4198,3.40872,3.39768,3.38631,3.37417,3.36072,3.34564,3.32909,3.31183,3.29485,3.27887,3.26409,3.2502,3.23662,3.22297,3.20893,3.19431,3.17875,3.16188,3.1436,3.12417:45.0
2.74019,2.74104,2.74208,2.74336,2.74496,2.74697,2.74955,2.75276,2.75667,2.76128,2.76663,2.77277,2.77988,2.78819,2.79785,2.80881,2.82116,2.83493,2.85019,2.86675,2.88403,2.90111,2.91709,2.93156,2.94486,2.95795,2.97245,2.9899,3.0111,3.03628,3.06464,3.09458,3.12443,3.15328,3.18144,3.21026,3.241,3.27267,3.30315,3.32938,3.34803,3.35635,3.35338,3.34073,3.32236,3.30359,3.28953,3.28529,3.29229,3.31113,3.34137,3.38132,3.42779,3.4763,3.52189,3.56051,3.59015,3.61113,3.62535,3.63491,3.64153,3.64612,3.64908,3.65036,3.64982,3.64733,3.64292,3.63685,3.62938,3.62072,3.61116,3.60084,3.58991,3.57844,3.56625,3.55355,3.54043,3.52739,3.51482,3.50281,3.49117,3.47943,3.46721,3.45399,3.43921,3.42254,3.40422,3.38506,3.3662,3.34849,3.33216,3.31681,3.30181,3.28664,3.27097,3.25446,3.23681,3.21748,3.19647,3.1742:45.7
3.0035,3.00693,3.01034,3.01383,3.01746,3.02126,3.02523,3.02946,3.0339,3.0387,3.04373,3.04901,3.05462,3.0606,3.06701,3.07388,3.08118,3.08905,3.09742,3.10628,3.11559,3.12507,3.13443,3.14347,3.15219,3.16076,3.16963,3.17923,3.18983,3.20157,3.21419,3.22722,3.24023,3.25311,3.26613,3.27984,3.29496,3.31106,3.32756,3.34338,3.35741,3.3687,3.37681,3.38208,3.38567,3.38938,3.39525,3.40564,3.42155,3.44362,3.47188,3.50557,3.54284,3.58067,3.61553,3.64437,3.66568,3.67973,3.688,3.69225,3.69373,3.69339,3.69153,3.68823,3.68331,3.6767,3.66841,3.65854,3.64733,3.63498,3.6216,3.60739,3.59239,3.57675,3.56051,3.54377,3.52667,3.50951,3.49241,3.47545,3.45855,3.44156,3.42426,3.40654,3.38818,3.36908,3.34935,3.32937,3.30959,3.29039,3.27185,3.25385,3.23615,3.2186,3.20121,3.18385,3.16651,3.14903,3.13123,3.1132:29.8
2.78816,2.78946,2.79088,2.79238,2.794,2.79581,2.79781,2.80003,2.80251,2.8052,2.80813,2.81122,2.81462,2.81826,2.82214,2.82631,2.83078,2.83556,2.84066,2.84606,2.85164,2.85721,2.86276,2.86831,2.87382,2.87933,2.88486,2.89035,2.8959,2.90147,2.90708,2.91285,2.91894,2.92564,2.93333,2.94229,2.95267,2.96464,2.97801,2.99246,3.00777,3.02385,3.04068,3.05843,3.0775,3.0985,3.12214,3.14929,3.18115,3.21795,3.25898,3.3024,3.345,3.38317,3.41406,3.43652,3.45115,3.4596,3.46375,3.46499,3.4641,3.46135,3.4569,3.45058,3.44228,3.43199,3.41982,3.40599,3.39061,3.37381,3.35575,3.33653,3.31627,3.29515,3.27323,3.25075,3.22778,3.20451,3.18092,3.15701,3.1328,3.10826,3.08333,3.058,3.03236,3.00649,2.98064,2.95502,2.92975,2.90491,2.88048,2.85646,2.83293,2.81004,2.78787,2.76645,2.7458,2.72582,2.70645,2.68771:5.9
3.02768,3.03286,3.03808,3.04335,3.04876,3.05436,3.06027,3.06656,3.07319,3.08018,3.08759,3.09542,3.10375,3.11273,3.12244,3.13287,3.14401,3.15589,3.16877,3.18258,3.19715,3.21204,3.22673,3.24083,3.25427,3.26738,3.28095,3.29582,3.31272,3.33204,3.35349,3.37623,3.3992,3.42165,3.44356,3.4659,3.48959,3.51435,3.53904,3.56187,3.5806,3.59309,3.59791,3.59504,3.58624,3.57495,3.56565,3.56132,3.56413,3.57509,3.59431,3.62114,3.65392,3.69003,3.72606,3.75847,3.78399,3.80266,3.8156,3.82433,3.83022,3.83413,3.83651,3.83758,3.83738,3.83582,3.83276,3.82827,3.82256,3.8158,3.8082,3.79993,3.79112,3.78185,3.77217,3.76206,3.75162,3.74104,3.7306,3.72056,3.71098,3.70165,3.69224,3.68246,3.67194,3.66028,3.64725,3.63314,3.61861,3.60446,3.59119,3.57889,3.56716,3.55564,3.544,3.53205,3.51955,3.5062,3.49175,3.47613:46.0
2.06642,2.06583,2.06518,2.06465,2.06417,2.06373,2.0634,2.06314,2.06301,2.06317,2.06347,2.06387,2.06434,2.06493,2.06572,2.06673,2.06794,2.06937,2.07092,2.07277,2.07489,2.07718,2.07952,2.08184,2.08416,2.08646,2.08871,2.09084,2.09289,2.09478,2.09661,2.09849,2.10066,2.10347,2.10722,2.11224,2.11908,2.12781,2.13855,2.15138,2.16619,2.18286,2.20128,2.22135,2.24308,2.26663,2.29241,2.32141,2.35402,2.39101,2.43253,2.47795,2.52536,2.5717,2.61349,2.64805,2.67435,2.69332,2.70675,2.71638,2.72355,2.72883,2.73251,2.73456,2.73488,2.73335,2.72997,2.72481,2.71797,2.70959,2.69981,2.68876,2.67659,2.66335,2.64921,2.63422,2.61852,2.60227,2.58562,2.5686,2.55113,2.53326,2.5149,2.49606,2.47682,2.45726,2.43748,2.41761,2.3978,2.37818,2.35881,2.33972,2.32094,2.30254,2.28461,2.26731,2.25074,2.23491,2.21983,2.2054:1.4
2.60033,2.60095,2.60167,2.60247,2.6034,2.60448,2.60572,2.60715,2.60881,2.61076,2.61291,2.61524,2.6178,2.6206,2.62364,2.62693,2.63044,2.63425,2.63835,2.64272,2.64736,2.65214,2.657,2.66189,2.66674,2.67156,2.67636,2.68107,2.68575,2.69039,2.69502,2.69966,2.70443,2.70954,2.7153,2.72201,2.73022,2.73999,2.75126,2.764,2.77808,2.7933,2.80949,2.82657,2.84466,2.8641,2.88535,2.90952,2.9372,2.9692,3.00597,3.047,3.09055,3.13361,3.17252,3.2041,3.22677,3.24095,3.24878,3.25206,3.25235,3.25048,3.24681,3.24137,3.23402,3.22465,3.21323,3.19989,3.18485,3.16826,3.15025,3.13096,3.11046,3.08894,3.06658,3.04341,3.01957,2.99533,2.97075,2.94584,2.92067,2.89517,2.8693,2.84303,2.81635,2.78936,2.76224,2.73515,2.70825,2.68169,2.65551,2.62978,2.60453,2.5798,2.55569,2.53232,2.50979,2.48807,2.46712,2.44686:4.6
2.24077,2.24064,2.24046,2.24035,2.24029,2.24031,2.24045,2.24075,2.2412,2.24187,2.24274,2.24381,2.24508,2.24656,2.24824,2.25014,2.2523,2.25474,2.25752,2.26059,2.2639,2.26741,2.27096,2.2745,2.27804,2.28149,2.28501,2.28848,2.29211,2.29587,2.29977,2.3038,2.30799,2.31249,2.31766,2.32392,2.33163,2.34133,2.35283,2.36604,2.38071,2.3966,2.41346,2.43119,2.44994,2.47011,2.49224,2.51708,2.54601,2.57958,2.61839,2.66216,2.70935,2.75705,2.80156,2.83955,2.86915,2.8905,2.90518,2.91508,2.92187,2.92634,2.92908,2.93014,2.92938,2.92673,2.92215,2.9157,2.90755,2.89783,2.88671,2.87434,2.86082,2.84623,2.83066,2.81431,2.79729,2.77977,2.76189,2.74368,2.72513,2.70628,2.68706,2.66739,2.6473,2.62676,2.60581,2.58472,2.56375,2.54305,2.52269,2.50266,2.48295,2.46358,2.44466,2.42634,2.40867,2.39164,2.3752,2.3593:6.4
2.90188,2.90403,2.90624,2.90848,2.91075,2.91307,2.91548,2.91807,2.92082,2.92381,2.92696,2.93029,2.93382,2.93757,2.94155,2.9458,2.95033,2.9552,2.96037,2.96577,2.9714,2.97715,2.98282,2.9883,2.99358,2.99863,3.00361,3.00856,3.01365,3.01893,3.02439,3.02994,3.0356,3.0416,3.04827,3.05612,3.0658,3.07719,3.09017,3.10446,3.11975,3.13574,3.1522,3.16912,3.18689,3.20619,3.22797,3.25371,3.28409,3.31992,3.36141,3.40785,3.45722,3.50614,3.55068,3.5876,3.61553,3.63533,3.64887,3.65817,3.66469,3.66928,3.67207,3.67307,3.67216,3.66922,3.6642,3.65718,3.64833,3.63775,3.6256,3.61199,3.59693,3.58064,3.56322,3.5448,3.52544,3.50543,3.48487,3.46386,3.44234,3.42027,3.39759,3.37425,3.35019,3.32553,3.30042,3.27509,3.24981,3.22475,3.19998,3.17552,3.15139,3.12767,3.10446,3.08183,3.05976,3.03824,3.01719,2.99663:8.5
2.30817,2.30655,2.30498,2.30344,2.30198,2.30067,2.29955,2.29861,2.29793,2.29748,2.29728,2.29731,2.29761,2.29821,2.29919,2.3005,2.30214,2.30416,2.30658,2.30939,2.31246,2.31561,2.3187,2.32168,2.32463,2.32763,2.33081,2.33434,2.33841,2.34303,2.34808,2.35334,2.35875,2.36458,2.37138,2.37963,2.38966,2.40148,2.41497,2.42973,2.44533,2.46133,2.47746,2.49385,2.51103,2.52976,2.55099,2.57573,2.60486,2.63926,2.67948,2.72483,2.77326,2.82118,2.86454,2.9003,2.92752,2.94712,2.96099,2.97079,2.97769,2.98247,2.98539,2.9864,2.98535,2.98216,2.9769,2.96968,2.96067,2.95006,2.93805,2.92484,2.91055,2.89523,2.87902,2.86206,2.84454,2.82669,2.80863,2.79036,2.77187,2.75312,2.7341,2.71471,2.69486,2.67462,2.65416,2.63377,2.61375,2.59426,2.57528,2.55677,2.53869,2.5211,2.50412,2.48775,2.47195,2.45662,2.4417,2.42723:11.0
2.40439,2.40103,2.3978,2.39473,2.39185,2.38919,2.38685,2.38486,2.38324,2.38199,2.3811,2.3806,2.38055,2.38104,2.3821,2.38371,2.38583,2.38847,2.39175,2.39558,2.39978,2.40402,2.40804,2.41179,2.41534,2.41883,2.42255,2.42687,2.43215,2.43851,2.44567,2.45309,2.46056,2.46837,2.47736,2.48826,2.50143,2.51684,2.53412,2.55253,2.57115,2.58906,2.60587,2.62187,2.63818,2.65641,2.67825,2.70522,2.73843,2.7788,2.8267,2.88101,2.93884,2.99554,3.04616,3.08755,3.11899,3.14215,3.1594,3.17266,3.18321,3.19173,3.19833,3.20289,3.20521,3.20525,3.20298,3.19853,3.19204,3.1837,3.17368,3.16205,3.14897,3.1345,3.11875,3.10189,3.08411,3.06564,3.04666,3.0272,3.00723,2.98673,2.96565,2.94381,2.92099,2.89719,2.87274,2.84812,2.82384,2.80012,2.77692,2.75416,2.73179,2.70992,2.68864,2.66795,2.64772,2.62778,2.60808,2.5888:13.5
3.86543,3.87217,3.87899,3.88595,3.89309,3.90047,3.90805,3.91575,3.92366,3.93195,3.94064,3.94957,3.9587,3.96805,3.97773,3.98786,3.99844,4.00936,4.02065,4.03238,4.04441,4.05661,4.06886,4.081,4.09296,4.10488,4.1168,4.12904,4.1417,4.15476,4.16811,4.18159,4.195,4.20827,4.22183,4.23607,4.25172,4.2685,4.28633,4.30451,4.32225,4.33905,4.35464,4.36909,4.38306,4.39755,4.41426,4.43485,4.46015,4.49106,4.52807,4.57026,4.61538,4.66003,4.70025,4.73279,4.75613,4.7707,4.77813,4.78081,4.78058,4.7779,4.77333,4.76669,4.75798,4.7472,4.73417,4.71906,4.70219,4.68367,4.66366,4.64241,4.61988,4.5961,4.57132,4.54599,4.52021,4.49376,4.46722,4.44044,4.41347,4.38621,4.35852,4.33036,4.30158,4.27217,4.24226,4.21219,4.1824,4.15317,4.12448,4.09623,4.06837,4.04096,4.01399,3.98755,3.96163,3.93614,3.91103,3.88612:17.0
3.66778,3.67131,3.67494,3.67866,3.68262,3.68689,3.6917,3.69716,3.7032,3.70984,3.71726,3.72547,3.73466,3.74486,3.75628,3.76891,3.78271,3.79762,3.81365,3.83059,3.84773,3.86417,3.8793,3.89313,3.90627,3.91957,3.93393,3.9503,3.96967,3.99224,4.0173,4.04334,4.0691,4.09479,4.12182,4.1517,4.18516,4.22198,4.26084,4.30027,4.33792,4.37153,4.40013,4.4247,4.44833,4.47492,4.50794,4.55026,4.60366,4.66969,4.74887,4.83984,4.93747,5.03277,5.11724,5.1854,5.23697,5.27241,5.29821,5.31631,5.32999,5.34049,5.34857,5.35279,5.35347,5.3503,5.34562,5.33675,5.3247,5.30865,5.29139,5.27323,5.25269,5.22966,5.20456,5.17801,5.15068,5.12181,5.09311,5.06304,5.03194,5.00015,4.96762,4.93454,4.89922,4.86201,4.82403,4.78551,4.74722,4.70967,4.67364,4.63864,4.60427,4.5701,4.53654,4.50319,4.4704,4.43776,4.40496,4.37236:22.4
3.24932,3.25538,3.26152,3.26786,3.27439,3.28116,3.28824,3.29561,3.30333,3.31161,3.32026,3.32935,3.33894,3.34909,3.3599,3.37146,3.38372,3.3968,3.41069,3.42554,3.44114,3.45697,3.4726,3.48774,3.50217,3.51623,3.53044,3.54569,3.56269,3.58143,3.6016,3.62244,3.64321,3.66366,3.6842,3.70608,3.73041,3.75648,3.78363,3.81015,3.83429,3.85457,3.87018,3.88147,3.89025,3.89914,3.9116,3.93076,3.95824,3.99489,4.04115,4.09553,4.15548,4.21671,4.27389,4.32257,4.35974,4.3848,4.40194,4.41304,4.4212,4.42665,4.42975,4.43109,4.43003,4.42625,4.42019,4.41197,4.40183,4.39028,4.3772,4.36255,4.34649,4.32906,4.31105,4.29159,4.27118,4.25072,4.23038,4.20996,4.18913,4.16835,4.14694,4.12455,4.10072,4.07527,4.04871,4.02162,3.99473,3.96851,3.94297,3.91813,3.89359,3.86914,3.84505,3.82099,3.7966,3.77185,3.74664,3.72105:27.9
3.32289,3.32988,3.33671,3.34351,3.35041,3.35752,3.36478,3.37218,3.37992,3.38802,3.39639,3.405,3.41396,3.42346,3.4336,3.44424,3.4552,3.46674,3.47931,3.49255,3.50631,3.52039,3.53451,3.54839,3.56181,3.57481,3.58768,3.60141,3.61664,3.63352,3.65187,3.67102,3.69025,3.70922,3.72814,3.74779,3.76919,3.79253,3.81681,3.84067,3.86255,3.88085,3.89436,3.90296,3.90789,3.91149,3.91676,3.92679,3.94425,3.96963,4.00317,4.04437,4.09133,4.14051,4.1875,4.22847,4.26129,4.28582,4.30327,4.31539,4.32391,4.33007,4.33461,4.33767,4.33869,4.33761,4.33448,4.32962,4.32324,4.31528,4.30588,4.2954,4.28411,4.27209,4.25902,4.24516,4.23058,4.21576,4.20114,4.18673,4.1721,4.15727,4.14239,4.12713,4.11084,4.09316,4.0742,4.05465,4.03541,4.01694,3.99917,3.98182,3.96473,3.94794,3.93132,3.91463,3.89764,3.88028,3.86239,3.84393:31.5
2.63488,2.63596,2.63717,2.63858,2.64022,2.64213,2.64446,2.64736,2.65078,2.65477,2.6594,2.66459,2.67057,2.67746,2.68539,2.69441,2.70446,2.7157,2.72822,2.74188,2.75635,2.77086,2.78464,2.79728,2.8088,2.81971,2.83108,2.84427,2.86035,2.87983,2.90236,2.9267,2.9513,2.97515,2.99831,3.02171,3.04632,3.07241,3.09845,3.12235,3.14132,3.15266,3.15472,3.14771,3.13401,3.11771,3.10342,3.09487,3.09562,3.10625,3.12682,3.15628,3.19244,3.23178,3.27016,3.30384,3.33047,3.34971,3.36272,3.37119,3.3767,3.38006,3.38206,3.38268,3.38174,3.37916,3.37493,3.36916,3.36216,3.35415,3.34528,3.33571,3.32558,3.31499,3.30395,3.29235,3.2803,3.2681,3.25627,3.24502,3.23411,3.22337,3.21253,3.20117,3.18866,3.17442,3.15845,3.14138,3.12433,3.1082,3.09329,3.0794,3.06598,3.05257,3.03894,3.02488,3.00998,2.99377,2.97599,2.95689:46.5
3.23024,3.24007,3.24974,3.25922,3.26856,3.27784,3.28712,3.2964,3.30564,3.31485,3.32401,3.33323,3.34245,3.35166,3.36085,3.37004,3.37931,3.38867,3.39819,3.40774,3.41735,3.42699,3.43657,3.44603,3.4554,3.46472,3.4739,3.48295,3.49194,3.50086,3.5097,3.51847,3.52726,3.53619,3.54547,3.55547,3.56644,3.57841,3.59148,3.60549,3.62036,3.63596,3.65214,3.66887,3.68624,3.70458,3.72435,3.74645,3.77132,3.79946,3.83115,3.86597,3.90264,3.93902,3.97254,4.00096,4.02317,4.03942,4.05103,4.05938,4.06545,4.06994,4.073,4.07477,4.07506,4.07382,4.07108,4.06685,4.0612,4.05435,4.04653,4.03784,4.02828,4.0179,4.0068,3.99507,3.98293,3.97049,3.95784,3.94499,3.93191,3.91852,3.90482,3.89085,3.8766,3.8621,3.84742,3.83262,3.81789,3.80334,3.78898,3.77483,3.76084,3.74703,3.73346,3.72015,3.70723,3.69467,3.68233,3.67024:6.1
2.19217,2.19194,2.19171,2.19145,2.19119,2.19103,2.19104,2.1912,2.19145,2.19189,2.19249,2.19321,2.1941,2.19519,2.19645,2.19783,2.1994,2.20129,2.20351,2.20599,2.20865,2.21141,2.21423,2.21712,2.22003,2.22288,2.22567,2.22831,2.23082,2.23325,2.23571,2.23826,2.24109,2.24451,2.24892,2.25478,2.26264,2.27259,2.28467,2.29884,2.31506,2.33321,2.35317,2.37487,2.39831,2.42368,2.45147,2.48271,2.51801,2.55812,2.60317,2.6524,2.70369,2.75371,2.79878,2.83598,2.86432,2.88472,2.89911,2.90935,2.91687,2.92257,2.92655,2.92871,2.92894,2.92716,2.92336,2.91766,2.91022,2.90114,2.89056,2.87859,2.86535,2.85098,2.8357,2.81951,2.80262,2.78518,2.76722,2.74885,2.73009,2.71089,2.69116,2.67094,2.65025,2.62919,2.60792,2.5866,2.56538,2.54438,2.52357,2.50304,2.4829,2.46319,2.44407,2.4256,2.40785,2.39088,2.37466,2.35912:2.0
2.69596,2.69735,2.69875,2.70025,2.70182,2.70353,2.70536,2.7073,2.70951,2.71207,2.71481,2.71774,2.7208,2.72404,2.72752,2.73126,2.73533,2.73966,2.74422,2.749,2.75402,2.75924,2.76455,2.76985,2.77509,2.78024,2.78534,2.79039,2.79547,2.80055,2.80558,2.81063,2.81583,2.82137,2.82766,2.835,2.844,2.85462,2.86694,2.88087,2.89624,2.91287,2.93061,2.94937,2.96923,2.99042,3.01366,3.04,3.07032,3.1053,3.14538,3.19011,3.23766,3.28488,3.3278,3.36284,3.38831,3.40479,3.41427,3.41873,3.41989,3.41904,3.41637,3.41165,3.4048,3.39588,3.38488,3.3719,3.35707,3.34053,3.32245,3.30298,3.28228,3.26046,3.23769,3.21414,3.18989,3.16524,3.14018,3.11483,3.08914,3.06307,3.03664,3.00976,2.98246,2.95483,2.92702,2.89921,2.87158,2.84432,2.81748,2.79105,2.76506,2.73962,2.71482,2.69079,2.66755,2.64519,2.62356,2.60263:4.7
2.49473,2.49564,2.49655,2.49751,2.49853,2.49967,2.50098,2.50236,2.50387,2.50561,2.50748,2.5095,2.51168,2.51399,2.5164,2.51898,2.52181,2.52489,2.52813,2.5316,2.53526,2.53902,2.54285,2.54672,2.55053,2.55429,2.55807,2.56179,2.56557,2.56933,2.57305,2.57677,2.5806,2.5847,2.58939,2.59488,2.60166,2.6097,2.61903,2.62958,2.64119,2.65371,2.66699,2.68101,2.69587,2.71189,2.72959,2.74998,2.77357,2.80095,2.83233,2.86716,2.90379,2.93963,2.97171,2.99765,3.01647,3.02871,3.03605,3.03993,3.04148,3.04146,3.03995,3.03697,3.03242,3.02626,3.01851,3.00922,2.99845,2.98639,2.97315,2.95882,2.94352,2.92733,2.91037,2.89273,2.87452,2.85596,2.8371,2.81797,2.79853,2.77874,2.75862,2.73813,2.71728,2.69612,2.67475,2.65337,2.63211,2.61107,2.59034,2.56992,2.54984,2.5301,2.5108,2.49207,2.47391,2.4564,2.4395,2.42313:5.3
2.78651,2.78878,2.79103,2.7933,2.79563,2.79802,2.80049,2.80311,2.80582,2.80872,2.81181,2.81499,2.81834,2.82185,2.82551,2.82938,2.83346,2.83774,2.84226,2.84704,2.85199,2.857,2.86201,2.86694,2.87179,2.87655,2.88129,2.88592,2.89062,2.89536,2.90015,2.905,2.90995,2.91522,2.92114,2.92812,2.93662,2.94669,2.95829,2.97124,2.98536,3.00038,3.01613,3.03264,3.0501,3.06893,3.0899,3.11417,3.14247,3.17544,3.21331,3.25545,3.29998,3.34382,3.38349,3.41621,3.44083,3.45806,3.46969,3.47751,3.48281,3.48628,3.4881,3.48828,3.4867,3.48324,3.47787,3.47064,3.46173,3.45125,3.4393,3.42598,3.4114,3.39569,3.37892,3.36117,3.34265,3.3235,3.30391,3.28381,3.26323,3.24213,3.22049,3.19829,3.17551,3.15219,3.12848,3.10459,3.08076,3.05715,3.03382,3.01077,2.98801,2.96558,2.94358,2.92211,2.90129,2.88106,2.86135,2.84216:6.0
2.77778,2.78078,2.7838,2.78679,2.78979,2.79282,2.7959,2.7991,2.80242,2.8059,2.80943,2.81309,2.81689,2.82079,2.8248,2.829,2.8334,2.83802,2.84284,2.8478,2.85292,2.85812,2.86332,2.86846,2.87349,2.87836,2.88313,2.88787,2.89253,2.8972,2.90191,2.90661,2.9114,2.91649,2.92213,2.92872,2.93678,2.94623,2.9571,2.96927,2.98252,2.99662,3.01143,3.02693,3.0433,3.06095,3.08052,3.10315,3.12938,3.15995,3.19504,3.23405,3.27523,3.31584,3.35267,3.38314,3.40616,3.42239,3.43344,3.4409,3.446,3.44941,3.45128,3.45163,3.45033,3.44732,3.44253,3.43605,3.42802,3.41851,3.40765,3.39552,3.38228,3.36799,3.35273,3.33661,3.31975,3.30238,3.28456,3.26637,3.24773,3.22865,3.20907,3.18897,3.16838,3.14733,3.12595,3.10443,3.08295,3.06165,3.04061,3.01981,2.99927,2.97911,2.95938,2.94017,2.92146,2.90324,2.88553,2.86827:6.4
2.60265,2.60327,2.6039,2.60448,2.60511,2.60584,2.60667,2.60758,2.6087,2.61,2.61148,2.61312,2.61489,2.61681,2.61892,2.62123,2.62382,2.62673,2.62989,2.63329,2.63687,2.64051,2.64416,2.64775,2.65122,2.65471,2.65816,2.66169,2.66534,2.66914,2.67309,2.67716,2.68144,2.68615,2.69162,2.69826,2.7066,2.71673,2.72862,2.74206,2.75686,2.7728,2.78973,2.80764,2.82678,2.84752,2.87058,2.8972,2.92798,2.96365,3.00451,3.04996,3.0981,3.1458,3.18933,3.22559,3.25316,3.27262,3.2858,3.29461,3.30052,3.30456,3.30686,3.30745,3.30617,3.30291,3.29771,3.29065,3.28187,3.27156,3.25983,3.24676,3.2325,3.21729,3.20115,3.18416,3.16655,3.14842,3.1299,3.11107,3.09191,3.07238,3.05243,3.03203,3.0112,2.98998,2.96847,2.94688,2.92545,2.9043,2.88349,2.86303,2.84294,2.82324,2.804,2.78534,2.76731,2.74997,2.73318,2.71695:6.8
2.62326,2.62422,2.62517,2.6261,2.62708,2.62814,2.62931,2.63069,2.63226,2.63397,2.63586,2.63796,2.64028,2.64279,2.64549,2.64842,2.65156,2.65505,2.65892,2.66297,2.66714,2.6714,2.67566,2.67982,2.68391,2.688,2.69205,2.69615,2.70041,2.70489,2.70954,2.71436,2.71941,2.72488,2.73121,2.73885,2.74844,2.76,2.77339,2.78845,2.8049,2.82252,2.84115,2.86078,2.88162,2.90423,2.92933,2.95826,2.99188,3.0309,3.07557,3.12516,3.17751,3.22914,3.27598,3.31469,3.34398,3.36462,3.37873,3.38839,3.39516,3.39984,3.40278,3.40391,3.40302,3.40004,3.39498,3.38792,3.37902,3.36845,3.35637,3.34285,3.32799,3.31195,3.2949,3.27689,3.25814,3.23878,3.21895,3.19868,3.17797,3.15683,3.1352,3.11303,3.09033,3.06709,3.0435,3.01984,2.99632,2.97316,2.95032,2.9278,2.90566,2.88394,2.86276,2.84219,2.82237,2.80319,2.78469,2.76671:7.1
2.53274,2.53378,2.53481,2.53585,2.53697,2.53818,2.53951,2.54099,2.54263,2.5445,2.5465,2.5487,2.55107,2.55361,2.55633,2.55924,2.56241,2.56584,2.5696,2.57357,2.57775,2.58204,2.58637,2.59068,2.59492,2.59911,2.6032,2.60736,2.61156,2.6159,2.62036,2.62487,2.62951,2.63447,2.64009,2.6468,2.65507,2.66487,2.67618,2.68876,2.70237,2.71671,2.73159,2.747,2.76309,2.78045,2.79978,2.82239,2.84889,2.87995,2.91579,2.95586,2.99839,3.04046,3.07866,3.11014,3.13363,3.1497,3.15988,3.16612,3.16963,3.17132,3.17141,3.16987,3.16659,3.16147,3.1545,3.14582,3.13554,3.12376,3.11065,3.09635,3.08096,3.06462,3.04738,3.02944,3.01082,2.9918,2.97245,2.95281,2.93287,2.91261,2.89194,2.87083,2.84927,2.8273,2.80503,2.78267,2.76047,2.73857,2.71703,2.69583,2.67496,2.65448,2.63445,2.61498,2.5961,2.5778,2.56,2.54266:7.3
2.99476,3.00045,3.00601,3.0116,3.01721,3.02282,3.02849,3.03421,3.03999,3.04597,3.05204,3.05822,3.06448,3.07084,3.07732,3.08396,3.09079,3.09787,3.10507,3.11249,3.12009,3.1278,3.13549,3.14306,3.15051,3.15793,3.16533,3.17275,3.18021,3.1877,3.19525,3.20284,3.21048,3.21832,3.22664,3.23576,3.24606,3.25761,3.27036,3.28418,3.29886,3.3142,3.33004,3.34639,3.36346,3.38163,3.40144,3.42399,3.44992,3.47988,3.51409,3.55209,3.59226,3.63198,3.6682,3.6983,3.72102,3.73672,3.74682,3.75309,3.75677,3.75866,3.75902,3.75774,3.75482,3.75017,3.74378,3.73578,3.72632,3.71554,3.70355,3.69045,3.67636,3.66135,3.64563,3.62938,3.61252,3.59533,3.57788,3.56021,3.54236,3.52425,3.50586,3.48712,3.46808,3.44874,3.42922,3.40971,3.39038,3.37132,3.35257,3.33414,3.31602,3.29827,3.28089,3.26402,3.24762,3.23169,3.21628,3.20131:7.8
2.46943,2.46967,2.46997,2.47022,2.47056,2.47102,2.47162,2.47245,2.47348,2.47471,2.47612,2.47776,2.47966,2.48178,2.48413,2.48676,2.48968,2.49298,2.49663,2.50058,2.50478,2.50909,2.51337,2.51755,2.52168,2.52574,2.5299,2.53416,2.53864,2.54339,2.54837,2.55355,2.55898,2.56486,2.5716,2.57965,2.58971,2.60179,2.6157,2.63122,2.64798,2.66564,2.68395,2.70293,2.72295,2.7446,2.76873,2.79692,2.82989,2.86839,2.91273,2.96225,3.0148,3.06687,3.11436,3.15379,3.18361,3.20455,3.21859,3.22789,3.2341,3.23824,3.2406,3.24112,3.23966,3.23609,3.23037,3.22265,3.21315,3.202,3.18939,3.17541,3.16017,3.14382,3.12655,3.10846,3.08965,3.07041,3.05076,3.03082,3.01055,2.98992,2.96887,2.94731,2.9252,2.9026,2.8797,2.85671,2.83388,2.81141,2.78935,2.76771,2.74643,2.72555,2.70518,2.68547,2.66639,2.64796,2.63005,2.61266:9.0
3.57138,3.5816,3.59165,3.60163,3.61153,3.62135,3.63113,3.6409,3.65073,3.66056,3.67041,3.6804,3.69047,3.70058,3.71076,3.72103,3.73144,3.7421,3.75292,3.76408,3.77542,3.78679,3.79813,3.80938,3.82051,3.83146,3.84237,3.85338,3.8645,3.87568,3.88692,3.89825,3.90961,3.92108,3.93306,3.94584,3.96,3.97551,3.99234,4.01028,4.02896,4.04811,4.06755,4.0872,4.10725,4.12832,4.15124,4.1772,4.20687,4.24094,4.27983,4.32318,4.36949,4.41622,4.46031,4.49899,4.53057,4.55488,4.57284,4.58592,4.59574,4.60358,4.60939,4.61331,4.61522,4.61499,4.61273,4.60849,4.60255,4.5951,4.58599,4.57547,4.56354,4.55056,4.53677,4.52221,4.50686,4.49093,4.47484,4.45828,4.44151,4.42448,4.40703,4.38926,4.37098,4.35216,4.33298,4.31372,4.29471,4.27606,4.25772,4.23973,4.22206,4.2046,4.18749,4.17078,4.15465,4.13888,4.1234,4.10817:10.0
3.24882,3.25481,3.26085,3.267,3.27328,3.27958,3.28588,3.2923,3.29888,3.3057,3.31264,3.31982,3.32723,3.3348,3.34253,3.35048,3.35872,3.36722,3.37607,3.3852,3.39461,3.40415,3.41367,3.42304,3.43224,3.4415,3.45062,3.45985,3.46922,3.4788,3.48856,3.49844,3.50836,3.51849,3.52917,3.54092,3.5543,3.56925,3.58553,3.60287,3.62086,3.6392,3.65758,3.67585,3.69446,3.7141,3.7359,3.76145,3.79112,3.82598,3.86631,3.91172,3.95994,4.00763,4.0512,4.08728,4.11402,4.13218,4.14346,4.15047,4.15379,4.15524,4.15499,4.15278,4.14849,4.14211,4.13375,4.12338,4.11106,4.09719,4.08208,4.06574,4.04797,4.0291,4.00968,3.98926,3.96821,3.94671,3.925,3.90291,3.88053,3.85782,3.83462,3.81086,3.78651,3.7617,3.73673,3.71177,3.68694,3.66238,3.63821,3.61438,3.59086,3.56787,3.54536,3.52347,3.50214,3.48134,3.46092,3.44076:10.5
2.23103,2.23081,2.2307,2.23064,2.23062,2.23071,2.23097,2.23138,2.23193,2.23281,2.23381,2.23504,2.23652,2.23822,2.24019,2.24247,2.24507,2.24806,2.25145,2.2551,2.25899,2.2629,2.26673,2.27043,2.27401,2.27753,2.2812,2.28515,2.2894,2.29399,2.29889,2.30401,2.30935,2.31503,2.32144,2.32904,2.33857,2.34978,2.36258,2.37662,2.39145,2.40672,2.42225,2.43819,2.45499,2.4734,2.49437,2.51939,2.54905,2.58402,2.62439,2.66927,2.71649,2.76279,2.80461,2.83919,2.86551,2.88433,2.89759,2.90696,2.9138,2.91895,2.92258,2.92458,2.92477,2.92307,2.91955,2.91434,2.90751,2.89922,2.8896,2.87881,2.86685,2.8538,2.83987,2.82516,2.80978,2.79394,2.77767,2.7611,2.74416,2.72681,2.70901,2.6907,2.67178,2.65228,2.63238,2.61235,2.59246,2.57285,2.55357,2.53461,2.51595,2.49756,2.47958,2.46208,2.44513,2.42868,2.41263,2.39692:11.0
2.29172,2.29224,2.29277,2.29329,2.29389,2.29465,2.2956,2.29675,2.29811,2.29968,2.30147,2.30355,2.30592,2.30856,2.31143,2.31465,2.31824,2.32228,2.32684,2.33178,2.33695,2.34214,2.34723,2.35219,2.35703,2.36181,2.36665,2.37183,2.37744,2.38358,2.39012,2.39687,2.40376,2.41095,2.41894,2.42828,2.4396,2.45276,2.46755,2.48354,2.50012,2.51686,2.53352,2.55019,2.56749,2.58636,2.60802,2.63421,2.66559,2.70287,2.74618,2.79458,2.84585,2.89648,2.94249,2.98078,3.0101,3.03125,3.04622,3.05691,3.0649,3.07107,3.07558,3.07833,3.07912,3.07791,3.07481,3.06985,3.06313,3.05481,3.04504,3.03395,3.02167,3.00827,2.99386,2.97852,2.96252,2.94601,2.92911,2.91178,2.89407,2.87596,2.85735,2.83813,2.8182,2.7976,2.77645,2.75508,2.73384,2.71296,2.69248,2.67232,2.6524,2.6328,2.61362,2.59492,2.5767,2.55889,2.54148,2.52447:12.2
2.99463,3.00099,3.00726,3.01352,3.01982,3.02616,3.03256,3.039,3.04554,3.05228,3.05918,3.06617,3.07327,3.0805,3.08791,3.09552,3.10337,3.11147,3.11982,3.12844,3.13738,3.14652,3.15572,3.16482,3.17371,3.18251,3.19128,3.20023,3.20954,3.21914,3.22896,3.23888,3.24882,3.25892,3.26955,3.28119,3.29441,3.30915,3.3252,3.34209,3.35914,3.37579,3.39163,3.40664,3.42139,3.43685,3.45432,3.47547,3.50098,3.53169,3.56779,3.60868,3.65261,3.69652,3.73679,3.77034,3.79578,3.81363,3.8255,3.83309,3.83786,3.84071,3.84187,3.84139,3.83917,3.8352,3.82936,3.82172,3.81257,3.80207,3.79039,3.77767,3.76395,3.74932,3.73393,3.718,3.70163,3.68507,3.66837,3.65151,3.63449,3.61725,3.59977,3.5819,3.56352,3.5446,3.52526,3.50581,3.48656,3.46772,3.44931,3.43125,3.41345,3.3959,3.37868,3.36182,3.34531,3.32905,3.31284,3.29672:14.0
3.15492,3.16084,3.16672,3.17258,3.1785,3.1845,3.19064,3.19703,3.20365,3.21042,3.21748,3.22473,3.23218,3.23991,3.24796,3.25639,3.26518,3.27436,3.28397,3.29409,3.30457,3.31526,3.32592,3.3364,3.34667,3.35675,3.36688,3.37729,3.38816,3.39954,3.4113,3.42319,3.43506,3.44704,3.45958,3.47342,3.48919,3.50666,3.52548,3.54497,3.5643,3.58275,3.5999,3.61587,3.63145,3.64806,3.66742,3.69166,3.72168,3.75828,3.80148,3.85036,3.90266,3.95481,4.0026,4.04258,4.07322,4.09521,4.11071,4.12151,4.12931,4.13493,4.13866,4.1404,4.14008,4.13765,4.1331,4.12647,4.11795,4.10775,4.096,4.08284,4.06843,4.05281,4.03613,4.01851,4.00024,3.98156,3.96253,3.94322,3.9236,3.90359,3.88307,3.86187,3.83984,3.81698,3.79347,3.76971,3.74612,3.72298,3.70034,3.6781,3.65612,3.63443,3.61308,3.59219,3.57161,3.55126,3.53098,3.51084:15.9
2.65472,2.65579,2.65681,2.6579,2.65911,2.66053,2.66221,2.66413,2.66629,2.66873,2.67152,2.67465,2.67811,2.68191,2.68606,2.69062,2.69564,2.70116,2.70712,2.71352,2.72014,2.72679,2.7333,2.73958,2.74567,2.75166,2.75778,2.76435,2.77156,2.7795,2.78806,2.79698,2.80607,2.81534,2.82521,2.83632,2.84933,2.86403,2.88009,2.89698,2.91401,2.93057,2.94632,2.96134,2.97634,2.99244,3.01117,3.03455,3.06335,3.09839,3.13999,3.18742,3.23865,3.29011,3.33742,3.37667,3.4058,3.42545,3.43764,3.44472,3.44859,3.45023,3.44988,3.44751,3.44317,3.43675,3.42823,3.41768,3.40527,3.39121,3.37569,3.35894,3.34109,3.32232,3.30269,3.28219,3.26108,3.23965,3.21806,3.1963,3.17432,3.15207,3.12948,3.10637,3.08268,3.05845,3.03384,3.00917,2.98471,2.96069,2.93729,2.9145,2.89222,2.87035,2.84895,2.82801,2.80755,2.78759,2.76793,2.74865:16.5
2.47687,2.47783,2.47875,2.4797,2.48078,2.48203,2.48349,2.48521,2.48718,2.48942,2.49195,2.49477,2.49797,2.50153,2.50548,2.50988,2.51472,2.52022,2.52621,2.53268,2.53946,2.54631,2.55297,2.55931,2.56539,2.57138,2.57767,2.58449,2.59213,2.60063,2.60984,2.61943,2.62915,2.63905,2.64956,2.66138,2.67527,2.69102,2.70806,2.72578,2.74331,2.75995,2.77536,2.78973,2.804,2.81955,2.83806,2.86174,2.8914,2.92776,2.97086,3.01978,3.07222,3.12453,3.17252,3.21267,3.24345,3.26554,3.28097,3.29188,3.29977,3.30574,3.30989,3.31222,3.31254,3.31077,3.30696,3.30125,3.29379,3.28472,3.27422,3.26239,3.24941,3.23533,3.22025,3.20437,3.18775,3.17067,3.15335,3.13581,3.11799,3.09981,3.08112,3.06177,3.04164,3.02072,2.99921,2.97744,2.95581,2.93462,2.91393,2.8937,2.87381,2.85421,2.8349,2.81594,2.79734,2.77896,2.76081,2.74286:17.7
2.96706,2.97199,2.97683,2.98166,2.98654,2.99151,2.99664,3.00192,3.00742,3.01312,3.01897,3.025,3.03125,3.03772,3.04443,3.05148,3.05888,3.06661,3.0748,3.08335,3.09222,3.10123,3.11015,3.11887,3.12737,3.13577,3.14415,3.15288,3.16213,3.17194,3.1822,3.19269,3.20325,3.21389,3.22495,3.23699,3.25062,3.26566,3.28172,3.29819,3.31433,3.32947,3.34325,3.35581,3.36794,3.38087,3.39606,3.41551,3.43997,3.47019,3.50632,3.54758,3.59207,3.63669,3.67775,3.7121,3.7382,3.75644,3.76848,3.7762,3.78099,3.78382,3.78498,3.78447,3.7822,3.77808,3.77204,3.7642,3.75475,3.74386,3.73169,3.71839,3.7041,3.68889,3.67281,3.656,3.63863,3.62103,3.60328,3.58534,3.5673,3.54895,3.53023,3.51099,3.49111,3.47058,3.4495,3.42818,3.40701,3.38622,3.36591,3.34607,3.3265,3.30716,3.28802,3.26913,3.25053,3.23212,3.21381,3.19558:18.8
2.69311,2.69501,2.69693,2.69885,2.70091,2.70316,2.70565,2.70845,2.7115,2.7149,2.71869,2.7228,2.72731,2.7323,2.73783,2.74392,2.75061,2.75793,2.7659,2.7744,2.78322,2.79204,2.80058,2.80864,2.81627,2.82377,2.83158,2.84036,2.85036,2.86172,2.87413,2.8871,2.9002,2.91332,2.92691,2.94174,2.95861,2.97725,2.99688,3.01651,3.0349,3.05095,3.06407,3.07457,3.08372,3.09358,3.1066,3.12543,3.15101,3.18406,3.2247,3.27191,3.3233,3.37512,3.42306,3.46342,3.4944,3.51657,3.53201,3.5428,3.55054,3.55635,3.56033,3.56245,3.56262,3.56074,3.55683,3.55099,3.54338,3.53418,3.52357,3.51167,3.49866,3.48455,3.46959,3.45374,3.43716,3.42007,3.40278,3.38541,3.36787,3.34993,3.33149,3.31233,3.29224,3.27117,3.24929,3.22701,3.20488,3.18329,3.16235,3.142,3.12207,3.10234,3.08282,3.06349,3.04427,3.02498,3.00555,2.98611:23.4
3.05898,3.06231,3.06561,3.06896,3.07245,3.07616,3.08014,3.08444,3.08901,3.09404,3.09936,3.10514,3.11142,3.11828,3.12573,3.13382,3.14263,3.15215,3.16241,3.17334,3.18469,3.19603,3.20696,3.21729,3.22719,3.23695,3.24726,3.25863,3.27157,3.28614,3.30203,3.31862,3.33535,3.35207,3.36924,3.38766,3.40824,3.43065,3.45396,3.47681,3.49766,3.51518,3.52877,3.5389,3.54724,3.55637,3.56896,3.58817,3.61508,3.65042,3.69415,3.74519,3.80093,3.8573,3.9095,3.9535,3.98738,4.01192,4.0291,4.04116,4.04993,4.0564,4.06088,4.06334,4.06372,4.06187,4.05774,4.05148,4.04334,4.0336,4.02237,4.00984,3.99607,3.98127,3.96548,3.94893,3.93166,3.91399,3.89619,3.87842,3.86048,3.84221,3.8234,3.80384,3.78331,3.7617,3.73916,3.71622,3.69355,3.67159,3.65044,3.62993,3.60982,3.5899,3.5701,3.55045,3.53083,3.51098,3.49082,3.47049:26.7
3.28923,3.29435,3.29952,3.30482,3.31024,3.31584,3.32175,3.32799,3.33462,3.34161,3.34884,3.35658,3.36484,3.37365,3.38304,3.39305,3.40377,3.41512,3.42711,3.4398,3.45325,3.46712,3.48094,3.49437,3.50743,3.52031,3.53333,3.54702,3.56211,3.57889,3.59706,3.6159,3.63477,3.65344,3.6723,3.69241,3.71491,3.73952,3.76504,3.7901,3.81303,3.83228,3.84694,3.85717,3.86438,3.87121,3.88087,3.89714,3.9213,3.95425,3.99568,4.0447,4.09892,4.15442,4.20617,4.24958,4.28242,4.30494,4.31881,4.32701,4.33287,4.3362,4.33732,4.33575,4.33218,4.32636,4.31847,4.30851,4.29635,4.28259,4.26773,4.25157,4.23451,4.21601,4.1967,4.17603,4.15489,4.1336,4.11297,4.09191,4.07025,4.04831,4.02608,4.00345,3.97974,3.95469,3.92851,3.9018,3.87532,3.84964,3.82507,3.80137,3.77789,3.75457,3.73154,3.70883,3.68601,3.66249,3.63866,3.61474:28.3
2.40898,2.40986,2.41082,2.41182,2.41295,2.41429,2.41586,2.41772,2.41995,2.42252,2.42542,2.42869,2.43242,2.43671,2.44157,2.44697,2.453,2.45975,2.46721,2.47521,2.48347,2.4916,2.49931,2.50646,2.51319,2.51987,2.52715,2.53548,2.54527,2.5566,2.56911,2.58223,2.59545,2.60859,2.62196,2.63625,2.65215,2.66921,2.6866,2.70322,2.71789,2.7296,2.738,2.74359,2.74785,2.7528,2.76067,2.77401,2.79356,2.81999,2.85324,2.8923,2.9349,2.97775,3.01714,3.05001,3.07493,3.09235,3.10399,3.11156,3.11656,3.11972,3.12141,3.12155,3.11999,3.1167,3.11165,3.10499,3.09696,3.08772,3.07742,3.06622,3.05418,3.04141,3.02801,3.01401,2.9996,2.98499,2.97038,2.95584,2.94129,2.92655,2.91145,2.89583,2.8795,2.86235,2.84455,2.82649,2.80863,2.79135,2.77475,2.7587,2.74299,2.72747,2.71202,2.69663,2.68122,2.6656,2.64974,2.63371:28.9
3.14612,3.15093,3.15574,3.16061,3.16566,3.17092,3.17644,3.18231,3.18861,3.1954,3.20245,3.20985,3.21775,3.22624,3.23537,3.24517,3.25556,3.2667,3.27861,3.29134,3.3048,3.31867,3.33254,3.34605,3.35915,3.37205,3.38531,3.39957,3.41547,3.43327,3.45262,3.47275,3.49282,3.51247,3.5323,3.55355,3.57744,3.60341,3.6303,3.65631,3.67926,3.69716,3.70879,3.7144,3.716,3.71688,3.7209,3.7322,3.75223,3.78176,3.82068,3.86774,3.92017,3.97382,4.02388,4.06629,4.09921,4.12302,4.13973,4.15158,4.1602,4.16684,4.17153,4.17428,4.17503,4.17365,4.17011,4.16454,4.1572,4.14828,4.13792,4.12622,4.11329,4.09934,4.08432,4.06839,4.05181,4.03479,4.0177,4.00064,3.98351,3.9661,3.94809,3.92913,3.90887,3.88703,3.86381,3.83995,3.81634,3.79357,3.77165,3.75041,3.72952,3.70873,3.68796,3.66707,3.64591,3.62403,3.60136,3.57803:31.1
2.99043,2.99504,2.99975,3.00449,3.0093,3.01429,3.01953,3.02504,3.03088,3.03697,3.04342,3.05019,3.05736,3.06499,3.07312,3.0818,3.09101,3.10082,3.1113,3.12241,3.13405,3.14591,3.15759,3.16888,3.17979,3.19058,3.20176,3.21391,3.2275,3.24268,3.25914,3.2762,3.29322,3.30991,3.32666,3.34446,3.364,3.38484,3.40599,3.42597,3.44324,3.45645,3.46496,3.46925,3.47094,3.47257,3.47697,3.48724,3.5045,3.52944,3.56199,3.60112,3.64452,3.68862,3.72937,3.76341,3.78912,3.80682,3.81811,3.82504,3.82903,3.83115,3.83168,3.83052,3.82759,3.82278,3.81611,3.8077,3.79779,3.78665,3.77442,3.76123,3.74714,3.73218,3.71657,3.70037,3.68374,3.66693,3.65021,3.63358,3.61697,3.6002,3.58302,3.56519,3.54647,3.52671,3.50609,3.4851,3.46431,3.44414,3.42474,3.40597,3.38753,3.36922,3.35091,3.33253,3.31386,3.29475,3.27505,3.25491:33.7
2.81424,2.81871,2.82315,2.82763,2.83221,2.83694,2.84185,2.84701,2.85241,2.85812,2.86408,2.87033,2.87695,2.88398,2.89144,2.89943,2.90789,2.917,2.92665,2.93687,2.94764,2.95861,2.96942,2.97991,2.99003,3.00002,3.0103,3.02155,3.03419,3.04832,3.06359,3.07941,3.09519,3.11069,3.12635,3.14293,3.161,3.18021,3.19947,3.21746,3.23262,3.24365,3.24994,3.25199,3.25146,3.25071,3.25242,3.25952,3.27296,3.29327,3.32027,3.35296,3.38931,3.42633,3.46065,3.48949,3.51149,3.52691,3.53712,3.54364,3.54779,3.55031,3.55143,3.55118,3.54947,3.54622,3.54143,3.5352,3.52776,3.51933,3.51002,3.49987,3.48902,3.47756,3.46551,3.453,3.44012,3.42721,3.41444,3.40185,3.38937,3.37678,3.36384,3.3503,3.33593,3.32062,3.30451,3.28804,3.27177,3.2561,3.24113,3.22668,3.2125,3.19839,3.18422,3.16992,3.15522,3.14002,3.12421,3.10789:35.2
3.23021,3.23348,3.23678,3.24026,3.24399,3.24807,3.25256,3.25751,3.26301,3.26927,3.27614,3.28372,3.29211,3.30149,3.31198,3.32363,3.33644,3.35051,3.36576,3.38206,3.39891,3.41563,3.43147,3.44599,3.45941,3.47253,3.48661,3.50306,3.52262,3.54558,3.57136,3.59867,3.62606,3.65278,3.67927,3.70684,3.73698,3.76901,3.80111,3.83084,3.85523,3.87165,3.87893,3.87801,3.87203,3.8656,3.86359,3.87088,3.88918,3.91934,3.96119,4.01319,4.07223,4.13339,4.19084,4.23958,4.27703,4.30365,4.32186,4.33418,4.3428,4.34894,4.35309,4.35499,4.35458,4.35181,4.34669,4.33938,4.33007,4.31906,4.30664,4.29293,4.27821,4.26253,4.24569,4.22792,4.20958,4.19088,4.17231,4.1541,4.13591,4.11746,4.09841,4.07842,4.05695,4.03358,4.00854,3.98264,3.957,3.93248,3.90926,3.88707,3.86537,3.84375,3.82193,3.79978,3.77693,3.75293,3.72764,3.70141:38.5
2.91042,2.91224,2.91419,2.91639,2.9189,2.92185,2.92538,2.92956,2.93438,2.94,2.94634,2.95354,2.96176,2.97117,2.98193,2.99411,3.00767,3.0227,3.0392,3.05696,3.07544,3.09366,3.11071,3.1262,3.14052,3.15459,3.16998,3.18836,3.21061,3.23699,3.2667,3.29807,3.32934,3.35954,3.3891,3.41952,3.45203,3.48575,3.51835,3.5466,3.56697,3.57646,3.57384,3.56064,3.54114,3.52105,3.50589,3.50111,3.508,3.52723,3.55833,3.59951,3.64751,3.69765,3.74477,3.78466,3.81523,3.8369,3.85168,3.86166,3.86871,3.87382,3.87724,3.87893,3.87869,3.87641,3.87222,3.8663,3.85894,3.85044,3.84093,3.83057,3.81947,3.80779,3.79545,3.78248,3.76899,3.7555,3.74245,3.72989,3.71769,3.70547,3.69275,3.67895,3.66339,3.64573,3.62625,3.60585,3.58577,3.5669,3.54949,3.53316,3.51721,3.50109,3.48442,3.46696,3.44816,3.42762,3.40528,3.38148:46.3
