/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteBytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ByteByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteByteMaps;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ByteByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableByteByteSingletonMap
implements ImmutableByteByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final byte key1;
    private final byte value1;

    ImmutableByteByteSingletonMap(byte key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public byte get(byte key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getIfAbsent(byte key, byte ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public byte getOrThrow(byte key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(ByteByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyByteIterable keysView() {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<ByteBytePair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableByteByteMap flipUniqueValues() {
        return ByteByteMaps.immutable.with(this.value1, this.key1);
    }

    @Override
    public ImmutableByteByteMap select(ByteBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ByteByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ByteByteHashMap().toImmutable();
    }

    @Override
    public ImmutableByteByteMap reject(ByteBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ByteByteHashMap().toImmutable() : ByteByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with(ByteBags.immutable.with(this.value1));
    }

    @Override
    public ImmutableByteByteMap toImmutable() {
        return this;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(ByteByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    @Override
    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public byte min() {
        return this.value1;
    }

    @Override
    public byte max() {
        return this.value1;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableByteBag select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteHashBag.newBagWith(this.value1).toImmutable() : ByteBags.immutable.empty();
    }

    @Override
    public ImmutableByteBag reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteBags.immutable.empty() : ByteHashBag.newBagWith(this.value1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    @Override
    public byte[] toArray(byte[] target) {
        if (target.length < 1) {
            target = new byte[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    @Override
    public boolean contains(byte value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public ImmutableByteByteMap newWithKeyValue(byte key, byte value) {
        return ByteByteMaps.immutable.withAll(ByteByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableByteByteMap newWithoutKey(byte key) {
        return this.key1 == key ? ByteByteMaps.immutable.with() : this;
    }

    @Override
    public ImmutableByteByteMap newWithoutAllKeys(ByteIterable keys) {
        return keys.contains(this.key1) ? ByteByteMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(ByteArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteByteMap)) {
            return false;
        }
        ByteByteMap map = (ByteByteMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

