/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceLastCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceSchemaCacheManager;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public abstract class AbstractUpdateLastCacheOperator
implements ProcessOperator {
    protected static final TsBlock LAST_QUERY_EMPTY_TSBLOCK = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT)).build();
    protected OperatorContext operatorContext;
    protected final DataNodeQueryContext dataNodeQueryContext;
    protected Operator child;
    private final TreeDeviceSchemaCacheManager lastCache;
    private final boolean needUpdateCache;
    private final boolean needUpdateNullEntry;
    protected TsBlockBuilder tsBlockBuilder;
    protected String databaseName;
    protected boolean deviceInMultiRegion;

    protected AbstractUpdateLastCacheOperator(OperatorContext operatorContext, Operator child, TreeDeviceSchemaCacheManager treeDeviceSchemaCacheManager, boolean needUpdateCache, boolean needUpdateNullEntry, boolean deviceInMultiRegion) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.lastCache = treeDeviceSchemaCacheManager;
        this.needUpdateCache = needUpdateCache;
        this.needUpdateNullEntry = needUpdateNullEntry;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder(1);
        this.dataNodeQueryContext = operatorContext.getDriverContext().getFragmentInstanceContext().getDataNodeQueryContext();
        this.deviceInMultiRegion = deviceInMultiRegion;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    protected String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = ((DataDriverContext)this.operatorContext.getDriverContext()).getDataRegion().getDatabaseName();
        }
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mayUpdateLastCache(long time, @Nullable TsPrimitiveType value, MeasurementPath fullPath) {
        if (!this.needUpdateCache) {
            return;
        }
        try {
            this.dataNodeQueryContext.lock(this.deviceInMultiRegion);
            Pair<AtomicInteger, TimeValuePair> seriesScanInfo = this.dataNodeQueryContext.getSeriesScanInfo((PartialPath)fullPath);
            if (seriesScanInfo == null) {
                return;
            }
            if (!this.deviceInMultiRegion) {
                this.lastCache.updateLastCacheIfExists(this.getDatabaseName(), fullPath.getIDeviceID(), new String[]{fullPath.getMeasurement()}, new TimeValuePair[]{Objects.nonNull(value) ? new TimeValuePair(time, value) : (this.needUpdateNullEntry ? TableDeviceLastCache.EMPTY_TIME_VALUE_PAIR : null)}, fullPath.isUnderAlignedEntity(), new IMeasurementSchema[]{fullPath.getMeasurementSchema()});
                return;
            }
            if (seriesScanInfo.right == null || time > ((TimeValuePair)seriesScanInfo.right).getTimestamp()) {
                if (Objects.nonNull(value)) {
                    seriesScanInfo.right = new TimeValuePair(time, value);
                } else {
                    Object object = seriesScanInfo.right = this.needUpdateNullEntry ? TableDeviceLastCache.EMPTY_TIME_VALUE_PAIR : null;
                }
            }
            if (((AtomicInteger)seriesScanInfo.left).decrementAndGet() == 0) {
                this.lastCache.updateLastCacheIfExists(this.getDatabaseName(), fullPath.getIDeviceID(), new String[]{fullPath.getMeasurement()}, new TimeValuePair[]{(TimeValuePair)seriesScanInfo.right}, fullPath.isUnderAlignedEntity(), new IMeasurementSchema[]{fullPath.getMeasurementSchema()});
            }
        }
        finally {
            this.dataNodeQueryContext.unLock(this.deviceInMultiRegion);
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }
}

