/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum BrowseResultMask implements UaEnumeration
{
    None(0),
    ReferenceTypeId(1),
    IsForward(2),
    NodeClass(4),
    BrowseName(8),
    DisplayName(16),
    TypeDefinition(32),
    All(63),
    ReferenceTypeInfo(3),
    TargetInfo(60);

    private final int value;

    private BrowseResultMask(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static BrowseResultMask from(int value) {
        switch (value) {
            case 0: {
                return None;
            }
            case 1: {
                return ReferenceTypeId;
            }
            case 2: {
                return IsForward;
            }
            case 4: {
                return NodeClass;
            }
            case 8: {
                return BrowseName;
            }
            case 16: {
                return DisplayName;
            }
            case 32: {
                return TypeDefinition;
            }
            case 63: {
                return All;
            }
            case 3: {
                return ReferenceTypeInfo;
            }
            case 60: {
                return TargetInfo;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=517");
    }

    public static class Codec
    extends GenericDataTypeCodec<BrowseResultMask> {
        @Override
        public Class<BrowseResultMask> getType() {
            return BrowseResultMask.class;
        }

        @Override
        public BrowseResultMask decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, BrowseResultMask.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowseResultMask value) {
            encoder.writeEnum(null, value);
        }
    }
}

