/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate;

import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.GroupByTimeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.PredicateVisitor;

public class PredicatePushIntoScanChecker
extends PredicateVisitor<Boolean, Void> {
    @Override
    public Boolean visitExpression(Expression expression, Void context) {
        return false;
    }

    @Override
    public Boolean visitInExpression(InExpression inExpression, Void context) {
        Expression inputExpression = inExpression.getExpression();
        return this.checkOperand(inputExpression);
    }

    @Override
    public Boolean visitIsNullExpression(IsNullExpression isNullExpression, Void context) {
        if (!isNullExpression.isNot()) {
            throw new IllegalArgumentException("IS NULL can be pushed down");
        }
        Expression inputExpression = isNullExpression.getExpression();
        if (inputExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            throw new IllegalArgumentException("TIMESTAMP does not support IS NULL/IS NOT NULL");
        }
        return inputExpression.getExpressionType().equals((Object)ExpressionType.TIMESERIES);
    }

    @Override
    public Boolean visitLikeExpression(LikeExpression likeExpression, Void context) {
        Expression inputExpression = likeExpression.getExpression();
        if (inputExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            throw new IllegalArgumentException("TIMESTAMP does not support LIKE/NOT LIKE");
        }
        return inputExpression.getExpressionType().equals((Object)ExpressionType.TIMESERIES);
    }

    @Override
    public Boolean visitRegularExpression(RegularExpression regularExpression, Void context) {
        Expression inputExpression = regularExpression.getExpression();
        if (inputExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            throw new IllegalArgumentException("TIMESTAMP does not support REGEXP/NOT REGEXP");
        }
        return inputExpression.getExpressionType().equals((Object)ExpressionType.TIMESERIES);
    }

    @Override
    public Boolean visitLogicNotExpression(LogicNotExpression logicNotExpression, Void context) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through PredicateRemoveNotRewriter? ");
    }

    @Override
    public Boolean visitLogicAndExpression(LogicAndExpression logicAndExpression, Void context) {
        return (Boolean)this.process(logicAndExpression.getLeftExpression(), context) != false && (Boolean)this.process(logicAndExpression.getRightExpression(), context) != false;
    }

    @Override
    public Boolean visitLogicOrExpression(LogicOrExpression logicOrExpression, Void context) {
        return (Boolean)this.process(logicOrExpression.getLeftExpression(), context) != false && (Boolean)this.process(logicOrExpression.getRightExpression(), context) != false;
    }

    @Override
    public Boolean visitEqualToExpression(EqualToExpression equalToExpression, Void context) {
        return this.processCompareBinaryExpression(equalToExpression);
    }

    @Override
    public Boolean visitNonEqualExpression(NonEqualExpression nonEqualExpression, Void context) {
        return this.processCompareBinaryExpression(nonEqualExpression);
    }

    @Override
    public Boolean visitGreaterThanExpression(GreaterThanExpression greaterThanExpression, Void context) {
        return this.processCompareBinaryExpression(greaterThanExpression);
    }

    @Override
    public Boolean visitGreaterEqualExpression(GreaterEqualExpression greaterEqualExpression, Void context) {
        return this.processCompareBinaryExpression(greaterEqualExpression);
    }

    @Override
    public Boolean visitLessThanExpression(LessThanExpression lessThanExpression, Void context) {
        return this.processCompareBinaryExpression(lessThanExpression);
    }

    @Override
    public Boolean visitLessEqualExpression(LessEqualExpression lessEqualExpression, Void context) {
        return this.processCompareBinaryExpression(lessEqualExpression);
    }

    private Boolean processCompareBinaryExpression(CompareBinaryExpression compareBinaryExpression) {
        Expression leftExpression = compareBinaryExpression.getLeftExpression();
        Expression rightExpression = compareBinaryExpression.getRightExpression();
        return this.checkOperand(leftExpression) != false && rightExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT) || this.checkOperand(rightExpression) != false && leftExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT);
    }

    @Override
    public Boolean visitBetweenExpression(BetweenExpression betweenExpression, Void context) {
        Expression firstExpression = betweenExpression.getFirstExpression();
        Expression secondExpression = betweenExpression.getSecondExpression();
        Expression thirdExpression = betweenExpression.getThirdExpression();
        return this.checkOperand(firstExpression) != false && secondExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT) && thirdExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT) || this.checkOperand(secondExpression) != false && firstExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT) && thirdExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT) || this.checkOperand(thirdExpression) != false && firstExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT) && secondExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT);
    }

    private Boolean checkOperand(Expression expression) {
        return expression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP) || expression.getExpressionType().equals((Object)ExpressionType.TIMESERIES);
    }

    @Override
    public Boolean visitGroupByTimeExpression(GroupByTimeExpression groupByTimeExpression, Void context) {
        throw new IllegalArgumentException("GroupByTime filter cannot exist in value filter.");
    }
}

