/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.BuiltinScalarFunction;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;

public class ShowFunctionsTask
implements IConfigTask {
    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        return configTaskExecutor.showFunctions();
    }

    public static void buildTsBlock(List<ByteBuffer> allUDFInformation, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showFunctionsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        ArrayList<UDFInformation> udfInformations = new ArrayList<UDFInformation>();
        if (allUDFInformation != null && !allUDFInformation.isEmpty()) {
            for (ByteBuffer udfInformationByteBuffer : allUDFInformation) {
                UDFInformation udfInformation = UDFInformation.deserialize((ByteBuffer)udfInformationByteBuffer);
                udfInformations.add(udfInformation);
            }
        }
        udfInformations.addAll(UDFManagementService.getInstance().getAllBuiltInTimeSeriesGeneratingInformation());
        udfInformations.sort(Comparator.comparing(UDFInformation::getFunctionName));
        for (UDFInformation udfInformation : udfInformations) {
            ShowFunctionsTask.appendUDFInformation(builder, udfInformation);
        }
        ShowFunctionsTask.appendNativeFunctions(builder);
        ShowFunctionsTask.appendBuiltInScalarFunctions(builder);
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowFunctionsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static void appendUDFInformation(TsBlockBuilder builder, UDFInformation udfInformation) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)udfInformation.getFunctionName()));
        builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)ShowFunctionsTask.getFunctionType(udfInformation)));
        builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)udfInformation.getClassName()));
        builder.declarePosition();
    }

    private static void appendNativeFunctions(TsBlockBuilder builder) {
        Binary functionType = BytesUtils.valueOf((String)"native");
        Binary className = BytesUtils.valueOf((String)"");
        for (String functionName : BuiltinAggregationFunction.getNativeFunctionNames()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)functionName.toUpperCase()));
            builder.getColumnBuilder(1).writeBinary(functionType);
            builder.getColumnBuilder(2).writeBinary(className);
            builder.declarePosition();
        }
    }

    private static void appendBuiltInScalarFunctions(TsBlockBuilder builder) {
        Binary functionType = BytesUtils.valueOf((String)"built-in scalar");
        Binary className = BytesUtils.valueOf((String)"");
        for (String functionName : BuiltinScalarFunction.getNativeFunctionNames()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)functionName.toUpperCase()));
            builder.getColumnBuilder(1).writeBinary(functionType);
            builder.getColumnBuilder(2).writeBinary(className);
            builder.declarePosition();
        }
    }

    private static String getFunctionType(UDFInformation udfInformation) {
        String functionType = "UNKNOWN";
        if (udfInformation.isBuiltin()) {
            if (UDFManagementService.getInstance().isUDTF(udfInformation.getFunctionName())) {
                functionType = "built-in UDTF";
            } else if (UDFManagementService.getInstance().isUDAF(udfInformation.getFunctionName())) {
                functionType = "built-in UDAF";
            }
        } else if (UDFManagementService.getInstance().isUDTF(udfInformation.getFunctionName())) {
            functionType = "external UDTF";
        } else if (UDFManagementService.getInstance().isUDAF(udfInformation.getFunctionName())) {
            functionType = "external UDAF";
        }
        return functionType;
    }
}

