/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.response;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.apache.iotdb.db.subscription.event.cache.SubscriptionPollResponseCache;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;

public class SubscriptionEventSingleResponse
implements SubscriptionEventResponse<CachedSubscriptionPollResponse> {
    private final CachedSubscriptionPollResponse response;

    public SubscriptionEventSingleResponse(short responseType, SubscriptionPollPayload payload, SubscriptionCommitContext commitContext) {
        this.response = new CachedSubscriptionPollResponse(responseType, payload, commitContext);
    }

    public SubscriptionEventSingleResponse(SubscriptionPollResponse response) {
        this.response = new CachedSubscriptionPollResponse(response);
    }

    @Override
    public CachedSubscriptionPollResponse getCurrentResponse() {
        return this.response;
    }

    @Override
    public void prefetchRemainingResponses() {
    }

    @Override
    public void fetchNextResponse(long offset) {
    }

    @Override
    public void trySerializeCurrentResponse() {
        SubscriptionPollResponseCache.getInstance().trySerialize(this.response);
    }

    @Override
    public void trySerializeRemainingResponses() {
    }

    @Override
    public ByteBuffer getCurrentResponseByteBuffer() throws IOException {
        return SubscriptionPollResponseCache.getInstance().serialize(this.response);
    }

    @Override
    public void invalidateCurrentResponseByteBuffer() {
        SubscriptionPollResponseCache.getInstance().invalidate(this.response);
    }

    @Override
    public void nack() {
        this.invalidateCurrentResponseByteBuffer();
    }

    @Override
    public void cleanUp() {
        this.response.closeMemoryBlock();
        this.invalidateCurrentResponseByteBuffer();
    }

    @Override
    public boolean isCommittable() {
        return true;
    }

    public String toString() {
        return "SubscriptionEventSingleResponse" + this.coreReportMessage();
    }

    protected Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        CachedSubscriptionPollResponse currentResponse = this.getCurrentResponse();
        result.put("currentResponse", Objects.nonNull((Object)currentResponse) ? currentResponse.toString() : "<unknown>");
        return result;
    }
}

