/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.strategy;

import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class SlidingSizeWindowAccessStrategy
implements AccessStrategy {
    private final int windowSize;
    private final int slidingStep;

    public SlidingSizeWindowAccessStrategy(int windowSize, int slidingStep) {
        this.windowSize = windowSize;
        this.slidingStep = slidingStep;
    }

    public SlidingSizeWindowAccessStrategy(int windowSize) {
        this.windowSize = windowSize;
        this.slidingStep = windowSize;
    }

    @Override
    public void check() {
        if (this.windowSize <= 0) {
            throw new RuntimeException(String.format("Parameter windowSize(%d) should be positive.", this.windowSize));
        }
        if (this.slidingStep <= 0) {
            throw new RuntimeException(String.format("Parameter slidingStep(%d) should be positive.", this.slidingStep));
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getSlidingStep() {
        return this.slidingStep;
    }

    @Override
    public AccessStrategy.AccessStrategyType getAccessStrategyType() {
        return AccessStrategy.AccessStrategyType.SLIDING_SIZE_WINDOW;
    }
}

