/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ServiceFault
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=395");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=397");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=396");
    private final ResponseHeader responseHeader;

    public ServiceFault(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    protected ServiceFault(ServiceFaultBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((ServiceFaultBuilder)b).responseHeader;
    }

    public static ServiceFaultBuilder<?, ?> builder() {
        return new ServiceFaultBuilderImpl();
    }

    public ServiceFaultBuilder<?, ?> toBuilder() {
        return new ServiceFaultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceFault)) {
            return false;
        }
        ServiceFault other = (ServiceFault)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        return !(this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceFault;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ServiceFault(responseHeader=" + this.getResponseHeader() + ")";
    }

    private static final class ServiceFaultBuilderImpl
    extends ServiceFaultBuilder<ServiceFault, ServiceFaultBuilderImpl> {
        private ServiceFaultBuilderImpl() {
        }

        @Override
        protected ServiceFaultBuilderImpl self() {
            return this;
        }

        @Override
        public ServiceFault build() {
            return new ServiceFault(this);
        }
    }

    public static abstract class ServiceFaultBuilder<C extends ServiceFault, B extends ServiceFaultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ServiceFaultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ServiceFault instance, ServiceFaultBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ServiceFault.ServiceFaultBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ServiceFault> {
        @Override
        public Class<ServiceFault> getType() {
            return ServiceFault.class;
        }

        @Override
        public ServiceFault decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            return new ServiceFault(responseHeader);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ServiceFault value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
        }
    }
}

