/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.CachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;

public class MockSchemaFile
implements ISchemaFile {
    private PartialPath storageGroupPath;
    private IDatabaseMNode<ICachedMNode> storageGroupMNode;
    private static final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
    private long fileTail = 0L;
    private final Map<Long, Map<String, ICachedMNode>> mockFile = new HashMap<Long, Map<String, ICachedMNode>>();

    public MockSchemaFile(PartialPath storageGroupPath) {
        this.storageGroupPath = storageGroupPath;
    }

    @Override
    public ICachedMNode init() {
        this.storageGroupMNode = nodeFactory.createDatabaseMNode(null, this.storageGroupPath.getTailNode());
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)this.storageGroupMNode.getAsMNode());
        container.transferAllBufferReceivingToFlushing();
        this.writeMNode((ICachedMNode)this.storageGroupMNode.getAsMNode());
        return MockSchemaFile.cloneMNode((ICachedMNode)this.storageGroupMNode.getAsMNode());
    }

    @Override
    public synchronized boolean updateDatabaseNode(IDatabaseMNode<ICachedMNode> sgNode) throws IOException {
        this.storageGroupMNode = MockSchemaFile.cloneMNode((ICachedMNode)sgNode.getAsMNode()).getAsDatabaseMNode();
        return true;
    }

    @Override
    public synchronized ICachedMNode getChildNode(ICachedMNode parent, String childName) {
        Map<String, ICachedMNode> segment = this.getSegment(parent);
        ICachedMNode result = null;
        if (segment != null && (result = MockSchemaFile.cloneMNode(segment.get(childName))) == null && parent.isDevice()) {
            for (ICachedMNode node : segment.values()) {
                if (!node.isMeasurement() || !childName.equals(node.getAsMeasurementMNode().getAlias())) continue;
                result = MockSchemaFile.cloneMNode(node);
                break;
            }
        }
        return result;
    }

    @Override
    public synchronized Iterator<ICachedMNode> getChildren(ICachedMNode parent) {
        Map<String, ICachedMNode> segment = this.getSegment(parent);
        if (segment == null) {
            return Collections.emptyIterator();
        }
        return new MockSchemaFileIterator(this.getSegment(parent).values().iterator());
    }

    @Override
    public synchronized boolean createSnapshot(File snapshotDir) {
        return false;
    }

    @Override
    public synchronized void writeMNode(ICachedMNode parent) {
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
        long address = container.getSegmentAddress();
        if (container.isVolatile()) {
            address = this.allocateSegment();
            container.setSegmentAddress(address);
        }
        this.write(address, container.getUpdatedChildFlushingBuffer());
        this.write(address, container.getNewChildFlushingBuffer());
    }

    private void write(long address, Map<String, ICachedMNode> nodeMap) {
        for (ICachedMNode node : nodeMap.values()) {
            ICachedMNodeContainer container;
            if (!node.isMeasurement() && (container = ICachedMNodeContainer.getCachedMNodeContainer(node)).isVolatile()) {
                container.setSegmentAddress(this.allocateSegment());
            }
            this.mockFile.get(address).put(node.getName(), MockSchemaFile.cloneMNode(node));
        }
    }

    @Override
    public synchronized void delete(ICachedMNode targetNode) {
        ICachedMNode removedNode = this.getSegment((ICachedMNode)targetNode.getParent()).remove(targetNode.getName());
        if (removedNode == null || removedNode.isMeasurement()) {
            return;
        }
        this.deleteMNodeRecursively(removedNode);
    }

    private void deleteMNodeRecursively(ICachedMNode node) {
        ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(node);
        Map<String, ICachedMNode> removedSegment = this.mockFile.remove(container.getSegmentAddress());
        if (removedSegment != null) {
            for (ICachedMNode child : removedSegment.values()) {
                this.deleteMNodeRecursively(child);
            }
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void clear() {
        this.mockFile.clear();
    }

    private long getSegmentAddress(ICachedMNode node) {
        return ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress();
    }

    private Map<String, ICachedMNode> getSegment(ICachedMNode node) {
        return this.mockFile.get(this.getSegmentAddress(node));
    }

    private long allocateSegment() {
        long address = this.fileTail++;
        this.mockFile.put(address, new ConcurrentHashMap());
        return address;
    }

    static ICachedMNode cloneMNode(ICachedMNode node) {
        if (node == null) {
            return null;
        }
        if (node.isMeasurement()) {
            IMeasurementMNode measurementMNode = node.getAsMeasurementMNode();
            ICachedMNode result = (ICachedMNode)nodeFactory.createMeasurementMNode(null, measurementMNode.getName(), measurementMNode.getSchema(), measurementMNode.getAlias()).getAsMNode();
            result.getAsMeasurementMNode().setOffset(measurementMNode.getOffset());
            result.getAsMeasurementMNode().setPreDeleted(measurementMNode.isPreDeleted());
            return result;
        }
        if (node.isDatabase() && node.isDevice()) {
            ICachedMNode result = (ICachedMNode)nodeFactory.createDatabaseDeviceMNode(null, node.getName());
            result.getAsDeviceMNode().setAligned(node.getAsDeviceMNode().isAlignedNullable());
            MockSchemaFile.cloneInternalMNodeData(node, result);
            return result;
        }
        if (node.isDevice()) {
            ICachedMNode result = (ICachedMNode)nodeFactory.createDeviceMNode(null, node.getName()).getAsMNode();
            result.getAsDeviceMNode().setAligned(node.getAsDeviceMNode().isAlignedNullable());
            result.getAsDeviceMNode().setSchemaTemplateId(node.getAsDeviceMNode().getSchemaTemplateIdWithState());
            result.getAsDeviceMNode().setUseTemplate(node.getAsDeviceMNode().isUseTemplate());
            MockSchemaFile.cloneInternalMNodeData(node, result);
            return result;
        }
        if (node.isDatabase()) {
            ICachedMNode result = (ICachedMNode)nodeFactory.createDatabaseMNode(null, node.getName()).getAsMNode();
            MockSchemaFile.cloneInternalMNodeData(node, result);
            return result;
        }
        ICachedMNode result = (ICachedMNode)nodeFactory.createInternalMNode(null, node.getName());
        MockSchemaFile.cloneInternalMNodeData(node, result);
        return result;
    }

    private static void cloneInternalMNodeData(ICachedMNode node, ICachedMNode result) {
        CachedMNodeContainer container = new CachedMNodeContainer();
        container.setSegmentAddress(ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress());
        result.setChildren(container);
    }

    private class MockSchemaFileIterator
    implements Iterator<ICachedMNode> {
        Iterator<ICachedMNode> iterator;

        MockSchemaFileIterator(Iterator<ICachedMNode> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ICachedMNode next() {
            return MockSchemaFile.cloneMNode(this.iterator.next());
        }
    }
}

