/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.ignite3.raft.jraft.util.JRaftSignalHandler;
import org.apache.ignite3.raft.jraft.util.Requires;

public abstract class FileOutputSignalHandler
implements JRaftSignalHandler {
    protected File getOutputFile(String path, String baseFileName) throws IOException {
        FileOutputSignalHandler.makeDir(path);
        String now = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String fileName = baseFileName + "." + now;
        File file = Paths.get(path, fileName).toFile();
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Fail to create file: " + file);
        }
        return file;
    }

    private static void makeDir(String path) throws IOException {
        File dir = Paths.get(path, new String[0]).toFile().getAbsoluteFile();
        if (dir.exists()) {
            Requires.requireTrue(dir.isDirectory(), String.format("[%s] is not directory.", path));
        } else {
            dir.mkdirs();
        }
    }
}

