/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.ignite3.internal.sql.engine.exec.exp.ConverterUtils;
import org.apache.ignite3.internal.sql.engine.exec.exp.NotNullImplementor;
import org.apache.ignite3.internal.sql.engine.exec.exp.RexToLixTranslator;

public class ReflectiveCallNotNullImplementor
implements NotNullImplementor {
    protected final Method method;

    public ReflectiveCallNotNullImplementor(Method method) {
        this.method = method;
    }

    @Override
    public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
        MethodCallExpression callExpr;
        translatedOperands = ConverterUtils.fromInternal(this.method.getParameterTypes(), translatedOperands);
        translatedOperands = ConverterUtils.convertAssignableTypes(this.method.getParameterTypes(), translatedOperands);
        if ((this.method.getModifiers() & 8) != 0) {
            callExpr = Expressions.call((Method)this.method, translatedOperands);
        } else {
            NewExpression target = Expressions.new_(this.method.getDeclaringClass());
            callExpr = Expressions.call((Expression)target, (Method)this.method, translatedOperands);
        }
        if (!this.containsCheckedException(this.method)) {
            return callExpr;
        }
        return translator.handleMethodCheckedExceptions((Expression)callExpr);
    }

    private boolean containsCheckedException(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions == null || exceptions.length == 0) {
            return false;
        }
        for (Class<?> clazz : exceptions) {
            if (RuntimeException.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

