/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.security.authentication.event;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite3.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite3.internal.security.authentication.AuthenticationUtils;
import org.apache.ignite3.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationView;
import org.apache.ignite3.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite3.internal.security.authentication.event.UserEventParameters;

public class UserEventFactory
implements ConfigurationNamedListListener<BasicUserView> {
    private final Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier;

    public UserEventFactory(Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier) {
        this.notifier = notifier;
    }

    @Override
    public CompletableFuture<?> onRename(ConfigurationNotificationEvent<BasicUserView> ctx) {
        AuthenticationView authenticationView = ctx.oldValue(AuthenticationView.class);
        String basicProviderName = AuthenticationUtils.findBasicProviderName(authenticationView.providers());
        return this.notifier.apply(UserEventParameters.removed(basicProviderName, ctx.oldValue().username()));
    }

    @Override
    public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<BasicUserView> ctx) {
        AuthenticationView authenticationView = ctx.oldValue(AuthenticationView.class);
        String basicProviderName = AuthenticationUtils.findBasicProviderName(authenticationView.providers());
        return this.notifier.apply(UserEventParameters.removed(basicProviderName, ctx.oldValue().username()));
    }

    @Override
    public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<BasicUserView> ctx) {
        AuthenticationView authenticationView = ctx.oldValue(AuthenticationView.class);
        String basicProviderName = AuthenticationUtils.findBasicProviderName(authenticationView.providers());
        return this.notifier.apply(UserEventParameters.updated(basicProviderName, ctx.oldValue().username()));
    }
}

