/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.loader;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ignite.migrationtools.config.loader.BeanWrapperSpy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class CustomBeanFactory
extends DefaultListableBeanFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomBeanFactory.class);
    private static final Constructor<?> NULL_BEAN_CONSTRUCTOR;
    private final MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>> propertyTracker;

    public CustomBeanFactory(MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>> tracker) {
        this.propertyTracker = tracker;
    }

    protected BeanWrapper instantiateBean(String beanName, RootBeanDefinition mbd) {
        BeanWrapper wrapper = super.instantiateBean(beanName, mbd);
        return wrapper != null ? new BeanWrapperSpy(this.propertyTracker, wrapper, mbd) : null;
    }

    protected Class<?> determineTargetType(String beanName, RootBeanDefinition mbd, Class<?> ... typesToMatch) {
        try {
            return super.determineTargetType(beanName, mbd, (Class[])typesToMatch);
        }
        catch (CannotLoadBeanClassException ex) {
            LOGGER.warn("Could determineTargetType for bean {}; skipping...", (Object)beanName, (Object)ex);
            return null;
        }
    }

    protected Object createBean(String beanName, RootBeanDefinition mbd, Object[] args) throws BeanCreationException {
        try {
            return super.createBean(beanName, mbd, args);
        }
        catch (BeanCreationException | CannotLoadBeanClassException ex) {
            LOGGER.warn("Could not create bean {}; skipping...", (Object)beanName, (Object)ex);
            try {
                return NULL_BEAN_CONSTRUCTOR.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error("Could not create NULL BEAN", (Throwable)e);
                return null;
            }
        }
    }

    static {
        try {
            Class<?> nullBeanClass = Class.forName("org.springframework.beans.factory.support.NullBean");
            NULL_BEAN_CONSTRUCTOR = nullBeanClass.getDeclaredConstructor(new Class[0]);
            NULL_BEAN_CONSTRUCTOR.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

