/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentMapping;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentMappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentSplitter;
import org.apache.ignite.internal.sql.engine.exec.mapping.IdGenerator;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingContext;
import org.apache.ignite.internal.sql.engine.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteUnionAll;
import org.apache.ignite.internal.sql.engine.rel.IgniteValues;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

class FragmentMapper {
    private static final int MAPPING_ATTEMPTS = 3;
    private final RelMetadataQuery mq;
    private final MappingContext context;
    private final Int2ObjectMap<ExecutionTarget> targets;

    FragmentMapper(RelMetadataQuery mq, MappingContext context, Int2ObjectMap<ExecutionTarget> targets) {
        assert (mq instanceof RelMetadataQueryEx);
        this.mq = mq;
        this.context = context;
        this.targets = targets;
    }

    private Mapping map(Fragment fragment) throws FragmentMappingException {
        Mapping mapping = fragment.root().accept(new MapperVisitor());
        if (fragment.single()) {
            Mapping localNodeMapping = this.newMapping(-1L, this.context.targetFactory().oneOf(List.of(this.context.localNode())));
            try {
                mapping = mapping.colocate(localNodeMapping);
            }
            catch (ColocationMappingException e1) {
                if (fragment.rootFragment()) {
                    throw new FragmentMappingException(e1.getMessage(), (RelNode)fragment.root(), e1);
                }
                Mapping anyNodeMapping = this.newMapping(-1L, this.context.targetFactory().oneOf(this.context.nodes()));
                try {
                    mapping = mapping.colocate(anyNodeMapping);
                }
                catch (ColocationMappingException e2) {
                    throw new FragmentMappingException(e2.getMessage(), (RelNode)fragment.root(), e2);
                }
            }
        }
        mapping.validate();
        return mapping;
    }

    public List<FragmentMapping> map(List<Fragment> fragments, IdGenerator idGenerator) {
        Throwable ex = null;
        boolean lastAttemptSucceed = false;
        Long2ObjectOpenHashMap mappingByFragmentId = new Long2ObjectOpenHashMap();
        for (int attempt = 0; attempt < 3 && !lastAttemptSucceed; ++attempt) {
            Fragment currentFragment = null;
            try {
                Iterator<Fragment> iterator = fragments.iterator();
                while (iterator.hasNext()) {
                    Fragment fragment;
                    currentFragment = fragment = iterator.next();
                    if (mappingByFragmentId.containsKey(fragment.fragmentId())) continue;
                    mappingByFragmentId.put(fragment.fragmentId(), (Object)new Pair((Object)fragment, (Object)this.map(fragment)));
                }
                lastAttemptSucceed = true;
                continue;
            }
            catch (FragmentMappingException mappingException) {
                if (ex == null) {
                    ex = mappingException;
                } else {
                    ex.addSuppressed(mappingException);
                }
                fragments = FragmentMapper.replace(fragments, currentFragment, new FragmentSplitter(idGenerator, mappingException.node()).go(currentFragment));
            }
        }
        if (!lastAttemptSucceed) {
            throw new IgniteInternalException(ErrorGroups.Sql.MAPPING_ERR, "Unable to map query: " + ex.getMessage(), ex);
        }
        return FragmentMapper.adjustMapping((Long2ObjectMap<Pair<Fragment, Mapping>>)mappingByFragmentId).stream().map((? super T pair) -> new FragmentMapping((Fragment)pair.getFirst(), ((Mapping)pair.getSecond()).createColocationGroups())).collect(Collectors.toList());
    }

    private static List<Pair<Fragment, Mapping>> adjustMapping(Long2ObjectMap<Pair<Fragment, Mapping>> mappingByFragmentId) {
        Mapping currentMapping;
        Pair currentPair;
        int i;
        LongList fragmentIds = FragmentMapper.collectFragmentIds(mappingByFragmentId);
        for (i = fragmentIds.size() - 1; i > 0; --i) {
            Mapping newParentMapping;
            currentPair = (Pair)mappingByFragmentId.get(fragmentIds.getLong(i));
            currentMapping = (Mapping)currentPair.getSecond();
            Long targetFragmentId = ((Fragment)currentPair.getFirst()).targetFragmentId();
            assert (targetFragmentId != null);
            Pair parentPair = (Pair)mappingByFragmentId.get(targetFragmentId.longValue());
            Mapping parentMapping = (Mapping)parentPair.getSecond();
            Mapping newCurrentMapping = currentMapping.bestEffortColocate(parentMapping);
            if (newCurrentMapping != null) {
                Fragment currentFragment = (Fragment)currentPair.getFirst();
                mappingByFragmentId.put(currentFragment.fragmentId(), (Object)new Pair((Object)currentFragment, (Object)newCurrentMapping));
                currentMapping = newCurrentMapping;
            }
            if ((newParentMapping = parentMapping.bestEffortColocate(currentMapping)) == null) continue;
            Fragment parentFragment = (Fragment)parentPair.getFirst();
            mappingByFragmentId.put(parentFragment.fragmentId(), (Object)new Pair((Object)parentFragment, (Object)newParentMapping));
        }
        for (i = 1; i < fragmentIds.size(); ++i) {
            currentPair = (Pair)mappingByFragmentId.get(fragmentIds.getLong(i));
            currentMapping = (Mapping)currentPair.getSecond();
            for (IgniteReceiver receiver : ((Fragment)currentPair.getFirst()).remotes()) {
                Mapping newChildMapping;
                Pair childPair = (Pair)mappingByFragmentId.get(receiver.sourceFragmentId());
                Mapping childMapping = (Mapping)childPair.getSecond();
                Mapping newCurrentMapping = currentMapping.bestEffortColocate(childMapping);
                if (newCurrentMapping != null) {
                    Fragment currentFragment = (Fragment)currentPair.getFirst();
                    mappingByFragmentId.put(currentFragment.fragmentId(), (Object)new Pair((Object)currentFragment, (Object)newCurrentMapping));
                    currentMapping = newCurrentMapping;
                }
                if ((newChildMapping = childMapping.bestEffortColocate(currentMapping)) == null) continue;
                Fragment childFragment = (Fragment)childPair.getFirst();
                mappingByFragmentId.put(childFragment.fragmentId(), (Object)new Pair((Object)childFragment, (Object)newChildMapping));
            }
        }
        return fragmentIds.longStream().mapToObj(arg_0 -> mappingByFragmentId.get(arg_0)).collect(Collectors.toList());
    }

    private static LongList collectFragmentIds(Long2ObjectMap<Pair<Fragment, Mapping>> mappingByFragmentId) {
        LongArrayList fragmentIds = new LongArrayList();
        LinkedList<Fragment> toProcess = new LinkedList<Fragment>();
        Fragment root = FragmentMapper.findRootFragment((Collection<Pair<Fragment, Mapping>>)mappingByFragmentId.values());
        toProcess.add(root);
        while (!toProcess.isEmpty()) {
            Fragment current = (Fragment)toProcess.poll();
            fragmentIds.add(current.fragmentId());
            for (IgniteReceiver receiver : current.remotes()) {
                toProcess.add((Fragment)((Pair)mappingByFragmentId.get(receiver.sourceFragmentId())).getFirst());
            }
        }
        return fragmentIds;
    }

    private static Fragment findRootFragment(Collection<Pair<Fragment, Mapping>> fragments) {
        Fragment root = null;
        for (Pair<Fragment, Mapping> pair : fragments) {
            if (!((Fragment)pair.getFirst()).rootFragment()) continue;
            assert (root == null);
            root = (Fragment)pair.getFirst();
        }
        assert (root != null);
        return root;
    }

    private Mapping newMapping(long sourceId, ExecutionTarget target) {
        return new ColocatedMapping(LongSets.singleton((long)sourceId), target);
    }

    private static Mapping combineMappings(List<Mapping> mappings) {
        return new CombinedMapping(mappings);
    }

    private static List<Fragment> replace(List<Fragment> originalFragments, Fragment fragmentToReplace, List<Fragment> replacement) {
        assert (!CollectionUtils.nullOrEmpty(replacement));
        Long2LongOpenHashMap newTargets = new Long2LongOpenHashMap();
        for (Fragment fragment0 : replacement) {
            for (IgniteReceiver remote : fragment0.remotes()) {
                newTargets.put(remote.exchangeId(), fragment0.fragmentId());
            }
        }
        ArrayList<Fragment> newFragments = new ArrayList<Fragment>(originalFragments.size() + replacement.size() - 1);
        for (Fragment fragment : originalFragments) {
            IgniteSender sender;
            long newTargetId;
            if (fragment == fragmentToReplace) {
                fragment = (Fragment)CollectionUtils.first(replacement);
            } else if (!fragment.rootFragment() && (newTargetId = newTargets.getOrDefault((sender = (IgniteSender)fragment.root()).exchangeId(), Long.MIN_VALUE)) != Long.MIN_VALUE) {
                sender = new IgniteSender(sender.getCluster(), sender.getTraitSet(), sender.getInput(), sender.exchangeId(), newTargetId, sender.distribution());
                fragment = new Fragment(fragment.fragmentId(), fragment.correlated(), sender, fragment.remotes(), fragment.tables(), fragment.systemViews());
            }
            newFragments.add(fragment);
        }
        newFragments.addAll(replacement.subList(1, replacement.size()));
        return newFragments;
    }

    private class MapperVisitor
    implements IgniteRelVisitor<Mapping> {
        private MapperVisitor() {
        }

        @Override
        public Mapping visit(IgniteSender rel) {
            return this.mapSingleRel(rel);
        }

        @Override
        public Mapping visit(IgniteFilter rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteTrimExchange rel) {
            return this.mapTrimExchange(rel);
        }

        @Override
        public Mapping visit(IgniteProject rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteNestedLoopJoin rel) {
            return this.mapBiRel((BiRel)rel);
        }

        @Override
        public Mapping visit(IgniteHashJoin rel) {
            return this.mapBiRel((BiRel)rel);
        }

        @Override
        public Mapping visit(IgniteCorrelatedNestedLoopJoin rel) {
            return this.mapBiRel((BiRel)rel);
        }

        @Override
        public Mapping visit(IgniteMergeJoin rel) {
            return this.mapBiRel((BiRel)rel);
        }

        @Override
        public Mapping visit(IgniteIndexScan rel) {
            return this.mapTableScan(rel.sourceId(), rel);
        }

        @Override
        public Mapping visit(IgniteTableScan rel) {
            return this.mapTableScan(rel.sourceId(), rel);
        }

        @Override
        public Mapping visit(IgniteSystemViewScan rel) {
            return this.mapTableScan(rel.sourceId(), rel);
        }

        @Override
        public Mapping visit(IgniteReceiver rel) {
            return this.mapComputableSource(rel.exchangeId());
        }

        @Override
        public Mapping visit(IgniteExchange rel) {
            throw new AssertionError(rel.getClass());
        }

        @Override
        public Mapping visit(IgniteKeyValueGet rel) {
            throw new AssertionError(rel.getClass());
        }

        @Override
        public Mapping visit(IgniteKeyValueModify rel) {
            throw new AssertionError(rel.getClass());
        }

        @Override
        public Mapping visit(IgniteSelectCount rel) {
            throw new AssertionError(rel.getClass());
        }

        @Override
        public Mapping visit(IgniteColocatedHashAggregate rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteMapHashAggregate rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteReduceHashAggregate rel) {
            return this.mapSingleRel(rel);
        }

        @Override
        public Mapping visit(IgniteColocatedSortAggregate rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteMapSortAggregate rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteReduceSortAggregate rel) {
            return this.mapSingleRel(rel);
        }

        @Override
        public Mapping visit(IgniteTableModify rel) {
            return this.mapTableModify(rel);
        }

        @Override
        public Mapping visit(IgniteValues rel) {
            return this.mapComputableSource(rel.sourceId());
        }

        @Override
        public Mapping visit(IgniteUnionAll rel) {
            return this.mapSetOp((SetOp)rel);
        }

        @Override
        public Mapping visit(IgniteSort rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteTableSpool rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteSortedIndexSpool rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteLimit rel) {
            return this.mapSingleRel(rel);
        }

        @Override
        public Mapping visit(IgniteHashIndexSpool rel) {
            return this.mapSingleRel((SingleRel)rel);
        }

        @Override
        public Mapping visit(IgniteSetOp rel) {
            assert (rel instanceof SetOp);
            SetOp rel0 = (SetOp)rel;
            return this.mapSetOp(rel0);
        }

        @Override
        public Mapping visit(IgniteTableFunctionScan rel) {
            return this.mapComputableSource(rel.sourceId());
        }

        @Override
        public Mapping visit(IgniteRel rel) {
            throw new AssertionError((Object)("Unexpected call: " + String.valueOf(rel)));
        }

        private Mapping computeMapping(RelNode relNode) {
            IgniteRel igniteRel = (IgniteRel)relNode;
            return igniteRel.accept(this);
        }

        private Mapping mapSingleRel(SingleRel rel) {
            return this.computeMapping(rel.getInput());
        }

        private Mapping mapBiRel(BiRel rel) {
            RelNode left = rel.getLeft();
            RelNode right = rel.getRight();
            Mapping lhsMapping = this.computeMapping(left);
            if (lhsMapping.failed()) {
                return lhsMapping;
            }
            Mapping rhsMapping = this.computeMapping(right);
            try {
                return lhsMapping.colocate(rhsMapping);
            }
            catch (ColocationMappingException e) {
                IgniteExchange leftExch = new IgniteExchange(rel.getCluster(), left.getTraitSet(), left, TraitUtils.distribution(left));
                IgniteExchange rightExch = new IgniteExchange(rel.getCluster(), right.getTraitSet(), right, TraitUtils.distribution(right));
                RelNode leftVar = rel.copy(rel.getTraitSet(), List.of(leftExch, right));
                RelNode rightVar = rel.copy(rel.getTraitSet(), List.of(left, rightExch));
                RelOptCost leftVarCost = FragmentMapper.this.mq.getCumulativeCost(leftVar);
                RelOptCost rightVarCost = FragmentMapper.this.mq.getCumulativeCost(rightVar);
                assert (leftVarCost != null);
                assert (rightVarCost != null);
                if (leftVarCost.isLt(rightVarCost)) {
                    return new FailedMapping(new FragmentMappingException(e.getMessage(), left, e));
                }
                return new FailedMapping(new FragmentMappingException(e.getMessage(), right, e));
            }
        }

        private Mapping mapSetOp(SetOp rel) {
            if (TraitUtils.distribution((RelNode)rel) == IgniteDistributions.random()) {
                ArrayList<Mapping> mappings = new ArrayList<Mapping>(rel.getInputs().size());
                for (RelNode input : rel.getInputs()) {
                    Mapping mapping = this.computeMapping(input);
                    if (mapping.failed()) {
                        return mapping;
                    }
                    mappings.add(mapping);
                }
                return FragmentMapper.combineMappings(mappings);
            }
            Mapping res = null;
            for (RelNode input : rel.getInputs()) {
                try {
                    if (!(res = res == null ? this.computeMapping(input) : res.colocate(this.computeMapping(input))).failed()) continue;
                    return res;
                }
                catch (ColocationMappingException e) {
                    return new FailedMapping(new FragmentMappingException(e.getMessage(), input, e));
                }
            }
            assert (res != null) : "SetOp without inputs";
            return res;
        }

        private Mapping mapTrimExchange(IgniteTrimExchange rel) {
            RelNode input = rel.getInput();
            Mapping mapping = this.computeMapping(input);
            try {
                return this.mapComputableSource(rel.sourceId()).colocate(mapping);
            }
            catch (ColocationMappingException e) {
                return new FailedMapping(new FragmentMappingException(e.getMessage(), input, e));
            }
        }

        private Mapping mapTableModify(IgniteTableModify rel) {
            RelNode input = rel.getInput();
            Mapping mapping = this.computeMapping(input);
            if (mapping.failed()) {
                return mapping;
            }
            IgniteDataSource igniteDataSource = (IgniteDataSource)rel.getTable().unwrapOrThrow(IgniteDataSource.class);
            ExecutionTarget target = (ExecutionTarget)FragmentMapper.this.targets.get(igniteDataSource.id());
            assert (target != null) : "No colocation group for " + igniteDataSource.id();
            try {
                return FragmentMapper.this.newMapping(rel.sourceId(), target).colocate(mapping);
            }
            catch (ColocationMappingException e) {
                return new FailedMapping(new FragmentMappingException(e.getMessage(), input, e));
            }
        }

        private Mapping mapComputableSource(long sourceId) {
            ExecutionTarget target = FragmentMapper.this.context.targetFactory().someOf(FragmentMapper.this.context.nodes());
            return FragmentMapper.this.newMapping(sourceId, target);
        }

        private Mapping mapTableScan(long sourceId, ProjectableFilterableTableScan rel) {
            IgniteDataSource igniteDataSource = (IgniteDataSource)rel.getTable().unwrapOrThrow(IgniteDataSource.class);
            ExecutionTarget target = (ExecutionTarget)FragmentMapper.this.targets.get(igniteDataSource.id());
            assert (target != null) : "No colocation group for " + igniteDataSource.id();
            return FragmentMapper.this.newMapping(sourceId, target);
        }
    }

    private static interface Mapping {
        public boolean failed();

        public boolean colocated();

        public Mapping colocate(Mapping var1) throws ColocationMappingException;

        @Nullable
        public Mapping bestEffortColocate(Mapping var1);

        public void validate() throws FragmentMappingException;

        public List<ColocationGroup> createColocationGroups();
    }

    private class ColocatedMapping
    implements Mapping {
        private final LongSet sourceIds;
        private final ExecutionTarget target;

        ColocatedMapping(LongSet sourceIds, ExecutionTarget target) {
            this.sourceIds = sourceIds;
            this.target = target;
        }

        @Override
        public boolean failed() {
            return false;
        }

        @Override
        public boolean colocated() {
            return true;
        }

        @Override
        public Mapping colocate(Mapping other) throws ColocationMappingException {
            if (!other.colocated()) {
                throw new ColocationMappingException("Non colocated mapping can't be colocated");
            }
            assert (other instanceof ColocatedMapping) : other.getClass().getCanonicalName();
            ColocatedMapping colocatedMapping = (ColocatedMapping)other;
            ExecutionTarget colocatedTarget = this.target.colocateWith(colocatedMapping.target);
            LongOpenHashSet sourceIds = new LongOpenHashSet((LongCollection)this.sourceIds);
            sourceIds.addAll((LongCollection)colocatedMapping.sourceIds);
            return new ColocatedMapping(LongSets.unmodifiable((LongSet)sourceIds), colocatedTarget);
        }

        @Override
        @Nullable
        public Mapping bestEffortColocate(Mapping other) {
            if (!other.colocated()) {
                return null;
            }
            assert (other instanceof ColocatedMapping) : other.getClass().getCanonicalName();
            ColocatedMapping colocatedMapping = (ColocatedMapping)other;
            ExecutionTarget newTarget = this.target.trimTo(colocatedMapping.target);
            if (newTarget == this.target) {
                return null;
            }
            return new ColocatedMapping(this.sourceIds, newTarget);
        }

        @Override
        public void validate() {
        }

        @Override
        public List<ColocationGroup> createColocationGroups() {
            List<String> nodes = FragmentMapper.this.context.targetFactory().resolveNodes(this.target);
            Int2ObjectMap<NodeWithConsistencyToken> assignments = FragmentMapper.this.context.targetFactory().resolveAssignments(this.target);
            return List.of(new ColocationGroup((LongList)new LongArrayList((LongCollection)this.sourceIds), nodes, assignments));
        }
    }

    private static class CombinedMapping
    implements Mapping {
        private final List<Mapping> mappings;

        CombinedMapping(List<Mapping> mappings) {
            this.mappings = mappings;
        }

        @Override
        public boolean failed() {
            return false;
        }

        @Override
        public boolean colocated() {
            return false;
        }

        @Override
        public Mapping colocate(Mapping other) throws ColocationMappingException {
            throw new ColocationMappingException("Combined mapping can't be colocated");
        }

        @Override
        @Nullable
        public Mapping bestEffortColocate(Mapping other) {
            return null;
        }

        @Override
        public void validate() throws FragmentMappingException {
            for (Mapping mapping : this.mappings) {
                mapping.validate();
            }
        }

        @Override
        public List<ColocationGroup> createColocationGroups() {
            ArrayList<ColocationGroup> groups = new ArrayList<ColocationGroup>();
            for (Mapping mapping : this.mappings) {
                groups.addAll(mapping.createColocationGroups());
            }
            return groups;
        }
    }

    private static class FailedMapping
    implements Mapping {
        private final FragmentMappingException exception;

        FailedMapping(FragmentMappingException exception) {
            this.exception = exception;
        }

        @Override
        public boolean failed() {
            return true;
        }

        @Override
        public boolean colocated() {
            return true;
        }

        @Override
        public Mapping colocate(Mapping other) {
            return this;
        }

        @Override
        @Nullable
        public Mapping bestEffortColocate(Mapping other) {
            return null;
        }

        @Override
        public void validate() throws FragmentMappingException {
            throw this.exception;
        }

        @Override
        public List<ColocationGroup> createColocationGroups() {
            throw new AssertionError((Object)"Should not be called");
        }
    }
}

