/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import org.treesitter.CleanerRunner;
import org.treesitter.TSException;
import org.treesitter.TSLanguageMetadata;
import org.treesitter.TSParser;
import org.treesitter.TSSymbolType;

public abstract class TSLanguage {
    private long ptr;

    protected TSLanguage(long ptr) {
        this.ptr = ptr;
        CleanerRunner.register(this, new TSLanguageCleanAction(ptr));
    }

    protected long getPtr() {
        return this.ptr;
    }

    @Deprecated
    public int version() {
        return TSParser.ts_language_version(this.getPtr());
    }

    public int abiVersion() {
        return TSParser.ts_language_abi_version(this.getPtr());
    }

    public TSLanguageMetadata metadata() {
        return TSParser.ts_language_metadata(this.getPtr());
    }

    public int[] supertypes() {
        return TSParser.ts_language_supertypes(this.getPtr());
    }

    public int[] subtypes(int supertype) {
        return TSParser.ts_language_subtypes(this.getPtr(), supertype);
    }

    public String name() {
        return TSParser.ts_language_name(this.getPtr());
    }

    public int fieldCount() {
        return TSParser.ts_language_field_count(this.getPtr());
    }

    public String fieldNameForId(int id) {
        return TSParser.ts_language_field_name_for_id(this.getPtr(), id);
    }

    public int fieldIdForName(String name) {
        return TSParser.ts_language_field_id_for_name(this.getPtr(), name);
    }

    public TSSymbolType symbolType(int symbol) {
        int type = TSParser.ts_language_symbol_type(this.getPtr(), symbol);
        switch (type) {
            case 0: {
                return TSSymbolType.TSSymbolTypeRegular;
            }
            case 1: {
                return TSSymbolType.TSSymbolTypeAnonymous;
            }
            case 2: {
                return TSSymbolType.TSSymbolTypeSupertype;
            }
            case 3: {
                return TSSymbolType.TSSymbolTypeAuxiliary;
            }
        }
        throw new TSException("Can't handle symbol type: %d" + type);
    }

    public int symbolCount() {
        return TSParser.ts_language_symbol_count(this.getPtr());
    }

    public String symbolName(int symbol) {
        return TSParser.ts_language_symbol_name(this.getPtr(), symbol);
    }

    public int symbolForName(String name, boolean isNamed) {
        return TSParser.ts_language_symbol_for_name(this.getPtr(), name, isNamed);
    }

    public abstract TSLanguage copy();

    protected long copyPtr() {
        return TSParser.ts_language_copy(this.getPtr());
    }

    public int nextState(int state, int symbol) {
        return TSParser.ts_language_next_state(this.ptr, state, symbol);
    }

    public int stateCount() {
        return TSParser.ts_language_state_count(this.ptr);
    }

    public static class TSLanguageCleanAction
    implements Runnable {
        private long ptr;

        public TSLanguageCleanAction(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_language_delete(this.ptr);
        }
    }
}

