/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class RomanNumeralsCompiledPattern
extends CompiledPattern {
    private final boolean upperCase;

    public RomanNumeralsCompiledPattern(Set<PatternModifier> modifiers, boolean upperCase) {
        super(ChronoUnitEnum.MONTHS_IN_YEAR, modifiers);
        this.upperCase = upperCase;
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        String romanNumeral;
        switch (dateTime.getMonth().getValue()) {
            case 1: {
                romanNumeral = "I";
                break;
            }
            case 2: {
                romanNumeral = "II";
                break;
            }
            case 3: {
                romanNumeral = "III";
                break;
            }
            case 4: {
                romanNumeral = "IV";
                break;
            }
            case 5: {
                romanNumeral = "V";
                break;
            }
            case 6: {
                romanNumeral = "VI";
                break;
            }
            case 7: {
                romanNumeral = "VII";
                break;
            }
            case 8: {
                romanNumeral = "VIII";
                break;
            }
            case 9: {
                romanNumeral = "IX";
                break;
            }
            case 10: {
                romanNumeral = "X";
                break;
            }
            case 11: {
                romanNumeral = "XI";
                break;
            }
            default: {
                romanNumeral = "XII";
            }
        }
        if (this.upperCase) {
            return romanNumeral;
        }
        return romanNumeral.toLowerCase(Locale.US);
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        String inputTrimmed = input.substring(inputPosition.getIndex());
        if (inputTrimmed.startsWith(this.upperCase ? "III" : "iii")) {
            inputPosition.setIndex(inputPosition.getIndex() + 3);
            return 3;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "II" : "ii")) {
            inputPosition.setIndex(inputPosition.getIndex() + 2);
            return 2;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "IV" : "iv")) {
            inputPosition.setIndex(inputPosition.getIndex() + 2);
            return 4;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "IX" : "ix")) {
            inputPosition.setIndex(inputPosition.getIndex() + 2);
            return 9;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "I" : "i")) {
            inputPosition.setIndex(inputPosition.getIndex() + 1);
            return 1;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "VIII" : "viii")) {
            inputPosition.setIndex(inputPosition.getIndex() + 4);
            return 8;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "VII" : "vii")) {
            inputPosition.setIndex(inputPosition.getIndex() + 3);
            return 7;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "VI" : "vi")) {
            inputPosition.setIndex(inputPosition.getIndex() + 2);
            return 6;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "V" : "v")) {
            inputPosition.setIndex(inputPosition.getIndex() + 1);
            return 5;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "XII" : "xii")) {
            inputPosition.setIndex(inputPosition.getIndex() + 3);
            return 12;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "XI" : "xi")) {
            inputPosition.setIndex(inputPosition.getIndex() + 2);
            return 11;
        }
        if (inputTrimmed.startsWith(this.upperCase ? "X" : "x")) {
            inputPosition.setIndex(inputPosition.getIndex() + 1);
            return 10;
        }
        throw new ParseException("Unable to parse value", inputPosition.getIndex());
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return 2;
    }
}

